/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools.dsconfig;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.opends.messages.DSConfigMessages;
import org.opends.messages.Message;
import org.opends.messages.ToolMessages;
import org.opends.server.admin.AggregationPropertyDefinition;
import org.opends.server.admin.Configuration;
import org.opends.server.admin.DefinitionDecodingException;
import org.opends.server.admin.IllegalPropertyValueStringException;
import org.opends.server.admin.InstantiableRelationDefinition;
import org.opends.server.admin.ManagedObjectAlreadyExistsException;
import org.opends.server.admin.ManagedObjectDefinition;
import org.opends.server.admin.ManagedObjectNotFoundException;
import org.opends.server.admin.ManagedObjectPath;
import org.opends.server.admin.OptionalRelationDefinition;
import org.opends.server.admin.PropertyDefinition;
import org.opends.server.admin.PropertyException;
import org.opends.server.admin.PropertyOption;
import org.opends.server.admin.RelationDefinition;
import org.opends.server.admin.SingletonRelationDefinition;
import org.opends.server.admin.UndefinedDefaultBehaviorProvider;
import org.opends.server.admin.client.AuthorizationException;
import org.opends.server.admin.client.CommunicationException;
import org.opends.server.admin.client.ConcurrentModificationException;
import org.opends.server.admin.client.ManagedObject;
import org.opends.server.admin.client.ManagedObjectDecodingException;
import org.opends.server.admin.client.ManagementContext;
import org.opends.server.admin.client.MissingMandatoryPropertiesException;
import org.opends.server.admin.client.OperationRejectedException;
import org.opends.server.admin.condition.ContainsCondition;
import org.opends.server.tools.ClientException;
import org.opends.server.tools.dsconfig.ArgumentExceptionFactory;
import org.opends.server.tools.dsconfig.CLIProfile;
import org.opends.server.tools.dsconfig.DSConfig;
import org.opends.server.tools.dsconfig.ManagementContextFactory;
import org.opends.server.tools.dsconfig.PropertyEditorModification;
import org.opends.server.tools.dsconfig.PropertyValueEditor;
import org.opends.server.tools.dsconfig.SubCommandHandler;
import org.opends.server.util.args.Argument;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.StringArgument;
import org.opends.server.util.args.SubCommand;
import org.opends.server.util.args.SubCommandArgumentParser;
import org.opends.server.util.cli.CLIException;
import org.opends.server.util.cli.ConsoleApplication;
import org.opends.server.util.cli.MenuResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SetPropSubCommandHandler
extends SubCommandHandler {
    private static final String OPTION_DSCFG_LONG_ADD = "add";
    private static final String OPTION_DSCFG_LONG_REMOVE = "remove";
    private static final String OPTION_DSCFG_LONG_RESET = "reset";
    private static final String OPTION_DSCFG_LONG_SET = "set";
    private static final Character OPTION_DSCFG_SHORT_ADD = null;
    private static final Character OPTION_DSCFG_SHORT_REMOVE = null;
    private static final Character OPTION_DSCFG_SHORT_RESET = null;
    private static final Character OPTION_DSCFG_SHORT_SET = null;
    private final List<StringArgument> namingArgs;
    private final ManagedObjectPath<?, ?> path;
    private final StringArgument propertyAddArgument;
    private final StringArgument propertyRemoveArgument;
    private final StringArgument propertyResetArgument;
    private final StringArgument propertySetArgument;
    private final SubCommand subCommand;

    public static SetPropSubCommandHandler create(SubCommandArgumentParser parser, ManagedObjectPath<?, ?> path, InstantiableRelationDefinition<?, ?> r) throws ArgumentException {
        return new SetPropSubCommandHandler(parser, path.child(r, "DUMMY"), r);
    }

    public static SetPropSubCommandHandler create(SubCommandArgumentParser parser, ManagedObjectPath<?, ?> path, OptionalRelationDefinition<?, ?> r) throws ArgumentException {
        return new SetPropSubCommandHandler(parser, path.child(r), r);
    }

    public static SetPropSubCommandHandler create(SubCommandArgumentParser parser, ManagedObjectPath<?, ?> path, SingletonRelationDefinition<?, ?> r) throws ArgumentException {
        return new SetPropSubCommandHandler(parser, path.child(r), r);
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MenuResult<Void> modifyManagedObject(ConsoleApplication app, ManagementContext context, ManagedObject<?> mo, SubCommandHandler handler) throws ClientException, CLIException {
        ManagedObjectDefinition<?, Configuration> d = mo.getManagedObjectDefinition();
        Message ufn = d.getUserFriendlyName();
        while (true) {
            Message msg;
            PropertyValueEditor editor = new PropertyValueEditor(app, context);
            if (app.isInteractive()) {
                TreeSet properties = new TreeSet();
                for (PropertyDefinition<?> pd : d.getAllPropertyDefinitions()) {
                    if (pd.hasOption(PropertyOption.HIDDEN) || !app.isAdvancedMode() && pd.hasOption(PropertyOption.ADVANCED)) continue;
                    properties.add(pd);
                }
                MenuResult<Void> result = editor.edit(mo, properties, false);
                if (result.isSuccess() && (result = SetPropSubCommandHandler.checkReferences(app, context, mo, handler)).isAgain()) continue;
                if (result.isQuit()) {
                    if (app.isMenuDrivenMode()) return MenuResult.quit();
                    Message msg2 = DSConfigMessages.INFO_DSCFG_CONFIRM_MODIFY_FAIL.get(ufn);
                    app.printVerboseMessage(msg2);
                    return MenuResult.quit();
                }
                if (result.isCancel()) {
                    return MenuResult.cancel();
                }
            }
            try {
                if (!mo.isModified()) return MenuResult.success();
                mo.commit();
                app.println();
                Message msg3 = DSConfigMessages.INFO_DSCFG_CONFIRM_MODIFY_SUCCESS.get(ufn);
                app.printVerboseMessage(msg3);
                for (PropertyEditorModification mod : editor.getModifications()) {
                    try {
                        handler.getCommandBuilder().addArgument(SetPropSubCommandHandler.createArgument(mod));
                    }
                    catch (ArgumentException ae) {
                        throw new RuntimeException("Unexpected error generating the command builder: " + ae, ae);
                    }
                }
                handler.setCommandBuilderUseful(true);
                return MenuResult.success();
            }
            catch (MissingMandatoryPropertiesException e) {
                if (!app.isInteractive()) throw new ClientException(19, e.getMessageObject(), e);
                app.println();
                ArgumentExceptionFactory.displayMissingMandatoryPropertyException(app, e);
                app.println();
                if (app.confirmAction(DSConfigMessages.INFO_DSCFG_PROMPT_EDIT_AGAIN.get(ufn), true)) continue;
                return MenuResult.cancel();
            }
            catch (AuthorizationException e) {
                msg = DSConfigMessages.ERR_DSCFG_ERROR_MODIFY_AUTHZ.get(ufn);
                throw new ClientException(50, msg);
            }
            catch (ConcurrentModificationException e) {
                msg = DSConfigMessages.ERR_DSCFG_ERROR_MODIFY_CME.get(ufn);
                throw new ClientException(19, msg);
            }
            catch (OperationRejectedException e) {
                if (!app.isInteractive()) throw new ClientException(19, e.getMessageObject(), e);
                app.println();
                ArgumentExceptionFactory.displayOperationRejectedException(app, e);
                app.println();
                if (!app.confirmAction(DSConfigMessages.INFO_DSCFG_PROMPT_EDIT_AGAIN.get(ufn), true)) return MenuResult.cancel();
                continue;
            }
            catch (CommunicationException e) {
                msg = DSConfigMessages.ERR_DSCFG_ERROR_MODIFY_CE.get(ufn, e.getMessage());
                throw new ClientException(80, msg);
            }
            break;
        }
        catch (ManagedObjectAlreadyExistsException e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * Unable to fully structure code
     */
    private static MenuResult<Void> checkReferences(ConsoleApplication app, ManagementContext context, ManagedObject<?> mo, SubCommandHandler handler) throws ClientException, CLIException {
        d = mo.getManagedObjectDefinition();
        ufn = d.getUserFriendlyName();
        try {
            for (PropertyDefinition<?> pd : d.getAllPropertyDefinitions()) {
                if (!(pd instanceof AggregationPropertyDefinition) || !(apd = (AggregationPropertyDefinition)AggregationPropertyDefinition.class.cast(pd)).getTargetNeedsEnablingCondition().evaluate(context, mo)) continue;
                for (String name : mo.getPropertyValues(apd)) {
                    path = apd.getChildPath(name);
                    rufn = path.getManagedObjectDefinition().getUserFriendlyName();
                    try {
                        ref = context.getManagedObject(path);
                    }
                    catch (DefinitionDecodingException e) {
                        msg = DSConfigMessages.ERR_DSCFG_ERROR_GET_CHILD_DDE.get(rufn, rufn, rufn);
                        throw new ClientException(80, msg);
                    }
                    catch (ManagedObjectDecodingException e) {
                        msg = DSConfigMessages.ERR_DSCFG_ERROR_GET_CHILD_MODE.get(rufn);
                        throw new ClientException(80, msg, e);
                    }
                    catch (ManagedObjectNotFoundException e) {
                        msg = DSConfigMessages.ERR_DSCFG_ERROR_GET_CHILD_MONFE.get(rufn);
                        throw new ClientException(32, msg);
                    }
                    condition = apd.getTargetIsEnabledCondition();
                    while (!condition.evaluate(context, ref)) {
                        isBadReference = true;
                        if (condition instanceof ContainsCondition) {
                            cvc = (ContainsCondition)condition;
                            app.println();
                            if (app.confirmAction(DSConfigMessages.INFO_EDITOR_PROMPT_ENABLED_REFERENCED_COMPONENT.get(rufn, name, ufn), true)) {
                                cvc.setPropertyValue(ref);
                                try {
                                    ref.commit();
                                    if (app instanceof DSConfig && app.isInteractive()) {
                                        dsConfig = (DSConfig)app;
                                        subCommandName = "set-" + path.getRelationDefinition().getName() + "-prop";
                                        builder = dsConfig.getCommandBuilder(subCommandName);
                                        if (path.getRelationDefinition() instanceof InstantiableRelationDefinition) {
                                            argName = CLIProfile.getInstance().getNamingArgument((InstantiableRelationDefinition)path.getRelationDefinition());
                                            try {
                                                arg = new StringArgument(argName, null, argName, false, true, ToolMessages.INFO_NAME_PLACEHOLDER.get(), DSConfigMessages.INFO_DSCFG_DESCRIPTION_NAME.get(d.getUserFriendlyName()));
                                                arg.addValue(name);
                                                builder.addArgument(arg);
                                            }
                                            catch (Throwable t) {
                                                throw new RuntimeException("Unexpected error: " + t, t);
                                            }
                                        }
                                        try {
                                            arg = new StringArgument("set", SetPropSubCommandHandler.OPTION_DSCFG_SHORT_SET, "set", false, true, true, ToolMessages.INFO_VALUE_SET_PLACEHOLDER.get(), null, null, DSConfigMessages.INFO_DSCFG_DESCRIPTION_PROP_VAL.get());
                                            arg.addValue(cvc.getPropertyDefinition().getName() + ':' + cvc.getValue());
                                            builder.addArgument(arg);
                                        }
                                        catch (Throwable t) {
                                            throw new RuntimeException("Unexpected error: " + t, t);
                                        }
                                        dsConfig.printCommandBuilder(builder);
                                    }
                                    isBadReference = false;
                                }
                                catch (MissingMandatoryPropertiesException e) {
                                    app.println();
                                    ArgumentExceptionFactory.displayMissingMandatoryPropertyException(app, e);
                                    app.println();
                                    if (!app.confirmAction(DSConfigMessages.INFO_DSCFG_PROMPT_EDIT.get(rufn), true)) ** GOTO lbl89
                                    result = SetPropSubCommandHandler.modifyManagedObject(app, context, ref, handler);
                                    if (result.isQuit()) {
                                        return result;
                                    }
                                    if (!result.isSuccess()) ** GOTO lbl89
                                    isBadReference = false;
                                }
                                catch (ConcurrentModificationException e) {
                                    msg = DSConfigMessages.ERR_DSCFG_ERROR_MODIFY_CME.get(ufn);
                                    throw new ClientException(19, msg);
                                }
                                catch (OperationRejectedException e) {
                                    app.println();
                                    ArgumentExceptionFactory.displayOperationRejectedException(app, e);
                                    app.println();
                                    if (!app.confirmAction(DSConfigMessages.INFO_DSCFG_PROMPT_EDIT.get(rufn), true)) ** GOTO lbl89
                                    result = SetPropSubCommandHandler.modifyManagedObject(app, context, ref, handler);
                                    if (result.isQuit()) {
                                        return result;
                                    }
                                    if (!result.isSuccess()) ** GOTO lbl89
                                    isBadReference = false;
                                }
                                catch (ManagedObjectAlreadyExistsException e) {
                                    throw new IllegalStateException(e);
                                }
                            }
                        } else {
                            app.println();
                            if (app.confirmAction(DSConfigMessages.INFO_DSCFG_PROMPT_EDIT_TO_ENABLE.get(rufn, name, ufn), true)) {
                                result = SetPropSubCommandHandler.modifyManagedObject(app, context, ref, handler);
                                if (result.isQuit()) {
                                    return result;
                                }
                                if (result.isSuccess()) {
                                    isBadReference = false;
                                }
                            }
                        }
lbl89:
                        // 13 sources

                        if (!isBadReference) continue;
                        app.println();
                        app.println(DSConfigMessages.ERR_SET_REFERENCED_COMPONENT_DISABLED.get(ufn, rufn));
                        app.println();
                        if (app.confirmAction(DSConfigMessages.INFO_DSCFG_PROMPT_EDIT_AGAIN.get(ufn), true)) {
                            return MenuResult.again();
                        }
                        return MenuResult.cancel();
                    }
                }
            }
        }
        catch (AuthorizationException e) {
            msg = DSConfigMessages.ERR_DSCFG_ERROR_MODIFY_AUTHZ.get(ufn);
            throw new ClientException(50, msg);
        }
        catch (CommunicationException e) {
            msg = DSConfigMessages.ERR_DSCFG_ERROR_MODIFY_CE.get(ufn, e.getMessage());
            throw new ClientException(80, msg);
        }
        return MenuResult.success();
    }

    private SetPropSubCommandHandler(SubCommandArgumentParser parser, ManagedObjectPath<?, ?> path, RelationDefinition<?, ?> r) throws ArgumentException {
        this.path = path;
        String name = "set-" + r.getName() + "-prop";
        Message description = DSConfigMessages.INFO_DSCFG_DESCRIPTION_SUBCMD_SETPROP.get(r.getChildDefinition().getUserFriendlyName());
        this.subCommand = new SubCommand(parser, name, false, 0, 0, null, description);
        this.namingArgs = this.createNamingArgs(this.subCommand, path, false);
        this.propertySetArgument = new StringArgument(OPTION_DSCFG_LONG_SET, OPTION_DSCFG_SHORT_SET, OPTION_DSCFG_LONG_SET, false, true, true, ToolMessages.INFO_VALUE_SET_PLACEHOLDER.get(), null, null, DSConfigMessages.INFO_DSCFG_DESCRIPTION_PROP_VAL.get());
        this.subCommand.addArgument(this.propertySetArgument);
        this.propertyResetArgument = new StringArgument(OPTION_DSCFG_LONG_RESET, OPTION_DSCFG_SHORT_RESET, OPTION_DSCFG_LONG_RESET, false, true, true, ToolMessages.INFO_PROPERTY_PLACEHOLDER.get(), null, null, DSConfigMessages.INFO_DSCFG_DESCRIPTION_RESET_PROP.get());
        this.subCommand.addArgument(this.propertyResetArgument);
        this.propertyAddArgument = new StringArgument(OPTION_DSCFG_LONG_ADD, OPTION_DSCFG_SHORT_ADD, OPTION_DSCFG_LONG_ADD, false, true, true, ToolMessages.INFO_VALUE_SET_PLACEHOLDER.get(), null, null, DSConfigMessages.INFO_DSCFG_DESCRIPTION_ADD_PROP_VAL.get());
        this.subCommand.addArgument(this.propertyAddArgument);
        this.propertyRemoveArgument = new StringArgument(OPTION_DSCFG_LONG_REMOVE, OPTION_DSCFG_SHORT_REMOVE, OPTION_DSCFG_LONG_REMOVE, false, true, true, ToolMessages.INFO_VALUE_SET_PLACEHOLDER.get(), null, null, DSConfigMessages.INFO_DSCFG_DESCRIPTION_REMOVE_PROP_VAL.get());
        this.subCommand.addArgument(this.propertyRemoveArgument);
        this.addTags(path.getManagedObjectDefinition().getAllTags());
    }

    public RelationDefinition<?, ?> getRelationDefinition() {
        return this.path.getRelationDefinition();
    }

    @Override
    public SubCommand getSubCommand() {
        return this.subCommand;
    }

    @Override
    public MenuResult<Integer> run(ConsoleApplication app, ManagementContextFactory factory) throws ArgumentException, ClientException, CLIException {
        PropertyDefinition<?> pd;
        String value;
        String propertyName;
        MenuResult<ManagedObject<?>> result;
        List<String> names = this.getNamingArgValues(app, this.namingArgs);
        this.getCommandBuilder().clearArguments();
        this.setCommandBuilderUseful(false);
        this.updateCommandBuilderWithSubCommand();
        Message ufn = this.path.getRelationDefinition().getUserFriendlyName();
        ManagementContext context = factory.getManagementContext(app);
        try {
            result = this.getManagedObject(app, context, this.path, names);
        }
        catch (AuthorizationException e) {
            Message msg = DSConfigMessages.ERR_DSCFG_ERROR_MODIFY_AUTHZ.get(ufn);
            throw new ClientException(50, msg);
        }
        catch (DefinitionDecodingException e) {
            Message msg = DSConfigMessages.ERR_DSCFG_ERROR_GET_CHILD_DDE.get(ufn, ufn, ufn);
            throw new ClientException(80, msg);
        }
        catch (ManagedObjectDecodingException e) {
            Message msg = DSConfigMessages.ERR_DSCFG_ERROR_GET_CHILD_MODE.get(ufn);
            throw new ClientException(80, msg, e);
        }
        catch (CommunicationException e) {
            Message msg = DSConfigMessages.ERR_DSCFG_ERROR_MODIFY_CE.get(ufn, e.getMessage());
            throw new ClientException(80, msg);
        }
        catch (ConcurrentModificationException e) {
            Message msg = DSConfigMessages.ERR_DSCFG_ERROR_MODIFY_CME.get(ufn);
            throw new ClientException(19, msg);
        }
        catch (ManagedObjectNotFoundException e) {
            Message msg = DSConfigMessages.ERR_DSCFG_ERROR_GET_CHILD_MONFE.get(ufn);
            throw new ClientException(32, msg);
        }
        if (result.isQuit()) {
            if (!app.isMenuDrivenMode()) {
                Message msg = DSConfigMessages.INFO_DSCFG_CONFIRM_MODIFY_FAIL.get(ufn);
                app.printVerboseMessage(msg);
            }
            return MenuResult.quit();
        }
        if (result.isCancel()) {
            return MenuResult.cancel();
        }
        ManagedObject<?> child = result.getValue();
        ManagedObjectDefinition<?, Configuration> d = child.getManagedObjectDefinition();
        HashMap<String, ModificationType> lastModTypes = new HashMap<String, ModificationType>();
        HashMap<PropertyDefinition, Set> changes = new HashMap<PropertyDefinition, Set>();
        for (String m : this.propertyResetArgument.getValues()) {
            PropertyDefinition<?> pd2;
            try {
                pd2 = d.getPropertyDefinition(m);
            }
            catch (IllegalArgumentException e) {
                throw ArgumentExceptionFactory.unknownProperty(d, m);
            }
            if (pd2.hasOption(PropertyOption.MANDATORY) && pd2.getDefaultBehaviorProvider() instanceof UndefinedDefaultBehaviorProvider) {
                throw ArgumentExceptionFactory.unableToResetMandatoryProperty(d, m, OPTION_DSCFG_LONG_SET);
            }
            lastModTypes.put(m, ModificationType.SET);
            this.modifyPropertyValues(child, pd2, changes, ModificationType.SET, null);
        }
        for (String m : this.propertySetArgument.getValues()) {
            int sep = m.indexOf(58);
            if (sep < 0) {
                throw ArgumentExceptionFactory.missingSeparatorInPropertyArgument(m);
            }
            if (sep == 0) {
                throw ArgumentExceptionFactory.missingNameInPropertyArgument(m);
            }
            propertyName = m.substring(0, sep);
            value = m.substring(sep + 1, m.length());
            if (value.length() == 0) {
                throw ArgumentExceptionFactory.missingValueInPropertyArgument(m);
            }
            try {
                pd = d.getPropertyDefinition(propertyName);
            }
            catch (IllegalArgumentException e) {
                throw ArgumentExceptionFactory.unknownProperty(d, propertyName);
            }
            if (lastModTypes.containsKey(propertyName)) {
                this.modifyPropertyValues(child, pd, changes, ModificationType.ADD, value);
                continue;
            }
            lastModTypes.put(propertyName, ModificationType.SET);
            this.modifyPropertyValues(child, pd, changes, ModificationType.SET, value);
        }
        for (String m : this.propertyRemoveArgument.getValues()) {
            int sep = m.indexOf(58);
            if (sep < 0) {
                throw ArgumentExceptionFactory.missingSeparatorInPropertyArgument(m);
            }
            if (sep == 0) {
                throw ArgumentExceptionFactory.missingNameInPropertyArgument(m);
            }
            propertyName = m.substring(0, sep);
            value = m.substring(sep + 1, m.length());
            if (value.length() == 0) {
                throw ArgumentExceptionFactory.missingValueInPropertyArgument(m);
            }
            try {
                pd = d.getPropertyDefinition(propertyName);
            }
            catch (IllegalArgumentException e) {
                throw ArgumentExceptionFactory.unknownProperty(d, propertyName);
            }
            if (lastModTypes.containsKey(propertyName)) {
                if (lastModTypes.get(propertyName) != ModificationType.SET) continue;
                throw ArgumentExceptionFactory.incompatiblePropertyModification(m);
            }
            lastModTypes.put(propertyName, ModificationType.REMOVE);
            this.modifyPropertyValues(child, pd, changes, ModificationType.REMOVE, value);
        }
        for (String m : this.propertyAddArgument.getValues()) {
            int sep = m.indexOf(58);
            if (sep < 0) {
                throw ArgumentExceptionFactory.missingSeparatorInPropertyArgument(m);
            }
            if (sep == 0) {
                throw ArgumentExceptionFactory.missingNameInPropertyArgument(m);
            }
            propertyName = m.substring(0, sep);
            value = m.substring(sep + 1, m.length());
            if (value.length() == 0) {
                throw ArgumentExceptionFactory.missingValueInPropertyArgument(m);
            }
            try {
                pd = d.getPropertyDefinition(propertyName);
            }
            catch (IllegalArgumentException e) {
                throw ArgumentExceptionFactory.unknownProperty(d, propertyName);
            }
            if (lastModTypes.containsKey(propertyName)) {
                if (lastModTypes.get(propertyName) != ModificationType.SET) continue;
                throw ArgumentExceptionFactory.incompatiblePropertyModification(m);
            }
            lastModTypes.put(propertyName, ModificationType.ADD);
            this.modifyPropertyValues(child, pd, changes, ModificationType.ADD, value);
        }
        for (PropertyDefinition pd3 : changes.keySet()) {
            try {
                child.setPropertyValues(pd3, (Collection)changes.get(pd3));
            }
            catch (PropertyException e) {
                throw ArgumentExceptionFactory.adaptPropertyException(e, d);
            }
            this.setCommandBuilderUseful(true);
        }
        MenuResult<Void> result2 = SetPropSubCommandHandler.modifyManagedObject(app, context, child, this);
        if (result2.isCancel()) {
            return MenuResult.cancel();
        }
        if (result2.isQuit()) {
            return MenuResult.quit();
        }
        if (this.propertyResetArgument.hasValue()) {
            this.getCommandBuilder().addArgument(this.propertyResetArgument);
        }
        if (this.propertySetArgument.hasValue()) {
            this.getCommandBuilder().addArgument(this.propertySetArgument);
        }
        if (this.propertyAddArgument.hasValue()) {
            this.getCommandBuilder().addArgument(this.propertyAddArgument);
        }
        if (this.propertyRemoveArgument.hasValue()) {
            this.getCommandBuilder().addArgument(this.propertyRemoveArgument);
        }
        return MenuResult.success(0);
    }

    private <T> void modifyPropertyValues(ManagedObject<?> mo, PropertyDefinition<T> pd, Map<PropertyDefinition, Set> changes, ModificationType modType, String s) throws ArgumentException {
        SortedSet<T> values = changes.get(pd);
        if (values == null) {
            values = mo.getPropertyValues(pd);
        }
        if (s == null || s.length() == 0) {
            values.clear();
        } else {
            T value;
            try {
                value = pd.decodeValue(s);
            }
            catch (IllegalPropertyValueStringException e) {
                throw ArgumentExceptionFactory.adaptPropertyException(e, mo.getManagedObjectDefinition());
            }
            switch (modType) {
                case ADD: {
                    values.add(value);
                    break;
                }
                case REMOVE: {
                    values.remove(value);
                    break;
                }
                case SET: {
                    values = new TreeSet<T>(pd);
                    values.add(value);
                }
            }
        }
        changes.put(pd, values);
    }

    private static Argument createArgument(PropertyEditorModification mod) throws ArgumentException {
        StringArgument arg;
        String propName = mod.getPropertyDefinition().getName();
        switch (mod.getType()) {
            case RESET: {
                arg = new StringArgument(OPTION_DSCFG_LONG_RESET, OPTION_DSCFG_SHORT_RESET, OPTION_DSCFG_LONG_RESET, false, true, true, ToolMessages.INFO_PROPERTY_PLACEHOLDER.get(), null, null, DSConfigMessages.INFO_DSCFG_DESCRIPTION_RESET_PROP.get());
                arg.addValue(propName);
                break;
            }
            case REMOVE: {
                arg = new StringArgument(OPTION_DSCFG_LONG_REMOVE, OPTION_DSCFG_SHORT_REMOVE, OPTION_DSCFG_LONG_REMOVE, false, true, true, ToolMessages.INFO_VALUE_SET_PLACEHOLDER.get(), null, null, DSConfigMessages.INFO_DSCFG_DESCRIPTION_REMOVE_PROP_VAL.get());
                for (Object value : mod.getModificationValues()) {
                    arg.addValue(propName + ':' + value);
                }
                break;
            }
            case ADD: {
                arg = new StringArgument(OPTION_DSCFG_LONG_ADD, OPTION_DSCFG_SHORT_ADD, OPTION_DSCFG_LONG_ADD, false, true, true, ToolMessages.INFO_VALUE_SET_PLACEHOLDER.get(), null, null, DSConfigMessages.INFO_DSCFG_DESCRIPTION_ADD_PROP_VAL.get());
                for (Object value : mod.getModificationValues()) {
                    arg.addValue(propName + ':' + value);
                }
                break;
            }
            case SET: {
                arg = new StringArgument(OPTION_DSCFG_LONG_SET, OPTION_DSCFG_SHORT_SET, OPTION_DSCFG_LONG_SET, false, true, true, ToolMessages.INFO_VALUE_SET_PLACEHOLDER.get(), null, null, DSConfigMessages.INFO_DSCFG_DESCRIPTION_PROP_VAL.get());
                for (Object value : mod.getModificationValues()) {
                    arg.addValue(propName + ':' + value);
                }
                break;
            }
            default: {
                throw new IllegalStateException("Unknown modification type: " + (Object)((Object)mod.getType()));
            }
        }
        return arg;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ModificationType {
        ADD,
        REMOVE,
        SET;

    }
}

