/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools.makeldif;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.StringTokenizer;
import org.opends.messages.Message;
import org.opends.messages.ToolMessages;
import org.opends.server.core.DirectoryServer;
import org.opends.server.tools.makeldif.AttributeValueTag;
import org.opends.server.tools.makeldif.Branch;
import org.opends.server.tools.makeldif.DNTag;
import org.opends.server.tools.makeldif.EntryWriter;
import org.opends.server.tools.makeldif.FileTag;
import org.opends.server.tools.makeldif.FirstNameTag;
import org.opends.server.tools.makeldif.GUIDTag;
import org.opends.server.tools.makeldif.IfAbsentTag;
import org.opends.server.tools.makeldif.IfPresentTag;
import org.opends.server.tools.makeldif.LastNameTag;
import org.opends.server.tools.makeldif.ListTag;
import org.opends.server.tools.makeldif.MakeLDIFException;
import org.opends.server.tools.makeldif.ParentDNTag;
import org.opends.server.tools.makeldif.PresenceTag;
import org.opends.server.tools.makeldif.RDNTag;
import org.opends.server.tools.makeldif.RandomTag;
import org.opends.server.tools.makeldif.SequentialTag;
import org.opends.server.tools.makeldif.StaticTextTag;
import org.opends.server.tools.makeldif.Tag;
import org.opends.server.tools.makeldif.TagResult;
import org.opends.server.tools.makeldif.Template;
import org.opends.server.tools.makeldif.TemplateLine;
import org.opends.server.tools.makeldif.UnderscoreDNTag;
import org.opends.server.tools.makeldif.UnderscoreParentDNTag;
import org.opends.server.types.AttributeType;
import org.opends.server.types.DN;
import org.opends.server.types.InitializationException;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateFile {
    public static final String FIRST_NAME_FILE = "first.names";
    public static final String LAST_NAME_FILE = "last.names";
    private HashMap<String, String[]> fileLines;
    private int firstNameIndex;
    private int lastNameIndex;
    private int nameLoopCounter;
    private int nameUniquenessCounter;
    private LinkedHashMap<DN, Branch> branches;
    private LinkedHashMap<String, String> constants;
    private LinkedHashMap<String, Tag> registeredTags;
    private LinkedHashMap<String, Template> templates;
    private Random random;
    private String firstName;
    private String lastName;
    private String resourcePath;
    private String templatePath;
    private String[] firstNames;
    private String[] lastNames;

    public TemplateFile(String resourcePath) {
        this(resourcePath, new Random());
    }

    public TemplateFile(String resourcePath, Random random) {
        this.resourcePath = resourcePath;
        this.random = random;
        this.fileLines = new HashMap();
        this.branches = new LinkedHashMap();
        this.constants = new LinkedHashMap();
        this.registeredTags = new LinkedHashMap();
        this.templates = new LinkedHashMap();
        this.templatePath = null;
        this.firstNames = new String[0];
        this.lastNames = new String[0];
        this.firstName = null;
        this.lastName = null;
        this.firstNameIndex = 0;
        this.lastNameIndex = 0;
        this.nameLoopCounter = 0;
        this.nameUniquenessCounter = 1;
        this.registerDefaultTags();
        try {
            this.readNameFiles();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            this.firstNames = new String[]{"John"};
            this.lastNames = new String[]{"Doe"};
        }
    }

    public Map<String, Tag> getTags() {
        return this.registeredTags;
    }

    public Tag getTag(String lowerName) {
        return this.registeredTags.get(lowerName);
    }

    public void registerTag(String tagClass) throws MakeLDIFException {
        Tag t;
        Class<?> c;
        try {
            c = Class.forName(tagClass);
        }
        catch (Exception e) {
            Message message = ToolMessages.ERR_MAKELDIF_CANNOT_LOAD_TAG_CLASS.get(tagClass);
            throw new MakeLDIFException(message, (Throwable)e);
        }
        try {
            t = (Tag)c.newInstance();
        }
        catch (Exception e) {
            Message message = ToolMessages.ERR_MAKELDIF_CANNOT_INSTANTIATE_TAG.get(tagClass);
            throw new MakeLDIFException(message, (Throwable)e);
        }
        String lowerName = StaticUtils.toLowerCase(t.getName());
        if (this.registeredTags.containsKey(lowerName)) {
            Message message = ToolMessages.ERR_MAKELDIF_CONFLICTING_TAG_NAME.get(tagClass, t.getName());
            throw new MakeLDIFException(message);
        }
        this.registeredTags.put(lowerName, t);
    }

    private void registerDefaultTags() {
        Class[] defaultTagClasses;
        for (Class c : defaultTagClasses = new Class[]{AttributeValueTag.class, DNTag.class, FileTag.class, FirstNameTag.class, GUIDTag.class, IfAbsentTag.class, IfPresentTag.class, LastNameTag.class, ListTag.class, ParentDNTag.class, PresenceTag.class, RandomTag.class, RDNTag.class, SequentialTag.class, StaticTextTag.class, UnderscoreDNTag.class, UnderscoreParentDNTag.class}) {
            try {
                Tag t = (Tag)c.newInstance();
                this.registeredTags.put(StaticUtils.toLowerCase(t.getName()), t);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public Map<String, String> getConstants() {
        return this.constants;
    }

    public String getConstant(String lowerName) {
        return this.constants.get(lowerName);
    }

    public void registerConstant(String name, String value) {
        this.constants.put(StaticUtils.toLowerCase(name), value);
    }

    public Map<DN, Branch> getBranches() {
        return this.branches;
    }

    public Branch getBranch(DN branchDN) {
        return this.branches.get(branchDN);
    }

    public void registerBranch(Branch branch) {
        this.branches.put(branch.getBranchDN(), branch);
    }

    public Map<String, Template> getTemplates() {
        return this.templates;
    }

    public Template getTemplate(String lowerName) {
        return this.templates.get(lowerName);
    }

    public void registerTemplate(Template template) {
        this.templates.put(StaticUtils.toLowerCase(template.getName()), template);
    }

    public Random getRandom() {
        return this.random;
    }

    private void readNameFiles() throws IOException {
        String line;
        File f = this.getFile(FIRST_NAME_FILE);
        ArrayList<String> nameList = new ArrayList<String>();
        BufferedReader reader = new BufferedReader(new FileReader(f));
        while ((line = reader.readLine()) != null) {
            nameList.add(line);
        }
        reader.close();
        this.firstNames = new String[nameList.size()];
        nameList.toArray(this.firstNames);
        f = this.getFile(LAST_NAME_FILE);
        nameList = new ArrayList();
        reader = new BufferedReader(new FileReader(f));
        while ((line = reader.readLine()) != null) {
            nameList.add(line);
        }
        reader.close();
        this.lastNames = new String[nameList.size()];
        nameList.toArray(this.lastNames);
    }

    public void nextFirstAndLastNames() {
        this.firstName = this.firstNames[this.firstNameIndex++];
        this.lastName = this.lastNames[this.lastNameIndex++];
        if (this.nameUniquenessCounter > 1) {
            this.lastName = this.lastName + this.nameUniquenessCounter;
        }
        if (this.firstNameIndex >= this.firstNames.length) {
            this.firstNameIndex = 0;
            if (this.firstNames.length > this.lastNames.length) {
                this.lastNameIndex = ++this.nameLoopCounter;
                if (this.lastNameIndex >= this.lastNames.length) {
                    this.lastNameIndex = 0;
                    ++this.nameUniquenessCounter;
                }
            }
        }
        if (this.lastNameIndex >= this.lastNames.length) {
            this.lastNameIndex = 0;
            if (this.lastNames.length > this.firstNames.length) {
                this.firstNameIndex = ++this.nameLoopCounter;
                if (this.firstNameIndex >= this.firstNames.length) {
                    this.firstNameIndex = 0;
                    ++this.nameUniquenessCounter;
                }
            }
        }
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void parse(String filename, List<Message> warnings) throws IOException, InitializationException, MakeLDIFException {
        String line;
        ArrayList<String> fileLines = new ArrayList<String>();
        this.templatePath = null;
        File f = this.getFile(filename);
        if (f == null || !f.exists()) {
            Message message = ToolMessages.ERR_MAKELDIF_COULD_NOT_FIND_TEMPLATE_FILE.get(filename);
            throw new IOException(message.toString());
        }
        this.templatePath = f.getParentFile().getAbsolutePath();
        BufferedReader reader = new BufferedReader(new FileReader(f));
        while ((line = reader.readLine()) != null) {
            fileLines.add(line);
        }
        reader.close();
        String[] lines = new String[fileLines.size()];
        fileLines.toArray(lines);
        this.parse(lines, warnings);
    }

    public void parse(InputStream inputStream, List<Message> warnings) throws IOException, InitializationException, MakeLDIFException {
        String line;
        ArrayList<String> fileLines = new ArrayList<String>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        while ((line = reader.readLine()) != null) {
            fileLines.add(line);
        }
        reader.close();
        String[] lines = new String[fileLines.size()];
        fileLines.toArray(lines);
        this.parse(lines, warnings);
    }

    public void parse(String[] lines, List<Message> warnings) throws InitializationException, MakeLDIFException {
        LinkedHashMap<String, Tag> templateFileIncludeTags = new LinkedHashMap<String, Tag>();
        LinkedHashMap<String, String> templateFileConstants = new LinkedHashMap<String, String>();
        LinkedHashMap<DN, Branch> templateFileBranches = new LinkedHashMap<DN, Branch>();
        LinkedHashMap<String, Template> templateFileTemplates = new LinkedHashMap<String, Template>();
        for (int lineNumber = 0; lineNumber < lines.length; ++lineNumber) {
            Message message;
            Message message2;
            String constantValue;
            String constantName;
            StringBuilder lineBuffer;
            ArrayList<String> lineList;
            int startLineNumber;
            Message message3;
            Message message4;
            String line = lines[lineNumber];
            int closePos = line.lastIndexOf(93);
            if (closePos > 0) {
                StringBuilder lineBuffer2 = new StringBuilder(line);
                int openPos = line.lastIndexOf(91, closePos);
                if (openPos >= 0) {
                    String constantName2 = StaticUtils.toLowerCase(line.substring(openPos + 1, closePos));
                    String constantValue2 = (String)templateFileConstants.get(constantName2);
                    if (constantValue2 == null) {
                        message4 = ToolMessages.WARN_MAKELDIF_WARNING_UNDEFINED_CONSTANT.get(constantName2, lineNumber);
                        warnings.add(message4);
                    } else {
                        lineBuffer2.replace(openPos, closePos + 1, constantValue2);
                    }
                }
                line = lineBuffer2.toString();
            }
            String lowerLine = StaticUtils.toLowerCase(line);
            if (line.length() == 0 || line.startsWith("#")) continue;
            if (lowerLine.startsWith("include ")) {
                Tag tag;
                Class<?> tagClass;
                String className = line.substring(8).trim();
                try {
                    tagClass = Class.forName(className);
                }
                catch (Exception e) {
                    message4 = ToolMessages.ERR_MAKELDIF_CANNOT_LOAD_TAG_CLASS.get(className);
                    throw new MakeLDIFException(message4, (Throwable)e);
                }
                try {
                    tag = (Tag)tagClass.newInstance();
                }
                catch (Exception e) {
                    message3 = ToolMessages.ERR_MAKELDIF_CANNOT_INSTANTIATE_TAG.get(className);
                    throw new MakeLDIFException(message3, (Throwable)e);
                }
                String lowerName = StaticUtils.toLowerCase(tag.getName());
                if (this.registeredTags.containsKey(lowerName) || templateFileIncludeTags.containsKey(lowerName)) {
                    message3 = ToolMessages.ERR_MAKELDIF_CONFLICTING_TAG_NAME.get(className, tag.getName());
                    throw new MakeLDIFException(message3);
                }
                templateFileIncludeTags.put(lowerName, tag);
                continue;
            }
            if (lowerLine.startsWith("define ")) {
                int equalPos = line.indexOf(61, 7);
                if (equalPos < 0) {
                    Message message5 = ToolMessages.ERR_MAKELDIF_DEFINE_MISSING_EQUALS.get(lineNumber);
                    throw new MakeLDIFException(message5);
                }
                String name = line.substring(7, equalPos).trim();
                if (name.length() == 0) {
                    Message message6 = ToolMessages.ERR_MAKELDIF_DEFINE_NAME_EMPTY.get(lineNumber);
                    throw new MakeLDIFException(message6);
                }
                String lowerName = StaticUtils.toLowerCase(name);
                if (templateFileConstants.containsKey(lowerName)) {
                    message4 = ToolMessages.ERR_MAKELDIF_CONFLICTING_CONSTANT_NAME.get(name, lineNumber);
                    throw new MakeLDIFException(message4);
                }
                String value = line.substring(equalPos + 1);
                if (value.length() == 0) {
                    message3 = ToolMessages.ERR_MAKELDIF_WARNING_DEFINE_VALUE_EMPTY.get(name, lineNumber);
                    warnings.add(message3);
                }
                templateFileConstants.put(lowerName, value);
                continue;
            }
            if (lowerLine.startsWith("branch: ")) {
                startLineNumber = lineNumber;
                lineList = new ArrayList<String>();
                lineList.add(line);
                while (++lineNumber < lines.length && (line = lines[lineNumber]).length() != 0) {
                    closePos = line.lastIndexOf(93);
                    if (closePos > 0) {
                        lineBuffer = new StringBuilder(line);
                        int openPos = line.lastIndexOf(91, closePos);
                        if (openPos >= 0) {
                            constantName = StaticUtils.toLowerCase(line.substring(openPos + 1, closePos));
                            constantValue = templateFileConstants.get(constantName);
                            if (constantValue == null) {
                                message2 = ToolMessages.WARN_MAKELDIF_WARNING_UNDEFINED_CONSTANT.get(constantName, lineNumber);
                                warnings.add(message2);
                            } else {
                                lineBuffer.replace(openPos, closePos + 1, constantValue);
                            }
                        }
                        line = lineBuffer.toString();
                    }
                    lineList.add(line);
                }
                String[] branchLines = new String[lineList.size()];
                lineList.toArray(branchLines);
                Branch b = this.parseBranchDefinition(branchLines, lineNumber, templateFileIncludeTags, templateFileConstants, warnings);
                DN branchDN = b.getBranchDN();
                if (templateFileBranches.containsKey(branchDN)) {
                    message = ToolMessages.ERR_MAKELDIF_CONFLICTING_BRANCH_DN.get(String.valueOf(branchDN), startLineNumber);
                    throw new MakeLDIFException(message);
                }
                templateFileBranches.put(branchDN, b);
                continue;
            }
            if (lowerLine.startsWith("template: ")) {
                startLineNumber = lineNumber;
                lineList = new ArrayList();
                lineList.add(line);
                while (++lineNumber < lines.length && (line = lines[lineNumber]).length() != 0) {
                    closePos = line.lastIndexOf(93);
                    if (closePos > 0) {
                        lineBuffer = new StringBuilder(line);
                        int openPos = line.lastIndexOf(91, closePos);
                        if (openPos >= 0) {
                            constantName = StaticUtils.toLowerCase(line.substring(openPos + 1, closePos));
                            constantValue = templateFileConstants.get(constantName);
                            if (constantValue == null) {
                                message2 = ToolMessages.WARN_MAKELDIF_WARNING_UNDEFINED_CONSTANT.get(constantName, lineNumber);
                                warnings.add(message2);
                            } else {
                                lineBuffer.replace(openPos, closePos + 1, constantValue);
                            }
                        }
                        line = lineBuffer.toString();
                    }
                    lineList.add(line);
                }
                String[] templateLines = new String[lineList.size()];
                lineList.toArray(templateLines);
                Template t = this.parseTemplateDefinition(templateLines, startLineNumber, templateFileIncludeTags, templateFileConstants, templateFileTemplates, warnings);
                String lowerName = StaticUtils.toLowerCase(t.getName());
                if (templateFileTemplates.containsKey(lowerName)) {
                    message = ToolMessages.ERR_MAKELDIF_CONFLICTING_TEMPLATE_NAME.get(String.valueOf(t.getName()), startLineNumber);
                    throw new MakeLDIFException(message);
                }
                templateFileTemplates.put(lowerName, t);
                continue;
            }
            Message message7 = ToolMessages.ERR_MAKELDIF_UNEXPECTED_TEMPLATE_FILE_LINE.get(line, lineNumber);
            throw new MakeLDIFException(message7);
        }
        for (Branch b : templateFileBranches.values()) {
            b.completeBranchInitialization(templateFileTemplates);
        }
        for (Template t : templateFileTemplates.values()) {
            t.completeTemplateInitialization(templateFileTemplates);
        }
        this.registeredTags.putAll(templateFileIncludeTags);
        this.constants.putAll(templateFileConstants);
        this.branches.putAll(templateFileBranches);
        this.templates.putAll(templateFileTemplates);
    }

    private Branch parseBranchDefinition(String[] branchLines, int startLineNumber, LinkedHashMap<String, Tag> tags, LinkedHashMap<String, String> constants, List<Message> warnings) throws InitializationException, MakeLDIFException {
        DN branchDN;
        String dnString = branchLines[0].substring(8).trim();
        try {
            branchDN = DN.decode(dnString);
        }
        catch (Exception e) {
            Message message = ToolMessages.ERR_MAKELDIF_CANNOT_DECODE_BRANCH_DN.get(dnString, startLineNumber);
            throw new MakeLDIFException(message);
        }
        Branch branch = new Branch(this, branchDN);
        for (int i = 1; i < branchLines.length; ++i) {
            String line = branchLines[i];
            String lowerLine = StaticUtils.toLowerCase(line);
            int lineNumber = startLineNumber + i;
            if (lowerLine.startsWith("#")) continue;
            if (lowerLine.startsWith("subordinatetemplate: ")) {
                int colonPos = line.indexOf(58, 21);
                if (colonPos <= 21) {
                    Message message = ToolMessages.ERR_MAKELDIF_BRANCH_SUBORDINATE_TEMPLATE_NO_COLON.get(lineNumber, dnString);
                    throw new MakeLDIFException(message);
                }
                String templateName = line.substring(21, colonPos).trim();
                try {
                    Message message;
                    int numEntries = Integer.parseInt(line.substring(colonPos + 1).trim());
                    if (numEntries < 0) {
                        message = ToolMessages.ERR_MAKELDIF_BRANCH_SUBORDINATE_INVALID_NUM_ENTRIES.get(lineNumber, dnString, numEntries, templateName);
                        throw new MakeLDIFException(message);
                    }
                    if (numEntries == 0) {
                        message = ToolMessages.WARN_MAKELDIF_BRANCH_SUBORDINATE_ZERO_ENTRIES.get(lineNumber, dnString, templateName);
                        warnings.add(message);
                    }
                    branch.addSubordinateTemplate(templateName, numEntries);
                    continue;
                }
                catch (NumberFormatException nfe) {
                    Message message = ToolMessages.ERR_MAKELDIF_BRANCH_SUBORDINATE_CANT_PARSE_NUMENTRIES.get(templateName, lineNumber, dnString);
                    throw new MakeLDIFException(message);
                }
            }
            TemplateLine templateLine = this.parseTemplateLine(line, lowerLine, lineNumber, branch, null, tags, warnings);
            branch.addExtraLine(templateLine);
        }
        return branch;
    }

    private Template parseTemplateDefinition(String[] templateLines, int startLineNumber, LinkedHashMap<String, Tag> tags, LinkedHashMap<String, String> constants, LinkedHashMap<String, Template> definedTemplates, List<Message> warnings) throws InitializationException, MakeLDIFException {
        TemplateLine[] parsedLines;
        int arrayLineNumber;
        String templateName = templateLines[0].substring(10).trim();
        Template parentTemplate = null;
        AttributeType[] rdnAttributes = null;
        ArrayList<String> subTemplateNames = new ArrayList<String>();
        ArrayList<Integer> entriesPerTemplate = new ArrayList<Integer>();
        for (arrayLineNumber = 1; arrayLineNumber < templateLines.length; ++arrayLineNumber) {
            Message message;
            int lineNumber = startLineNumber + arrayLineNumber;
            String line = templateLines[arrayLineNumber];
            String lowerLine = StaticUtils.toLowerCase(line);
            if (lowerLine.startsWith("#")) continue;
            if (lowerLine.startsWith("extends: ")) {
                String parentTemplateName = line.substring(9).trim();
                parentTemplate = definedTemplates.get(parentTemplateName.toLowerCase());
                if (parentTemplate != null) continue;
                message = ToolMessages.ERR_MAKELDIF_TEMPLATE_INVALID_PARENT_TEMPLATE.get(parentTemplateName, lineNumber, templateName);
                throw new MakeLDIFException(message);
            }
            if (lowerLine.startsWith("rdnattr: ")) {
                ArrayList<AttributeType> attrList = new ArrayList<AttributeType>();
                String rdnAttrNames = lowerLine.substring(9).trim();
                StringTokenizer tokenizer = new StringTokenizer(rdnAttrNames, "+");
                while (tokenizer.hasMoreTokens()) {
                    attrList.add(DirectoryServer.getAttributeType(tokenizer.nextToken(), true));
                }
                rdnAttributes = new AttributeType[attrList.size()];
                attrList.toArray(rdnAttributes);
                continue;
            }
            if (!lowerLine.startsWith("subordinatetemplate: ")) break;
            int colonPos = line.indexOf(58, 21);
            if (colonPos <= 21) {
                message = ToolMessages.ERR_MAKELDIF_TEMPLATE_SUBORDINATE_TEMPLATE_NO_COLON.get(lineNumber, templateName);
                throw new MakeLDIFException(message);
            }
            String subTemplateName = line.substring(21, colonPos).trim();
            try {
                Message message2;
                int numEntries = Integer.parseInt(line.substring(colonPos + 1).trim());
                if (numEntries < 0) {
                    message2 = ToolMessages.ERR_MAKELDIF_TEMPLATE_SUBORDINATE_INVALID_NUM_ENTRIES.get(lineNumber, templateName, numEntries, subTemplateName);
                    throw new MakeLDIFException(message2);
                }
                if (numEntries == 0) {
                    message2 = ToolMessages.WARN_MAKELDIF_TEMPLATE_SUBORDINATE_ZERO_ENTRIES.get(lineNumber, templateName, subTemplateName);
                    warnings.add(message2);
                }
                subTemplateNames.add(subTemplateName);
                entriesPerTemplate.add(numEntries);
                continue;
            }
            catch (NumberFormatException nfe) {
                Message message3 = ToolMessages.ERR_MAKELDIF_TEMPLATE_SUBORDINATE_CANT_PARSE_NUMENTRIES.get(subTemplateName, lineNumber, templateName);
                throw new MakeLDIFException(message3);
            }
        }
        String[] subordinateTemplateNames = new String[subTemplateNames.size()];
        subTemplateNames.toArray(subordinateTemplateNames);
        int[] numEntriesPerTemplate = new int[entriesPerTemplate.size()];
        for (int i = 0; i < numEntriesPerTemplate.length; ++i) {
            numEntriesPerTemplate[i] = (Integer)entriesPerTemplate.get(i);
        }
        if (parentTemplate == null) {
            parsedLines = new TemplateLine[]{};
        } else {
            TemplateLine[] parentLines = parentTemplate.getTemplateLines();
            parsedLines = new TemplateLine[parentLines.length];
            System.arraycopy(parentLines, 0, parsedLines, 0, parentLines.length);
        }
        Template template = new Template(this, templateName, rdnAttributes, subordinateTemplateNames, numEntriesPerTemplate, parsedLines);
        while (arrayLineNumber < templateLines.length) {
            String line = templateLines[arrayLineNumber];
            String lowerLine = StaticUtils.toLowerCase(line);
            int lineNumber = startLineNumber + arrayLineNumber;
            if (!lowerLine.startsWith("#")) {
                TemplateLine templateLine = this.parseTemplateLine(line, lowerLine, lineNumber, null, template, tags, warnings);
                template.addTemplateLine(templateLine);
            }
            ++arrayLineNumber;
        }
        return template;
    }

    private TemplateLine parseTemplateLine(String line, String lowerLine, int lineNumber, Branch branch, Template template, LinkedHashMap<String, Tag> tags, List<Message> warnings) throws InitializationException, MakeLDIFException {
        int pos;
        int colonPos = lowerLine.indexOf(58);
        if (colonPos < 0) {
            if (branch == null) {
                Message message = ToolMessages.ERR_MAKELDIF_NO_COLON_IN_TEMPLATE_LINE.get(lineNumber, template.getName());
                throw new MakeLDIFException(message);
            }
            Message message = ToolMessages.ERR_MAKELDIF_NO_COLON_IN_BRANCH_EXTRA_LINE.get(lineNumber, String.valueOf(branch.getBranchDN()));
            throw new MakeLDIFException(message);
        }
        if (colonPos == 0) {
            if (branch == null) {
                Message message = ToolMessages.ERR_MAKELDIF_NO_ATTR_IN_TEMPLATE_LINE.get(lineNumber, template.getName());
                throw new MakeLDIFException(message);
            }
            Message message = ToolMessages.ERR_MAKELDIF_NO_ATTR_IN_BRANCH_EXTRA_LINE.get(lineNumber, String.valueOf(branch.getBranchDN()));
            throw new MakeLDIFException(message);
        }
        AttributeType attributeType = DirectoryServer.getAttributeType(lowerLine.substring(0, colonPos), true);
        int length = line.length();
        for (pos = colonPos + 1; pos < length && lowerLine.charAt(pos) == ' '; ++pos) {
        }
        if (pos >= length) {
            Message message;
            if (branch == null) {
                message = ToolMessages.WARN_MAKELDIF_NO_VALUE_IN_TEMPLATE_LINE.get(lineNumber, template.getName());
                warnings.add(message);
            } else {
                message = ToolMessages.WARN_MAKELDIF_NO_VALUE_IN_BRANCH_EXTRA_LINE.get(lineNumber, String.valueOf(branch.getBranchDN()));
                warnings.add(message);
            }
        }
        boolean PARSING_STATIC_TEXT = false;
        boolean PARSING_REPLACEMENT_TAG = true;
        int PARSING_ATTRIBUTE_TAG = 2;
        int phase = 0;
        ArrayList<Tag> tagList = new ArrayList<Tag>();
        StringBuilder buffer = new StringBuilder();
        while (pos < length) {
            char c = line.charAt(pos);
            block0 : switch (phase) {
                case 0: {
                    Tag t;
                    switch (c) {
                        case '<': {
                            String[] args;
                            if (buffer.length() > 0) {
                                t = new StaticTextTag();
                                args = new String[]{buffer.toString()};
                                ((StaticTextTag)t).initializeForBranch(this, branch, args, lineNumber, warnings);
                                tagList.add(t);
                                buffer = new StringBuilder();
                            }
                            phase = 1;
                            break block0;
                        }
                        case '{': {
                            String[] args;
                            if (buffer.length() > 0) {
                                t = new StaticTextTag();
                                args = new String[]{buffer.toString()};
                                ((StaticTextTag)t).initializeForBranch(this, branch, args, lineNumber, warnings);
                                tagList.add(t);
                                buffer = new StringBuilder();
                            }
                            phase = 2;
                            break block0;
                        }
                    }
                    buffer.append(c);
                    break;
                }
                case 1: {
                    Tag t;
                    switch (c) {
                        case '>': {
                            t = this.parseReplacementTag(buffer.toString(), branch, template, lineNumber, tags, warnings);
                            tagList.add(t);
                            buffer = new StringBuilder();
                            phase = 0;
                            break block0;
                        }
                    }
                    buffer.append(c);
                    break;
                }
                case 2: {
                    Tag t;
                    switch (c) {
                        case '}': {
                            t = this.parseAttributeTag(buffer.toString(), branch, template, lineNumber, warnings);
                            tagList.add(t);
                            buffer = new StringBuilder();
                            phase = 0;
                            break block0;
                        }
                    }
                    buffer.append(c);
                }
            }
            ++pos;
        }
        if (phase == 0) {
            if (buffer.length() > 0) {
                StaticTextTag t = new StaticTextTag();
                String[] args = new String[]{buffer.toString()};
                t.initializeForBranch(this, branch, args, lineNumber, warnings);
                tagList.add(t);
            }
        } else {
            Message message = ToolMessages.ERR_MAKELDIF_INCOMPLETE_TAG.get(lineNumber);
            throw new InitializationException(message);
        }
        Tag[] tagArray = new Tag[tagList.size()];
        tagList.toArray(tagArray);
        return new TemplateLine(attributeType, lineNumber, tagArray);
    }

    private Tag parseReplacementTag(String tagString, Branch branch, Template template, int lineNumber, LinkedHashMap<String, Tag> tags, List<Message> warnings) throws InitializationException, MakeLDIFException {
        Tag newTag;
        StringTokenizer tokenizer = new StringTokenizer(tagString, ":");
        String tagName = tokenizer.nextToken().trim();
        String lowerTagName = StaticUtils.toLowerCase(tagName);
        Tag t = this.getTag(lowerTagName);
        if (t == null && (t = tags.get(lowerTagName)) == null) {
            Message message = ToolMessages.ERR_MAKELDIF_NO_SUCH_TAG.get(tagName, lineNumber);
            throw new MakeLDIFException(message);
        }
        ArrayList<String> argList = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            argList.add(tokenizer.nextToken().trim());
        }
        String[] args = new String[argList.size()];
        argList.toArray(args);
        try {
            newTag = (Tag)t.getClass().newInstance();
        }
        catch (Exception e) {
            Message message = ToolMessages.ERR_MAKELDIF_CANNOT_INSTANTIATE_NEW_TAG.get(tagName, lineNumber, String.valueOf(e));
            throw new MakeLDIFException(message, (Throwable)e);
        }
        if (branch == null) {
            newTag.initializeForTemplate(this, template, args, lineNumber, warnings);
        } else if (newTag.allowedInBranch()) {
            newTag.initializeForBranch(this, branch, args, lineNumber, warnings);
        } else {
            Message message = ToolMessages.ERR_MAKELDIF_TAG_NOT_ALLOWED_IN_BRANCH.get(newTag.getName(), lineNumber);
            throw new MakeLDIFException(message);
        }
        return newTag;
    }

    private Tag parseAttributeTag(String tagString, Branch branch, Template template, int lineNumber, List<Message> warnings) throws InitializationException, MakeLDIFException {
        StringTokenizer tokenizer = new StringTokenizer(tagString, ":");
        ArrayList<String> argList = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            argList.add(tokenizer.nextToken());
        }
        String[] args = new String[argList.size()];
        argList.toArray(args);
        AttributeValueTag tag = new AttributeValueTag();
        if (branch == null) {
            tag.initializeForTemplate(this, template, args, lineNumber, warnings);
        } else {
            tag.initializeForBranch(this, branch, args, lineNumber, warnings);
        }
        return tag;
    }

    public File getFile(String path) {
        File f = new File(path);
        if (f.exists()) {
            return f;
        }
        if (f.isAbsolute()) {
            return f;
        }
        String newPath = this.resourcePath + File.separator + path;
        f = new File(newPath);
        if (f.exists()) {
            return f;
        }
        if (this.templatePath != null && (f = new File(newPath = (this.templatePath = File.separator + path))).exists()) {
            return f;
        }
        return null;
    }

    public String[] getFileLines(File file) throws IOException {
        String absolutePath = file.getAbsolutePath();
        String[] lines = this.fileLines.get(absolutePath);
        if (lines == null) {
            String line;
            ArrayList<String> lineList = new ArrayList<String>();
            BufferedReader reader = new BufferedReader(new FileReader(file));
            while ((line = reader.readLine()) != null) {
                lineList.add(line);
            }
            reader.close();
            lines = new String[lineList.size()];
            lineList.toArray(lines);
            lineList.clear();
            this.fileLines.put(absolutePath, lines);
        }
        return lines;
    }

    public TagResult generateLDIF(EntryWriter entryWriter) throws IOException, MakeLDIFException {
        for (Branch b : this.branches.values()) {
            TagResult result = b.writeEntries(entryWriter);
            if (result.keepProcessingTemplateFile()) continue;
            return result;
        }
        entryWriter.closeEntryWriter();
        return TagResult.SUCCESS_RESULT;
    }
}

