/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.BitSet;
import org.opends.messages.Message;
import org.opends.messages.ProtocolMessages;
import org.opends.server.config.ConfigException;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.StabilityLevel;

@PublicAPI(stability=StabilityLevel.VOLATILE, mayInstantiate=true, mayExtend=false, mayInvoke=true)
public final class AddressMask {
    private RuleType ruleType;
    private static final int IN4ADDRSZ = 4;
    private static final int IPV4MAXPREFIX = 32;
    private static final int IN6ADDRSZ = 16;
    private static final int IPV6MAXPREFIX = 128;
    private byte[] ruleMask;
    private byte[] prefixMask;
    private final BitSet wildCard = new BitSet();
    private String[] hostName;
    private String hostPattern;
    private String ruleString;

    private AddressMask(String rule) throws ConfigException {
        this.determineRuleType(rule);
        switch (this.ruleType) {
            case IPv6: {
                this.processIPv6(rule);
                break;
            }
            case IPv4: {
                this.processIpv4(rule);
                break;
            }
            case HOST: {
                this.processHost(rule);
                break;
            }
            case HOSTPATTERN: {
                this.processHostPattern(rule);
                break;
            }
            case ALLWILDCARD: {
                this.processAllWilds(rule);
            }
        }
        this.ruleString = rule;
    }

    private void determineRuleType(String ruleString) throws ConfigException {
        if (ruleString.endsWith(".")) {
            Message message = ProtocolMessages.ERR_ADDRESSMASK_FORMAT_DECODE_ERROR.get();
            throw new ConfigException(message);
        }
        if (ruleString.startsWith(".")) {
            this.ruleType = RuleType.HOSTPATTERN;
        } else if (ruleString.startsWith("[") || ruleString.indexOf(58) != -1) {
            this.ruleType = RuleType.IPv6;
        } else {
            int wildCount = 0;
            String[] s = ruleString.split("\\.", -1);
            this.ruleType = RuleType.HOST;
            for (String value : s) {
                if (value.equals("*")) {
                    ++wildCount;
                    continue;
                }
                if (!Character.isDigit(value.charAt(0))) continue;
                this.ruleType = RuleType.IPv4;
                break;
            }
            if (wildCount == s.length) {
                this.ruleType = RuleType.ALLWILDCARD;
            }
        }
    }

    private void processIpv4(String rule) throws ConfigException {
        String[] s = rule.split("/", -1);
        this.ruleMask = new byte[4];
        this.prefixMask = new byte[4];
        this.prefixMask(this.processPrefix(s, 32));
        this.processIPv4Subnet(s.length == 0 ? rule : s[0]);
    }

    private void processAllWilds(String rule) {
        String[] s = rule.split("\\.", -1);
        if (s.length == 4) {
            for (int i = 0; i < 4; ++i) {
                this.wildCard.set(i);
            }
        }
        this.hostName = rule.split("\\.", -1);
    }

    private void processHostPattern(String rule) throws ConfigException {
        String[] s = rule.split("^[0-9a-zA-z-.]+");
        if (s.length > 0) {
            Message message = ProtocolMessages.ERR_ADDRESSMASK_FORMAT_DECODE_ERROR.get();
            throw new ConfigException(message);
        }
        this.hostPattern = rule;
    }

    private void processHost(String rule) throws ConfigException {
        String[] s = rule.split("^[0-9a-zA-z-.*]+");
        if (s.length > 0) {
            Message message = ProtocolMessages.ERR_ADDRESSMASK_FORMAT_DECODE_ERROR.get();
            throw new ConfigException(message);
        }
        this.hostName = rule.split("\\.", -1);
    }

    private void prefixMask(int prefix) {
        int i = 0;
        while (prefix > 8) {
            this.prefixMask[i] = -1;
            prefix -= 8;
            ++i;
        }
        this.prefixMask[i] = (byte)(255 << 8 - prefix);
    }

    private void processIPv4Subnet(String subnet) throws ConfigException {
        String[] s = subnet.split("\\.", -1);
        try {
            if (s.length != 4) {
                Message message = ProtocolMessages.ERR_ADDRESSMASK_FORMAT_DECODE_ERROR.get();
                throw new ConfigException(message);
            }
            for (int i = 0; i < 4; ++i) {
                String quad = s[i].trim();
                if (quad.equals("*")) {
                    this.wildCard.set(i);
                    continue;
                }
                long val = Integer.parseInt(quad);
                if (val < 0L || val > 255L) {
                    Message message = ProtocolMessages.ERR_ADDRESSMASK_FORMAT_DECODE_ERROR.get();
                    throw new ConfigException(message);
                }
                this.ruleMask[i] = (byte)(val & 0xFFL);
            }
        }
        catch (NumberFormatException nfex) {
            Message message = ProtocolMessages.ERR_ADDRESSMASK_FORMAT_DECODE_ERROR.get();
            throw new ConfigException(message);
        }
    }

    private int processPrefix(String[] s, int maxPrefix) throws ConfigException {
        int prefix = maxPrefix;
        try {
            if (s.length < 1 || s.length > 2) {
                Message message = ProtocolMessages.ERR_ADDRESSMASK_FORMAT_DECODE_ERROR.get();
                throw new ConfigException(message);
            }
            if (s.length == 2) {
                if (s[0].indexOf(42) > -1) {
                    Message message = ProtocolMessages.ERR_ADDRESSMASK_WILDCARD_DECODE_ERROR.get();
                    throw new ConfigException(message);
                }
                prefix = Integer.parseInt(s[1]);
            }
            if (prefix < 0 || prefix > maxPrefix) {
                Message message = ProtocolMessages.ERR_ADDRESSMASK_PREFIX_DECODE_ERROR.get();
                throw new ConfigException(message);
            }
        }
        catch (NumberFormatException nfex) {
            Message msg = ProtocolMessages.ERR_ADDRESSMASK_FORMAT_DECODE_ERROR.get();
            throw new ConfigException(msg);
        }
        return prefix;
    }

    public static AddressMask decode(String maskString) throws ConfigException {
        return new AddressMask(maskString);
    }

    public static boolean maskListContains(byte[] remoteAddr, String remoteName, AddressMask[] masks) {
        for (AddressMask mask : masks) {
            if (!mask.match(remoteAddr, remoteName)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.ruleString;
    }

    private boolean match(byte[] remoteAddr, String remoteName) {
        boolean ret = false;
        switch (this.ruleType) {
            case IPv6: 
            case IPv4: {
                ret = this.matchAddress(remoteAddr);
                break;
            }
            case HOST: {
                ret = this.matchHostName(remoteName);
                break;
            }
            case HOSTPATTERN: {
                ret = this.matchPattern(remoteName);
                break;
            }
            case ALLWILDCARD: {
                ret = this.matchAddress(remoteAddr);
                if (ret) break;
                ret = this.matchHostName(remoteName);
            }
        }
        return ret;
    }

    private boolean matchPattern(String remoteHostName) {
        int len = remoteHostName.length() - this.hostPattern.length();
        return len > 0 && remoteHostName.regionMatches(true, len, this.hostPattern, 0, this.hostPattern.length());
    }

    private boolean matchHostName(String remoteHostName) {
        String[] s = remoteHostName.split("\\.", -1);
        if (s.length != this.hostName.length) {
            return false;
        }
        if (this.ruleType == RuleType.ALLWILDCARD) {
            return true;
        }
        for (int i = 0; i < s.length; ++i) {
            if (this.hostName[i].equals("*") || s[i].equalsIgnoreCase(this.hostName[i])) continue;
            return false;
        }
        return true;
    }

    private boolean matchAddress(byte[] remoteMask) {
        if (this.prefixMask == null) {
            return false;
        }
        if (remoteMask.length != this.prefixMask.length) {
            return false;
        }
        if (this.ruleType == RuleType.ALLWILDCARD) {
            return true;
        }
        for (int i = 0; i < this.prefixMask.length; ++i) {
            if (this.wildCard.get(i) || (this.ruleMask[i] & this.prefixMask[i]) == (remoteMask[i] & this.prefixMask[i])) continue;
            return false;
        }
        return true;
    }

    private void processIPv6(String rule) throws ConfigException {
        InetAddress addr;
        String[] s = rule.split("/", -1);
        try {
            addr = InetAddress.getByName(s[0]);
        }
        catch (UnknownHostException ex) {
            Message message = ProtocolMessages.ERR_ADDRESSMASK_FORMAT_DECODE_ERROR.get();
            throw new ConfigException(message);
        }
        if (addr instanceof Inet6Address) {
            this.ruleType = RuleType.IPv6;
            Inet6Address addr6 = (Inet6Address)addr;
            this.ruleMask = addr6.getAddress();
            this.prefixMask = new byte[16];
            this.prefixMask(this.processPrefix(s, 128));
        } else {
            if (s.length == 2) {
                Message message = ProtocolMessages.ERR_ADDRESSMASK_FORMAT_DECODE_ERROR.get();
                throw new ConfigException(message);
            }
            this.ruleMask = addr.getAddress();
            this.ruleType = RuleType.IPv4;
            this.prefixMask = new byte[4];
            this.prefixMask(this.processPrefix(s, 32));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum RuleType {
        IPv4,
        IPv6,
        HOSTPATTERN,
        ALLWILDCARD,
        HOST;

    }
}

