/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.TreeSet;
import org.opends.messages.CoreMessages;
import org.opends.messages.Message;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteString;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.ResultCode;
import org.opends.server.types.StabilityLevel;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@PublicAPI(stability=StabilityLevel.UNCOMMITTED, mayInstantiate=true, mayExtend=false, mayInvoke=true)
public final class RDN
implements Comparable<RDN> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private AttributeType[] attributeTypes;
    private AttributeValue[] attributeValues;
    private int numValues;
    private String normalizedRDN;
    private String rdnString;
    private String[] attributeNames;

    public RDN(AttributeType attributeType, AttributeValue attributeValue) {
        this.attributeTypes = new AttributeType[]{attributeType};
        this.attributeNames = new String[]{attributeType.getPrimaryName()};
        this.attributeValues = new AttributeValue[]{attributeValue};
        this.numValues = 1;
        this.rdnString = null;
        this.normalizedRDN = null;
    }

    public RDN(AttributeType attributeType, String attributeName, AttributeValue attributeValue) {
        this.attributeTypes = new AttributeType[]{attributeType};
        this.attributeNames = new String[]{attributeName};
        this.attributeValues = new AttributeValue[]{attributeValue};
        this.numValues = 1;
        this.rdnString = null;
        this.normalizedRDN = null;
    }

    public RDN(List<AttributeType> attributeTypes, List<String> attributeNames, List<AttributeValue> attributeValues) {
        this.attributeTypes = new AttributeType[attributeTypes.size()];
        this.attributeNames = new String[attributeNames.size()];
        this.attributeValues = new AttributeValue[attributeValues.size()];
        attributeTypes.toArray(this.attributeTypes);
        attributeNames.toArray(this.attributeNames);
        attributeValues.toArray(this.attributeValues);
        this.numValues = attributeTypes.size();
        this.rdnString = null;
        this.normalizedRDN = null;
    }

    public RDN(AttributeType[] attributeTypes, String[] attributeNames, AttributeValue[] attributeValues) {
        this.numValues = attributeTypes.length;
        this.attributeTypes = attributeTypes;
        this.attributeNames = attributeNames;
        this.attributeValues = attributeValues;
        this.rdnString = null;
        this.normalizedRDN = null;
    }

    public static RDN create(AttributeType attributeType, AttributeValue attributeValue) {
        return new RDN(attributeType, attributeValue);
    }

    public int getNumValues() {
        return this.numValues;
    }

    public boolean hasAttributeType(AttributeType attributeType) {
        for (AttributeType t : this.attributeTypes) {
            if (!t.equals(attributeType)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAttributeType(String lowerName) {
        for (AttributeType t : this.attributeTypes) {
            if (!t.hasNameOrOID(lowerName)) continue;
            return true;
        }
        for (String s : this.attributeNames) {
            if (!s.equalsIgnoreCase(lowerName)) continue;
            return true;
        }
        return false;
    }

    public AttributeType getAttributeType(int pos) {
        return this.attributeTypes[pos];
    }

    public String getAttributeName(int pos) {
        return this.attributeNames[pos];
    }

    public AttributeValue getAttributeValue(AttributeType attributeType) {
        for (int i = 0; i < this.numValues; ++i) {
            if (!this.attributeTypes[i].equals(attributeType)) continue;
            return this.attributeValues[i];
        }
        return null;
    }

    public AttributeValue getAttributeValue(int pos) {
        return this.attributeValues[pos];
    }

    public boolean isMultiValued() {
        return this.numValues > 1;
    }

    public boolean hasValue(AttributeType type, AttributeValue value) {
        for (int i = 0; i < this.numValues; ++i) {
            if (!this.attributeTypes[i].equals(type) || !this.attributeValues[i].equals(value)) continue;
            return true;
        }
        return false;
    }

    boolean addValue(AttributeType type, String name, AttributeValue value) {
        for (int i = 0; i < this.numValues; ++i) {
            if (!this.attributeTypes[i].equals(type) || !this.attributeValues[i].equals(value)) continue;
            return false;
        }
        ++this.numValues;
        AttributeType[] newTypes = new AttributeType[this.numValues];
        System.arraycopy(this.attributeTypes, 0, newTypes, 0, this.attributeTypes.length);
        newTypes[this.attributeTypes.length] = type;
        this.attributeTypes = newTypes;
        String[] newNames = new String[this.numValues];
        System.arraycopy(this.attributeNames, 0, newNames, 0, this.attributeNames.length);
        newNames[this.attributeNames.length] = name;
        this.attributeNames = newNames;
        AttributeValue[] newValues = new AttributeValue[this.numValues];
        System.arraycopy(this.attributeValues, 0, newValues, 0, this.attributeValues.length);
        newValues[this.attributeValues.length] = value;
        this.attributeValues = newValues;
        this.rdnString = null;
        this.normalizedRDN = null;
        return true;
    }

    private static String getDNValue(String value) {
        if (value == null || value.length() == 0) {
            return "";
        }
        boolean needsEscaping = false;
        int length = value.length();
        char c = value.charAt(0);
        if (c == ' ' || c == '#') {
            needsEscaping = true;
        } else if (value.charAt(length - 1) == ' ') {
            needsEscaping = true;
        } else {
            block6: for (int i = 0; i < length; ++i) {
                c = value.charAt(i);
                if (c < ' ') {
                    needsEscaping = true;
                    break;
                }
                switch (c) {
                    case '\"': 
                    case '+': 
                    case ',': 
                    case ';': 
                    case '<': 
                    case '>': 
                    case '\\': {
                        needsEscaping = true;
                        break block6;
                    }
                    default: {
                        continue block6;
                    }
                }
            }
        }
        if (!needsEscaping) {
            return value;
        }
        StringBuilder buffer = new StringBuilder(length + 3);
        int start = 0;
        char c2 = value.charAt(0);
        if (c2 == ' ' || c2 == '#') {
            buffer.append('\\');
            buffer.append(c2);
            start = 1;
        }
        block7: for (int i = start; i < length; ++i) {
            c2 = value.charAt(i);
            if (c2 < ' ') {
                for (byte b : StaticUtils.getBytes(String.valueOf(c2))) {
                    buffer.append('\\');
                    buffer.append(StaticUtils.byteToLowerHex(b));
                }
                continue;
            }
            switch (value.charAt(i)) {
                case '\"': 
                case '+': 
                case ',': 
                case ';': 
                case '<': 
                case '>': 
                case '\\': {
                    buffer.append('\\');
                    buffer.append(c2);
                    continue block7;
                }
                default: {
                    buffer.append(c2);
                }
            }
        }
        if (value.charAt(length - 1) == ' ') {
            length = buffer.length();
            buffer.insert(length - 1, '\\');
        }
        return buffer.toString();
    }

    public static RDN decode(String rdnString) throws DirectoryException {
        if (rdnString == null) {
            Message message = CoreMessages.ERR_RDN_DECODE_NULL.get();
            throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message);
        }
        int length = rdnString.length();
        if (length == 0) {
            Message message = CoreMessages.ERR_RDN_DECODE_NULL.get();
            throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message);
        }
        int pos = 0;
        char c = rdnString.charAt(pos);
        while (c == ' ') {
            if (++pos == length) {
                Message message = CoreMessages.ERR_RDN_DECODE_NULL.get();
                throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message);
            }
            c = rdnString.charAt(pos);
        }
        StringBuilder attributeName = new StringBuilder();
        boolean allowExceptions = DirectoryServer.allowAttributeNameExceptions();
        if ((pos = DN.parseAttributeName(rdnString, pos, attributeName, allowExceptions)) >= length) {
            Message message = CoreMessages.ERR_RDN_END_WITH_ATTR_NAME.get(rdnString, attributeName.toString());
            throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message);
        }
        c = rdnString.charAt(pos);
        while (c == ' ') {
            if (++pos >= length) {
                Message message = CoreMessages.ERR_RDN_END_WITH_ATTR_NAME.get(rdnString, attributeName.toString());
                throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message);
            }
            c = rdnString.charAt(pos);
        }
        if (c == '=') {
            ++pos;
        } else {
            Message message = CoreMessages.ERR_RDN_NO_EQUAL.get(rdnString, attributeName.toString(), Character.valueOf(c));
            throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message);
        }
        while (pos < length && (c = rdnString.charAt(pos)) == ' ') {
            ++pos;
        }
        if (pos >= length) {
            String name = attributeName.toString();
            String lowerName = StaticUtils.toLowerCase(name);
            AttributeType attrType = DirectoryServer.getAttributeType(lowerName);
            if (attrType == null) {
                attrType = DirectoryServer.getDefaultAttributeType(name);
            }
            AttributeValue value = new AttributeValue(new ASN1OctetString(), (ByteString)new ASN1OctetString());
            return new RDN(attrType, name, value);
        }
        ASN1OctetString parsedValue = new ASN1OctetString();
        pos = DN.parseAttributeValue(rdnString, pos, (ByteString)parsedValue);
        String name = attributeName.toString();
        String lowerName = StaticUtils.toLowerCase(name);
        AttributeType attrType = DirectoryServer.getAttributeType(lowerName);
        if (attrType == null) {
            attrType = DirectoryServer.getDefaultAttributeType(name);
        }
        AttributeValue value = new AttributeValue(attrType, (ByteString)parsedValue);
        RDN rdn = new RDN(attrType, name, value);
        while (pos < length && (c = rdnString.charAt(pos)) == ' ') {
            ++pos;
        }
        if (pos >= length) {
            return rdn;
        }
        if (c == ',' || c == ';') {
            Message message = CoreMessages.ERR_RDN_UNEXPECTED_COMMA.get(rdnString, pos);
            throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message);
        }
        if (c != '+') {
            Message message = CoreMessages.ERR_RDN_ILLEGAL_CHARACTER.get(rdnString, Character.valueOf(c), pos);
            throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message);
        }
        do {
            ++pos;
            while (pos < length && (c = rdnString.charAt(pos)) == ' ') {
                ++pos;
            }
            attributeName = new StringBuilder();
            if ((pos = DN.parseAttributeName(rdnString, pos, attributeName, allowExceptions)) >= length) {
                Message message = CoreMessages.ERR_RDN_END_WITH_ATTR_NAME.get(rdnString, attributeName.toString());
                throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message);
            }
            c = rdnString.charAt(pos);
            while (c == ' ') {
                if (++pos >= length) {
                    Message message = CoreMessages.ERR_RDN_END_WITH_ATTR_NAME.get(rdnString, attributeName.toString());
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message);
                }
                c = rdnString.charAt(pos);
            }
            if (c == '=') {
                ++pos;
            } else {
                Message message = CoreMessages.ERR_RDN_NO_EQUAL.get(rdnString, attributeName.toString(), Character.valueOf(c));
                throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message);
            }
            while (pos < length && (c = rdnString.charAt(pos)) == ' ') {
                ++pos;
            }
            if (pos >= length) {
                name = attributeName.toString();
                lowerName = StaticUtils.toLowerCase(name);
                attrType = DirectoryServer.getAttributeType(lowerName);
                if (attrType == null) {
                    attrType = DirectoryServer.getDefaultAttributeType(name);
                }
                value = new AttributeValue(new ASN1OctetString(), (ByteString)new ASN1OctetString());
                rdn.addValue(attrType, name, value);
                return rdn;
            }
            parsedValue = new ASN1OctetString();
            pos = DN.parseAttributeValue(rdnString, pos, (ByteString)parsedValue);
            name = attributeName.toString();
            lowerName = StaticUtils.toLowerCase(name);
            attrType = DirectoryServer.getAttributeType(lowerName);
            if (attrType == null) {
                attrType = DirectoryServer.getDefaultAttributeType(name);
            }
            value = new AttributeValue(attrType, (ByteString)parsedValue);
            rdn.addValue(attrType, name, value);
            while (pos < length && (c = rdnString.charAt(pos)) == ' ') {
                ++pos;
            }
            if (pos >= length) {
                return rdn;
            }
            if (c != ',' && c != ';') continue;
            Message message = CoreMessages.ERR_RDN_UNEXPECTED_COMMA.get(rdnString, pos);
            throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message);
        } while (c == '+');
        Message message = CoreMessages.ERR_RDN_ILLEGAL_CHARACTER.get(rdnString, Character.valueOf(c), pos);
        throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message);
    }

    public RDN duplicate() {
        AttributeType[] newTypes = new AttributeType[this.numValues];
        System.arraycopy(this.attributeTypes, 0, newTypes, 0, this.numValues);
        String[] newNames = new String[this.numValues];
        System.arraycopy(this.attributeNames, 0, newNames, 0, this.numValues);
        AttributeValue[] newValues = new AttributeValue[this.numValues];
        System.arraycopy(this.attributeValues, 0, newValues, 0, this.numValues);
        return new RDN(newTypes, newNames, newValues);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof RDN)) {
            return false;
        }
        RDN rdn = (RDN)o;
        return this.toNormalizedString().equals(rdn.toNormalizedString());
    }

    public int hashCode() {
        return this.toNormalizedString().hashCode();
    }

    public String toString() {
        if (this.rdnString == null) {
            StringBuilder buffer = new StringBuilder();
            buffer.append(this.attributeNames[0]);
            buffer.append("=");
            String s = this.attributeValues[0].getStringValue();
            buffer.append(RDN.getDNValue(s));
            for (int i = 1; i < this.numValues; ++i) {
                buffer.append("+");
                buffer.append(this.attributeNames[i]);
                buffer.append("=");
                s = this.attributeValues[i].getStringValue();
                buffer.append(RDN.getDNValue(s));
            }
            this.rdnString = buffer.toString();
        }
        return this.rdnString;
    }

    public void toString(StringBuilder buffer) {
        buffer.append(this.toString());
    }

    public String toNormalizedString() {
        if (this.normalizedRDN == null) {
            StringBuilder buffer = new StringBuilder();
            this.toNormalizedString(buffer);
        }
        return this.normalizedRDN;
    }

    public void toNormalizedString(StringBuilder buffer) {
        boolean bufferEmpty;
        if (this.normalizedRDN != null) {
            buffer.append(this.normalizedRDN);
            return;
        }
        boolean bl = bufferEmpty = buffer.length() == 0;
        if (this.attributeNames.length == 1) {
            StaticUtils.toLowerCase(this.attributeTypes[0].getNameOrOID(), buffer);
            buffer.append('=');
            try {
                String s = this.attributeValues[0].getNormalizedStringValue();
                buffer.append(RDN.getDNValue(s));
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                String s = this.attributeValues[0].getStringValue();
                buffer.append(RDN.getDNValue(s));
            }
        } else {
            TreeSet<String> rdnElementStrings = new TreeSet<String>();
            for (int i = 0; i < this.attributeNames.length; ++i) {
                StringBuilder b2 = new StringBuilder();
                StaticUtils.toLowerCase(this.attributeTypes[i].getNameOrOID(), b2);
                b2.append('=');
                try {
                    String s = this.attributeValues[i].getNormalizedStringValue();
                    b2.append(RDN.getDNValue(s));
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    String s = this.attributeValues[i].getStringValue();
                    b2.append(RDN.getDNValue(s));
                }
                rdnElementStrings.add(b2.toString());
            }
            Iterator iterator = rdnElementStrings.iterator();
            buffer.append((String)iterator.next());
            while (iterator.hasNext()) {
                buffer.append('+');
                buffer.append((String)iterator.next());
            }
        }
        if (bufferEmpty) {
            this.normalizedRDN = buffer.toString();
        }
    }

    @Override
    public int compareTo(RDN rdn) {
        if (this.attributeTypes.length == 1 && rdn.attributeTypes.length == 1) {
            if (this.attributeTypes[0].equals(rdn.attributeTypes[0])) {
                OrderingMatchingRule omr = this.attributeTypes[0].getOrderingMatchingRule();
                if (omr == null) {
                    try {
                        return this.attributeValues[0].getNormalizedStringValue().compareTo(rdn.attributeValues[0].getNormalizedStringValue());
                    }
                    catch (Exception e) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                        return this.attributeValues[0].getStringValue().compareTo(rdn.attributeValues[0].getStringValue());
                    }
                }
                try {
                    return omr.compareValues(this.attributeValues[0].getNormalizedValue(), rdn.attributeValues[0].getNormalizedValue());
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    return omr.compareValues(this.attributeValues[0].getValue(), rdn.attributeValues[0].getValue());
                }
            }
            String name1 = StaticUtils.toLowerCase(this.attributeTypes[0].getNameOrOID());
            String name2 = StaticUtils.toLowerCase(rdn.attributeTypes[0].getNameOrOID());
            return name1.compareTo(name2);
        }
        if (this.equals(rdn)) {
            return 0;
        }
        TreeMap<String, AttributeType> typeMap1 = new TreeMap<String, AttributeType>();
        TreeMap<String, AttributeValue> valueMap1 = new TreeMap<String, AttributeValue>();
        for (int i = 0; i < this.attributeTypes.length; ++i) {
            String lowerName = StaticUtils.toLowerCase(this.attributeTypes[i].getNameOrOID());
            typeMap1.put(lowerName, this.attributeTypes[i]);
            valueMap1.put(lowerName, this.attributeValues[i]);
        }
        TreeMap<String, AttributeType> typeMap2 = new TreeMap<String, AttributeType>();
        TreeMap<String, AttributeValue> valueMap2 = new TreeMap<String, AttributeValue>();
        for (int i = 0; i < rdn.attributeTypes.length; ++i) {
            String lowerName = StaticUtils.toLowerCase(rdn.attributeTypes[i].getNameOrOID());
            typeMap2.put(lowerName, rdn.attributeTypes[i]);
            valueMap2.put(lowerName, rdn.attributeValues[i]);
        }
        Iterator iterator1 = valueMap1.keySet().iterator();
        Iterator iterator2 = valueMap2.keySet().iterator();
        String name1 = (String)iterator1.next();
        String name2 = (String)iterator2.next();
        AttributeType type1 = (AttributeType)typeMap1.get(name1);
        AttributeType type2 = (AttributeType)typeMap2.get(name2);
        AttributeValue value1 = (AttributeValue)valueMap1.get(name1);
        AttributeValue value2 = (AttributeValue)valueMap2.get(name2);
        while (type1.equals(type2)) {
            int valueComparison;
            OrderingMatchingRule omr = type1.getOrderingMatchingRule();
            if (omr == null) {
                try {
                    valueComparison = value1.getNormalizedStringValue().compareTo(value2.getNormalizedStringValue());
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    valueComparison = value1.getStringValue().compareTo(value2.getStringValue());
                }
            } else {
                try {
                    valueComparison = omr.compareValues(value1.getNormalizedValue(), value2.getNormalizedValue());
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    valueComparison = omr.compareValues(value1.getValue(), value2.getValue());
                }
            }
            if (valueComparison == 0) {
                if (!iterator1.hasNext()) {
                    if (iterator2.hasNext()) {
                        return -1;
                    }
                    return 0;
                }
                if (!iterator2.hasNext()) {
                    return 1;
                }
                name1 = (String)iterator1.next();
                name2 = (String)iterator2.next();
                type1 = (AttributeType)typeMap1.get(name1);
                type2 = (AttributeType)typeMap2.get(name2);
                value1 = (AttributeValue)valueMap1.get(name1);
                value2 = (AttributeValue)valueMap2.get(name2);
                continue;
            }
            return valueComparison;
        }
        return name1.compareTo(name2);
    }
}

