/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming;

import java.nio.ByteBuffer;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkConf;
import org.apache.spark.serializer.Serializer;
import org.apache.spark.serializer.SerializerManager;
import org.apache.spark.streaming.BinlogWriteAheadLog$;
import org.apache.spark.streaming.RawEvent;
import org.apache.spark.streaming.util.WriteAheadLog;
import org.apache.spark.streaming.util.WriteAheadLogRecordHandle;
import org.apache.spark.streaming.util.WriteAheadLogUtils$;
import org.apache.spark.util.Clock;
import org.apache.spark.util.io.ChunkedByteBuffer;
import scala.Function1;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005]b\u0001B\u0001\u0003\u0001-\u00111CQ5oY><wK]5uK\u0006CW-\u00193M_\u001eT!a\u0001\u0003\u0002\u0013M$(/Z1nS:<'BA\u0003\u0007\u0003\u0015\u0019\b/\u0019:l\u0015\t9\u0001\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0013\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\u0004\t\u0003\u001bAi\u0011A\u0004\u0006\u0002\u001f\u0005)1oY1mC&\u0011\u0011C\u0004\u0002\u0007\u0003:L(+\u001a4\t\u0011M\u0001!\u0011!Q\u0001\nQ\t\u0001b]3sm\u0016\u0014\u0018\n\u001a\t\u0003+aq!!\u0004\f\n\u0005]q\u0011A\u0002)sK\u0012,g-\u0003\u0002\u001a5\t11\u000b\u001e:j]\u001eT!a\u0006\b\t\u0011q\u0001!\u0011!Q\u0001\nu\t\u0011c]3sS\u0006d\u0017N_3s\u001b\u0006t\u0017mZ3s!\tq\u0012%D\u0001 \u0015\t\u0001C!\u0001\u0006tKJL\u0017\r\\5{KJL!AI\u0010\u0003#M+'/[1mSj,'/T1oC\u001e,'\u000f\u0003\u0005%\u0001\t\u0005\t\u0015!\u0003&\u0003\u0011\u0019wN\u001c4\u0011\u0005\u0019:S\"\u0001\u0003\n\u0005!\"!!C*qCJ\\7i\u001c8g\u0011!Q\u0003A!A!\u0002\u0013Y\u0013A\u00035bI>|\u0007oQ8oMB\u0011A\u0006M\u0007\u0002[)\u0011AE\f\u0006\u0003_\u0019\ta\u0001[1e_>\u0004\u0018BA\u0019.\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\"A1\u0007\u0001B\u0001B\u0003%A#A\u0007dQ\u0016\u001c7\u000e]8j]R$\u0015N\u001d\u0005\tk\u0001\u0011\t\u0011)A\u0005m\u0005)1\r\\8dWB\u0011qGO\u0007\u0002q)\u0011\u0011\bB\u0001\u0005kRLG.\u0003\u0002<q\t)1\t\\8dW\")Q\b\u0001C\u0001}\u00051A(\u001b8jiz\"raP!C\u0007\u0012+e\t\u0005\u0002A\u00015\t!\u0001C\u0003\u0014y\u0001\u0007A\u0003C\u0003\u001dy\u0001\u0007Q\u0004C\u0003%y\u0001\u0007Q\u0005C\u0003+y\u0001\u00071\u0006C\u00034y\u0001\u0007A\u0003C\u00046yA\u0005\t\u0019\u0001\u001c\t\u000f!\u0003!\u0019!C\u0005\u0013\u0006iqO]5uK\u0006CW-\u00193M_\u001e,\u0012A\u0013\t\u0003\u00176k\u0011\u0001\u0014\u0006\u0003s\tI!A\u0014'\u0003\u001b]\u0013\u0018\u000e^3BQ\u0016\fG\rT8h\u0011\u0019\u0001\u0006\u0001)A\u0005\u0015\u0006qqO]5uK\u0006CW-\u00193M_\u001e\u0004\u0003\"\u0002*\u0001\t\u0003\u0019\u0016!B<sSR,GC\u0001+X!\tYU+\u0003\u0002W\u0019\nIrK]5uK\u0006CW-\u00193M_\u001e\u0014VmY8sI\"\u000bg\u000e\u001a7f\u0011\u0015A\u0016\u000b1\u0001Z\u0003\u0015IG/Z7t!\rQ&-\u001a\b\u00037\u0002t!\u0001X0\u000e\u0003uS!A\u0018\u0006\u0002\rq\u0012xn\u001c;?\u0013\u0005y\u0011BA1\u000f\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u00193\u0003\u0007M+\u0017O\u0003\u0002b\u001dA\u0011\u0001IZ\u0005\u0003O\n\u0011\u0001BU1x\u000bZ,g\u000e\u001e\u0005\u0006S\u0002!\tA[\u0001\u0005e\u0016\fG\r\u0006\u0002l]B\u0011Q\u0002\\\u0005\u0003[:\u0011A!\u00168ji\")q\u000e\u001ba\u0001a\u0006\ta\r\u0005\u0003\u000ecf[\u0017B\u0001:\u000f\u0005%1UO\\2uS>t\u0017\u0007C\u0003u\u0001\u0011\u0005Q/\u0001\tdY\u0016\fg.\u001e9PY\u0012\u0014En\\2lgR\u00191N^>\t\u000b]\u001c\b\u0019\u0001=\u0002\u0015QD'/Z:i)&lW\r\u0005\u0002\u000es&\u0011!P\u0004\u0002\u0005\u0019>tw\rC\u0004}gB\u0005\t\u0019A?\u0002#]\f\u0017\u000e\u001e$pe\u000e{W\u000e\u001d7fi&|g\u000e\u0005\u0002\u000e}&\u0011qP\u0004\u0002\b\u0005>|G.Z1o\u0011\u001d\t\u0019\u0001\u0001C\u0001\u0003\u000b\tAa\u001d;paR\t1\u000eC\u0005\u0002\n\u0001\t\n\u0011\"\u0001\u0002\f\u0005Q2\r\\3b]V\u0004x\n\u001c3CY>\u001c7n\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011Q\u0002\u0016\u0004{\u0006=1FAA\t!\u0011\t\u0019\"!\b\u000e\u0005\u0005U!\u0002BA\f\u00033\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005ma\"\u0001\u0006b]:|G/\u0019;j_:LA!a\b\u0002\u0016\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\b\u0013\u0005\r\"!!A\t\u0002\u0005\u0015\u0012a\u0005\"j]2|wm\u0016:ji\u0016\f\u0005.Z1e\u0019><\u0007c\u0001!\u0002(\u0019A\u0011AAA\u0001\u0012\u0003\tIcE\u0002\u0002(1Aq!PA\u0014\t\u0003\ti\u0003\u0006\u0002\u0002&!Q\u0011\u0011GA\u0014#\u0003%\t!a\r\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00137+\t\t)DK\u00027\u0003\u001f\u0001")
public class BinlogWriteAheadLog {
    private final SerializerManager serializerManager;
    private final Clock clock;
    private final WriteAheadLog writeAheadLog;

    public static Clock $lessinit$greater$default$6() {
        return BinlogWriteAheadLog$.MODULE$.$lessinit$greater$default$6();
    }

    private WriteAheadLog writeAheadLog() {
        return this.writeAheadLog;
    }

    public WriteAheadLogRecordHandle write(Seq<RawEvent> items) {
        Serializer ser = this.serializerManager.getSerializer(ClassTag$.MODULE$.apply(RawEvent.class), true);
        ByteBuffer byteBuffer = ser.newInstance().serialize(items, ClassTag$.MODULE$.apply(Seq.class));
        ChunkedByteBuffer serializedBlock = new ChunkedByteBuffer(byteBuffer.duplicate());
        return this.writeAheadLog().write(serializedBlock.toByteBuffer(), this.clock.getTimeMillis());
    }

    public void read(Function1<Seq<RawEvent>, BoxedUnit> f) {
        Serializer ser = this.serializerManager.getSerializer(ClassTag$.MODULE$.apply(RawEvent.class), true);
        Iterator items = this.writeAheadLog().readAll();
        while (items.hasNext()) {
            Seq item = (Seq)ser.newInstance().deserialize((ByteBuffer)items.next(), ClassTag$.MODULE$.apply(Seq.class));
            f.apply((Object)item);
        }
    }

    public void cleanupOldBlocks(long threshTime, boolean waitForCompletion) {
        this.writeAheadLog().clean(threshTime, waitForCompletion);
    }

    public boolean cleanupOldBlocks$default$2() {
        return false;
    }

    public void stop() {
        this.writeAheadLog().close();
    }

    public BinlogWriteAheadLog(String serverId, SerializerManager serializerManager, SparkConf conf, Configuration hadoopConf, String checkpointDir, Clock clock) {
        this.serializerManager = serializerManager;
        this.clock = clock;
        this.writeAheadLog = WriteAheadLogUtils$.MODULE$.createLogForReceiver(conf, new Path(checkpointDir, new Path("receivedData", serverId)).toString(), hadoopConf);
    }
}

