/*
 * Decompiled with CFR 0.152.
 */
package tech.mlsql.binlog.common;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkException;
import org.slf4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.VolatileByteRef;
import tech.mlsql.binlog.common.BinlogConsumer;
import tech.mlsql.binlog.common.ConsumerCache;
import tech.mlsql.binlog.common.ConsumerCache$;
import tech.mlsql.common.utils.distribute.socket.server.ReportHostAndPort;
import tech.mlsql.common.utils.log.Logging;

public final class ConsumerCache$
implements Logging {
    public static final ConsumerCache$ MODULE$;
    private LinkedHashMap<ConsumerCache.CacheKey, BinlogConsumer> cache;
    private transient Logger tech$mlsql$common$utils$log$Logging$$log_;
    private volatile boolean bitmap$0;

    static {
        new ConsumerCache$();
    }

    private LinkedHashMap cache$lzycompute() {
        ConsumerCache$ consumerCache$ = this;
        synchronized (consumerCache$) {
            if (!this.bitmap$0) {
                SparkConf conf = SparkEnv$.MODULE$.get().conf();
                int capacity = conf.getInt("spark.sql.mlsql.binlog.capacity", 1024);
                this.cache = new LinkedHashMap<ConsumerCache.CacheKey, BinlogConsumer>(capacity){
                    public final int capacity$1;

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public boolean removeEldestEntry(Map.Entry<ConsumerCache.CacheKey, BinlogConsumer> entry) {
                        if (entry.getValue().inUse()) return false;
                        if (this.size() <= this.capacity$1) return false;
                        ConsumerCache$.MODULE$.logWarning((Function0<String>)new Serializable(this, entry){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anon.1 $outer;
                            private final Map.Entry entry$1;

                            public final String apply() {
                                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"BinlogConsumer cache hitting max capacity of ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.capacity$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"removing consumer for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.entry$1.getKey()}))).toString();
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.entry$1 = entry$1;
                            }
                        });
                        try {
                            entry.getValue().close();
                            return true;
                        }
                        catch (SparkException sparkException) {
                            ConsumerCache$.MODULE$.logError((Function0<String>)new Serializable(this, entry){
                                public static final long serialVersionUID = 0L;
                                private final Map.Entry entry$1;

                                public final String apply() {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error closing earliest binlog consumer for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.entry$1.getKey()}));
                                }
                                {
                                    this.entry$1 = entry$1;
                                }
                            }, sparkException);
                        }
                        return true;
                    }
                    {
                        this.capacity$1 = capacity$1;
                        super(capacity$1, 0.75f, true);
                    }
                };
                this.bitmap$0 = true;
            }
            return this.cache;
        }
    }

    public Logger tech$mlsql$common$utils$log$Logging$$log_() {
        return this.tech$mlsql$common$utils$log$Logging$$log_;
    }

    public void tech$mlsql$common$utils$log$Logging$$log__$eq(Logger x$1) {
        this.tech$mlsql$common$utils$log$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    private LinkedHashMap<ConsumerCache.CacheKey, BinlogConsumer> cache() {
        return this.bitmap$0 ? this.cache : this.cache$lzycompute();
    }

    public synchronized BinlogConsumer acquire(ReportHostAndPort hostAndPort, Function0<BinlogConsumer> createConsumerInstance) {
        BinlogConsumer binlogConsumer;
        ObjectRef newInternalConsumer$lzy = ObjectRef.zero();
        VolatileByteRef bitmap$0 = VolatileByteRef.create((byte)0);
        ConsumerCache.CacheKey key = new ConsumerCache.CacheKey(hostAndPort.host(), hostAndPort.port());
        BinlogConsumer existingInternalConsumer = this.cache().get(key);
        if (existingInternalConsumer == null) {
            this.cache().put(key, this.newInternalConsumer$1(createConsumerInstance, newInternalConsumer$lzy, bitmap$0));
            this.newInternalConsumer$1(createConsumerInstance, newInternalConsumer$lzy, bitmap$0).markInUse();
            binlogConsumer = this.newInternalConsumer$1(createConsumerInstance, newInternalConsumer$lzy, bitmap$0);
        } else if (existingInternalConsumer.inUse()) {
            binlogConsumer = this.newInternalConsumer$1(createConsumerInstance, newInternalConsumer$lzy, bitmap$0);
        } else {
            existingInternalConsumer.markInUse();
            binlogConsumer = existingInternalConsumer;
        }
        return binlogConsumer;
    }

    public void release(BinlogConsumer intConsumer) {
        ConsumerCache$ consumerCache$ = this;
        synchronized (consumerCache$) {
            Object object;
            ConsumerCache.CacheKey key = new ConsumerCache.CacheKey(intConsumer.targetHostAndPort().host(), intConsumer.targetHostAndPort().port());
            BinlogConsumer cachedIntConsumer = this.cache().get(key);
            if (intConsumer == cachedIntConsumer) {
                if (intConsumer.isClose()) {
                    intConsumer.close();
                    object = this.cache().remove(key);
                } else {
                    intConsumer.markInIdle();
                    object = BoxedUnit.UNIT;
                }
            } else {
                intConsumer.close();
                this.logInfo((Function0<String>)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Released a supposedly cached consumer that was not found in the cache"})).s((Seq)Nil$.MODULE$);
                    }
                });
                object = BoxedUnit.UNIT;
            }
            return;
        }
    }

    private final BinlogConsumer newInternalConsumer$lzycompute$1(Function0 createConsumerInstance$1, ObjectRef newInternalConsumer$lzy$1, VolatileByteRef bitmap$0$1) {
        ConsumerCache$ consumerCache$ = this;
        synchronized (consumerCache$) {
            if ((byte)(bitmap$0$1.elem & 1) == 0) {
                newInternalConsumer$lzy$1.elem = (BinlogConsumer)createConsumerInstance$1.apply();
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 1);
            }
            return (BinlogConsumer)newInternalConsumer$lzy$1.elem;
        }
    }

    private final BinlogConsumer newInternalConsumer$1(Function0 createConsumerInstance$1, ObjectRef newInternalConsumer$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 1) == 0 ? this.newInternalConsumer$lzycompute$1(createConsumerInstance$1, newInternalConsumer$lzy$1, bitmap$0$1) : (BinlogConsumer)newInternalConsumer$lzy$1.elem;
    }

    private ConsumerCache$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
    }
}

