/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JavaGeneratorTool {
    static Log logger = LogFactory.getLog((Class)(class$org$apache$tomcat$util$JavaGeneratorTool == null ? (class$org$apache$tomcat$util$JavaGeneratorTool = JavaGeneratorTool.class$("org.apache.tomcat.util.JavaGeneratorTool")) : class$org$apache$tomcat$util$JavaGeneratorTool));
    private static final String[] keywords = new String[]{"abstract", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while"};
    static /* synthetic */ Class class$org$apache$tomcat$util$JavaGeneratorTool;

    public static final String manglePackage(String s) {
        for (int i = 0; i < keywords.length; ++i) {
            char fs = File.separatorChar;
            int index = s.indexOf(keywords[i]);
            if (index == -1) continue;
            while (index != -1) {
                int endIdx = index + keywords[i].length();
                if (index > 0 && s.charAt(index - 1) != '/') {
                    index = s.indexOf(keywords[i], index + 3);
                    continue;
                }
                if (s.length() > endIdx && s.charAt(endIdx) != '/') {
                    index = s.indexOf(keywords[i], index + 3);
                    continue;
                }
                String tmpathName = s.substring(0, index) + "_";
                s = tmpathName + s.substring(index);
                index = s.indexOf(keywords[i], index + 2);
            }
        }
        s = JavaGeneratorTool.fixDigits(s);
        return s;
    }

    public static boolean isKeyword(String s) {
        for (int i = 0; i < keywords.length; ++i) {
            if (!s.equals(keywords[i])) continue;
            return true;
        }
        return false;
    }

    public static String fixDigits(String s) {
        int i = 0;
        if (s.length() == 0) {
            return s;
        }
        if (Character.isDigit(s.charAt(0))) {
            s = "_" + s;
        }
        while ((i = s.indexOf("/", i + 1)) >= 0 && i != s.length()) {
            if (Character.isDigit(s.charAt(i + 1))) {
                s = s.substring(0, i + 1) + "_" + s.substring(i + 1);
                ++i;
            }
            if (i > 0) continue;
        }
        return s;
    }

    public static int readVersion(String classDir, String baseClassName) {
        File mapFile = new File(classDir + File.separator + baseClassName + ".ver");
        if (!mapFile.exists()) {
            return -1;
        }
        int version = 0;
        try {
            FileInputStream fis = new FileInputStream(mapFile);
            if (fis.available() > 0) {
                version = fis.read();
            }
            fis.close();
        }
        catch (Exception ex) {
            logger.info((Object)("readVersion() mapPath=" + mapFile), (Throwable)ex);
            return -1;
        }
        String versionedFileName = classDir + "/" + JavaGeneratorTool.getVersionedName(baseClassName, version) + ".class";
        File vF = new File(versionedFileName);
        if (!vF.exists()) {
            return -1;
        }
        return version;
    }

    public static void writeVersion(String classDir, String baseClassName, int version) {
        File mapFile = new File(classDir + File.separator + baseClassName + ".ver");
        try {
            File dir = new File(mapFile.getParent());
            dir.mkdirs();
            FileOutputStream fis = new FileOutputStream(mapFile);
            fis.write(version);
            fis.close();
        }
        catch (Exception ex) {
            logger.info((Object)("writeVersion() " + mapFile), (Throwable)ex);
        }
    }

    public static String getVersionedName(String baseName, int version) {
        return baseName + "_" + version;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

