/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util;

import java.util.Random;

public class SessionIdGenerator {
    private static int session_count = 0;
    private static long lastTimeVal = 0L;
    public static final long maxRandomLen = 2176782336L;
    public static final long maxSessionLifespanTics = 46656L;
    public static final long ticDifference = 2000L;

    public static synchronized String getIdentifier(Random randomSource, String jsIdent) {
        StringBuffer sessionId = new StringBuffer();
        if (randomSource == null) {
            throw new RuntimeException("No random source ");
        }
        long n = randomSource.nextLong();
        if (n < 0L) {
            n = -n;
        }
        n %= 2176782336L;
        sessionId.append(Long.toString(n += 2176782336L, 36).substring(1));
        long timeVal = System.currentTimeMillis() / 2000L;
        timeVal %= 46656L;
        sessionId.append(Long.toString(timeVal += 46656L, 36).substring(1));
        if (lastTimeVal != timeVal) {
            lastTimeVal = timeVal;
            session_count = 0;
        }
        sessionId.append(Long.toString(++session_count, 36));
        if (jsIdent != null && jsIdent.length() > 0) {
            return sessionId.toString() + "." + jsIdent;
        }
        return sessionId.toString();
    }
}

