/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.depend;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tomcat.util.compat.SimpleClassLoader;
import org.apache.tomcat.util.depend.DependManager;
import org.apache.tomcat.util.depend.Dependency;

class DependClassLoader12Impl
extends URLClassLoader {
    static Log logger = LogFactory.getLog((Class)(class$org$apache$tomcat$util$depend$DependClassLoader12Impl == null ? (class$org$apache$tomcat$util$depend$DependClassLoader12Impl = DependClassLoader12Impl.class$("org.apache.tomcat.util.depend.DependClassLoader12Impl")) : class$org$apache$tomcat$util$depend$DependClassLoader12Impl));
    private static final String FILE_PROTOCOL = "file:";
    private static final String BANG = "!";
    protected ClassLoader parent;
    protected ClassLoader parent2;
    private static int debug = 0;
    DependManager dependM;
    protected Object pd;
    static /* synthetic */ Class class$org$apache$tomcat$util$depend$DependClassLoader12Impl;

    public DependClassLoader12Impl(DependManager depM, ClassLoader parent, Object pd, int debug) {
        super(new URL[0], parent);
        this.parent = parent;
        this.parent2 = parent.getParent();
        this.dependM = depM;
        this.pd = pd;
        DependClassLoader12Impl.debug = debug;
    }

    protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        final String lname = name;
        final boolean lresolve = resolve;
        try {
            return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return DependClassLoader12Impl.this.loadClassInternal1(lname, lresolve);
                }
            });
        }
        catch (PrivilegedActionException pex) {
            Exception ex = pex.getException();
            if (ex instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)ex;
            }
            ex.printStackTrace();
            throw new ClassNotFoundException(name);
        }
    }

    protected Class defineClassCompat(String name, byte[] data, int s, int end, URL res) throws ClassNotFoundException {
        Package p;
        String pkgname;
        int idx = name.lastIndexOf(".");
        String string = pkgname = idx != -1 ? name.substring(0, idx) : null;
        if (pkgname != null && (p = this.getPackage(pkgname)) == null) {
            if ("jar".equals(res.getProtocol())) {
                try {
                    JarFile JarF;
                    Manifest mf;
                    int bang;
                    String JarN = res.getFile();
                    if (JarN.startsWith(FILE_PROTOCOL)) {
                        JarN = JarN.substring(FILE_PROTOCOL.length());
                    }
                    if ((bang = JarN.indexOf(BANG)) != -1) {
                        JarN = JarN.substring(0, bang);
                    }
                    if ((mf = (JarF = new JarFile(JarN)).getManifest()) == null) {
                        throw new IOException("No Manifest");
                    }
                    Attributes main = mf.getMainAttributes();
                    Attributes pkg = mf.getAttributes(pkgname.replace('.', '/').concat("/"));
                    boolean sealed = Boolean.valueOf(this.getAttribute(Attributes.Name.SEALED, main, pkg));
                    this.definePackage(pkgname, this.getAttribute(Attributes.Name.SPECIFICATION_TITLE, main, pkg), this.getAttribute(Attributes.Name.SPECIFICATION_VERSION, main, pkg), this.getAttribute(Attributes.Name.SPECIFICATION_VENDOR, main, pkg), this.getAttribute(Attributes.Name.IMPLEMENTATION_TITLE, main, pkg), this.getAttribute(Attributes.Name.IMPLEMENTATION_VERSION, main, pkg), this.getAttribute(Attributes.Name.IMPLEMENTATION_VENDOR, main, pkg), sealed ? res : null);
                    JarF.close();
                }
                catch (IOException e) {
                    this.definePackage(pkgname, null, null, null, null, null, null, null);
                }
            } else {
                this.definePackage(pkgname, null, null, null, null, null, null, null);
            }
        }
        return this.defineClass(name, data, s, end, (ProtectionDomain)this.pd);
    }

    public URL[] getURLs() {
        if (this.parent instanceof URLClassLoader) {
            return ((URLClassLoader)this.parent).getURLs();
        }
        if (this.parent instanceof SimpleClassLoader) {
            return ((SimpleClassLoader)this.parent).getURLs();
        }
        return super.getURLs();
    }

    private String getAttribute(Attributes.Name key, Attributes main, Attributes pkg) {
        String value = null;
        if (pkg != null) {
            value = (String)pkg.get(key);
        }
        if (value == null) {
            value = (String)main.get(key);
        }
        return value;
    }

    public Enumeration findResources(String name) throws IOException {
        return this.parent.getResources(name);
    }

    protected Class loadClassInternal1(String name, boolean resolve) throws ClassNotFoundException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("loadClass() " + name + " " + resolve));
        }
        Class c = null;
        c = this.findLoadedClass(name);
        if (c != null) {
            if (resolve) {
                this.resolveClass(c);
            }
            return c;
        }
        String classFileName = name.replace('.', '/') + ".class";
        URL res = this.getResource(classFileName);
        try {
            c = this.parent2.loadClass(name);
            if (c != null) {
                if (resolve) {
                    this.resolveClass(c);
                }
                return c;
            }
        }
        catch (Exception e) {
            c = null;
        }
        if (res == null) {
            throw new ClassNotFoundException(name);
        }
        InputStream is = this.getResourceAsStream(classFileName);
        if (is == null) {
            throw new ClassNotFoundException(name);
        }
        byte[] data = null;
        try {
            if (is.available() > 0 && (data = this.readFully(is)).length == 0) {
                data = null;
            }
            is.close();
        }
        catch (IOException ex) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("error reading " + name), (Throwable)ex);
            }
            data = null;
            throw new ClassNotFoundException(name + " error reading " + ex.toString());
        }
        if (data == null) {
            throw new ClassNotFoundException(name + " lenght==0");
        }
        c = this.defineClassCompat(name, data, 0, data.length, res);
        this.dependency(c, res);
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    public URL getResource(String name) {
        return this.parent.getResource(name);
    }

    public InputStream getResourceAsStream(String name) {
        return this.parent.getResourceAsStream(name);
    }

    private void dependency(Class c, URL res) {
        if (res == null) {
            return;
        }
        File f = null;
        if ("file".equals(res.getProtocol())) {
            f = new File(res.getFile());
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("File dep " + f));
            }
            if (!f.exists()) {
                f = null;
            }
        }
        if ("jar".equals(res.getProtocol())) {
            String fileN = res.getFile();
            int idx = fileN.indexOf(BANG);
            if (idx >= 0) {
                fileN = fileN.substring(0, idx);
            }
            if (fileN.startsWith(FILE_PROTOCOL)) {
                fileN = fileN.substring(5);
            }
            if (fileN.startsWith("/file:")) {
                fileN = fileN.substring(6);
            }
            f = new File(fileN);
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Jar dep " + f + " " + f.exists()));
            }
            if (!f.exists()) {
                f = null;
            }
        }
        if (f == null) {
            return;
        }
        Dependency dep = new Dependency();
        dep.setLastModified(f.lastModified());
        dep.setTarget(c);
        dep.setOrigin(f);
        this.dependM.addDependency(dep);
    }

    private byte[] readFully(InputStream is) throws IOException {
        byte[] b = new byte[1024];
        int count = 0;
        int available = 1024;
        while (true) {
            int nRead;
            if ((nRead = is.read(b, count, available)) == -1) {
                byte[] result = new byte[count];
                System.arraycopy(b, 0, result, 0, count);
                return result;
            }
            count += nRead;
            if ((available -= nRead) != 0) continue;
            byte[] b1 = new byte[b.length * 2];
            available = b.length;
            System.arraycopy(b, 0, b1, 0, b.length);
            b = b1;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

