/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.deser.std;

import java.util.Collection;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonParser;
import tools.jackson.databind.BeanProperty;
import tools.jackson.databind.DeserializationConfig;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.ValueDeserializer;
import tools.jackson.databind.deser.SettableBeanProperty;
import tools.jackson.databind.deser.impl.ObjectIdReader;
import tools.jackson.databind.deser.std.StdDeserializer;
import tools.jackson.databind.jsontype.TypeDeserializer;
import tools.jackson.databind.type.LogicalType;
import tools.jackson.databind.util.AccessPattern;
import tools.jackson.databind.util.NameTransformer;

public abstract class DelegatingDeserializer
extends StdDeserializer<Object> {
    protected final ValueDeserializer<?> _delegatee;

    public DelegatingDeserializer(ValueDeserializer<?> d) {
        super(d.handledType());
        this._delegatee = d;
    }

    protected abstract ValueDeserializer<?> newDelegatingInstance(ValueDeserializer<?> var1);

    @Override
    public void resolve(DeserializationContext ctxt) {
        if (this._delegatee != null) {
            this._delegatee.resolve(ctxt);
        }
    }

    @Override
    public ValueDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) {
        JavaType vt = ctxt.constructType(this._delegatee.handledType());
        ValueDeserializer<?> del = ctxt.handleSecondaryContextualization(this._delegatee, property, vt);
        if (del == this._delegatee) {
            return this;
        }
        return this.newDelegatingInstance(del);
    }

    @Override
    public ValueDeserializer<Object> unwrappingDeserializer(DeserializationContext ctxt, NameTransformer unwrapper) {
        ValueDeserializer<?> unwrapping = this._delegatee.unwrappingDeserializer(ctxt, unwrapper);
        if (unwrapping == this._delegatee) {
            return this;
        }
        return this.newDelegatingInstance(unwrapping);
    }

    @Override
    public ValueDeserializer<?> replaceDelegatee(ValueDeserializer<?> delegatee) {
        if (delegatee == this._delegatee) {
            return this;
        }
        return this.newDelegatingInstance(delegatee);
    }

    @Override
    public Object deserialize(JsonParser p, DeserializationContext ctxt) throws JacksonException {
        return this._delegatee.deserialize(p, ctxt);
    }

    @Override
    public Object deserialize(JsonParser p, DeserializationContext ctxt, Object intoValue) throws JacksonException {
        return this._delegatee.deserialize(p, ctxt, intoValue);
    }

    @Override
    public Object deserializeWithType(JsonParser p, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws JacksonException {
        return this._delegatee.deserializeWithType(p, ctxt, typeDeserializer);
    }

    @Override
    public ValueDeserializer<?> getDelegatee() {
        return this._delegatee;
    }

    @Override
    public AccessPattern getNullAccessPattern() {
        return this._delegatee.getNullAccessPattern();
    }

    @Override
    public Object getNullValue(DeserializationContext ctxt) {
        return this._delegatee.getNullValue(ctxt);
    }

    @Override
    public Object getAbsentValue(DeserializationContext ctxt) {
        return this._delegatee.getAbsentValue(ctxt);
    }

    @Override
    public Object getEmptyValue(DeserializationContext ctxt) {
        return this._delegatee.getEmptyValue(ctxt);
    }

    @Override
    public AccessPattern getEmptyAccessPattern() {
        return this._delegatee.getEmptyAccessPattern();
    }

    @Override
    public LogicalType logicalType() {
        return this._delegatee.logicalType();
    }

    @Override
    public boolean isCachable() {
        return this._delegatee != null && this._delegatee.isCachable();
    }

    @Override
    public Collection<Object> getKnownPropertyNames() {
        return this._delegatee.getKnownPropertyNames();
    }

    @Override
    public ObjectIdReader getObjectIdReader(DeserializationContext ctxt) {
        return this._delegatee.getObjectIdReader(ctxt);
    }

    @Override
    public SettableBeanProperty findBackReference(String logicalName) {
        return this._delegatee.findBackReference(logicalName);
    }

    @Override
    public Boolean supportsUpdate(DeserializationConfig config) {
        return this._delegatee.supportsUpdate(config);
    }
}

