/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.jaxp;

import java.io.IOException;
import javax.xml.validation.TypeInfoProvider;
import javax.xml.validation.ValidatorHandler;
import org.apache.xerces.dom.DOMInputImpl;
import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.impl.xs.opti.DefaultXMLDocumentHandler;
import org.apache.xerces.jaxp.TeeXMLDocumentFilterImpl;
import org.apache.xerces.util.AttributesProxy;
import org.apache.xerces.util.AugmentationsImpl;
import org.apache.xerces.util.ErrorHandlerProxy;
import org.apache.xerces.util.ErrorHandlerWrapper;
import org.apache.xerces.util.LocatorProxy;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.util.XMLResourceIdentifierImpl;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLDocumentHandler;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLComponent;
import org.apache.xerces.xni.parser.XMLComponentManager;
import org.apache.xerces.xni.parser.XMLConfigurationException;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLErrorHandler;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.w3c.dom.TypeInfo;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

final class JAXPValidatorComponent
extends TeeXMLDocumentFilterImpl
implements XMLComponent {
    private static final String ENTITY_MANAGER = "http://apache.org/xml/properties/internal/entity-manager";
    private static final String ERROR_REPORTER = "http://apache.org/xml/properties/internal/error-reporter";
    private static final String SYMBOL_TABLE = "http://apache.org/xml/properties/internal/symbol-table";
    private final ValidatorHandler validator;
    private final XNI2SAX xni2sax = new XNI2SAX();
    private final SAX2XNI sax2xni = new SAX2XNI();
    private final TypeInfoProvider typeInfoProvider;
    private Augmentations fCurrentAug;
    private XMLAttributes fCurrentAttributes;
    private SymbolTable fSymbolTable;
    private XMLErrorReporter fErrorReporter;
    private XMLEntityResolver fEntityResolver;
    private static final TypeInfoProvider noInfoProvider = new TypeInfoProvider(){

        public TypeInfo getElementTypeInfo() {
            return null;
        }

        public TypeInfo getAttributeTypeInfo(int index) {
            return null;
        }

        public TypeInfo getAttributeTypeInfo(String attributeQName) {
            return null;
        }

        public TypeInfo getAttributeTypeInfo(String attributeUri, String attributeLocalName) {
            return null;
        }

        public boolean isIdAttribute(int index) {
            return false;
        }

        public boolean isSpecified(int index) {
            return false;
        }
    };

    public JAXPValidatorComponent(ValidatorHandler validatorHandler) {
        this.validator = validatorHandler;
        TypeInfoProvider tip = validatorHandler.getTypeInfoProvider();
        if (tip == null) {
            tip = noInfoProvider;
        }
        this.typeInfoProvider = tip;
        this.xni2sax.setContentHandler(this.validator);
        this.validator.setContentHandler(this.sax2xni);
        this.setSide(this.xni2sax);
        this.validator.setErrorHandler(new ErrorHandlerProxy(){

            protected XMLErrorHandler getErrorHandler() {
                XMLErrorHandler handler = JAXPValidatorComponent.this.fErrorReporter.getErrorHandler();
                if (handler != null) {
                    return handler;
                }
                return new ErrorHandlerWrapper(DraconianErrorHandler.getInstance());
            }
        });
        this.validator.setResourceResolver(new LSResourceResolver(){

            public LSInput resolveResource(String type, String ns, String publicId, String systemId, String baseUri) {
                if (JAXPValidatorComponent.this.fEntityResolver == null) {
                    return null;
                }
                try {
                    XMLInputSource is = JAXPValidatorComponent.this.fEntityResolver.resolveEntity(new XMLResourceIdentifierImpl(publicId, systemId, baseUri, null));
                    if (is == null) {
                        return null;
                    }
                    DOMInputImpl di = new DOMInputImpl();
                    di.setBaseURI(is.getBaseSystemId());
                    di.setByteStream(is.getByteStream());
                    di.setCharacterStream(is.getCharacterStream());
                    di.setEncoding(is.getEncoding());
                    di.setPublicId(is.getPublicId());
                    di.setSystemId(is.getSystemId());
                    return di;
                }
                catch (IOException e) {
                    throw new XNIException(e);
                }
            }
        });
    }

    public void startElement(QName element, XMLAttributes attributes, Augmentations augs) throws XNIException {
        this.fCurrentAttributes = attributes;
        this.fCurrentAug = augs;
        this.xni2sax.startElement(element, attributes, null);
        this.fCurrentAttributes = null;
    }

    public void endElement(QName element, Augmentations augs) throws XNIException {
        this.fCurrentAug = augs;
        this.xni2sax.endElement(element, null);
    }

    public void emptyElement(QName element, XMLAttributes attributes, Augmentations augs) throws XNIException {
        this.startElement(element, attributes, augs);
        this.endElement(element, augs);
    }

    public void characters(XMLString text, Augmentations augs) throws XNIException {
        this.fCurrentAug = augs;
        this.xni2sax.characters(text, null);
    }

    public void ignorableWhitespace(XMLString text, Augmentations augs) throws XNIException {
        this.fCurrentAug = augs;
        this.xni2sax.ignorableWhitespace(text, null);
    }

    public void reset(XMLComponentManager componentManager) throws XMLConfigurationException {
        this.fSymbolTable = (SymbolTable)componentManager.getProperty(SYMBOL_TABLE);
        this.fErrorReporter = (XMLErrorReporter)componentManager.getProperty(ERROR_REPORTER);
        try {
            this.fEntityResolver = (XMLEntityResolver)componentManager.getProperty(ENTITY_MANAGER);
        }
        catch (XMLConfigurationException e) {
            this.fEntityResolver = null;
        }
    }

    private void updateAttributes(Attributes atts) {
        int len = atts.getLength();
        for (int i = 0; i < len; ++i) {
            String aqn = atts.getQName(i);
            int j = this.fCurrentAttributes.getIndex(aqn);
            String av = atts.getValue(i);
            if (j == -1) {
                int idx = aqn.indexOf(58);
                String prefix = idx < 0 ? null : this.symbolize(aqn.substring(0, idx));
                j = this.fCurrentAttributes.addAttribute(new QName(prefix, this.symbolize(atts.getLocalName(i)), this.symbolize(aqn), this.symbolize(atts.getURI(i))), atts.getType(i), av);
                continue;
            }
            if (av.equals(this.fCurrentAttributes.getValue(j))) continue;
            this.fCurrentAttributes.setValue(j, av);
        }
    }

    private String symbolize(String s) {
        return this.fSymbolTable.addSymbol(s);
    }

    public String[] getRecognizedFeatures() {
        return null;
    }

    public void setFeature(String featureId, boolean state) throws XMLConfigurationException {
    }

    public String[] getRecognizedProperties() {
        return new String[]{ENTITY_MANAGER, ERROR_REPORTER, SYMBOL_TABLE};
    }

    public void setProperty(String propertyId, Object value) throws XMLConfigurationException {
    }

    public Boolean getFeatureDefault(String featureId) {
        return null;
    }

    public Object getPropertyDefault(String propertyId) {
        return null;
    }

    private static final class DraconianErrorHandler
    implements ErrorHandler {
        private static final DraconianErrorHandler ERROR_HANDLER_INSTANCE = new DraconianErrorHandler();

        private DraconianErrorHandler() {
        }

        public static DraconianErrorHandler getInstance() {
            return ERROR_HANDLER_INSTANCE;
        }

        public void warning(SAXParseException e) throws SAXException {
        }

        public void error(SAXParseException e) throws SAXException {
            throw e;
        }

        public void fatalError(SAXParseException e) throws SAXException {
            throw e;
        }
    }

    private static final class XNI2SAX
    extends DefaultXMLDocumentHandler {
        private ContentHandler fContentHandler;
        private String fVersion;
        protected NamespaceContext fNamespaceContext;
        private final AttributesProxy fAttributesProxy = new AttributesProxy(null);

        private XNI2SAX() {
        }

        public void setContentHandler(ContentHandler handler) {
            this.fContentHandler = handler;
        }

        public ContentHandler getContentHandler() {
            return this.fContentHandler;
        }

        public void xmlDecl(String version, String encoding, String standalone, Augmentations augs) throws XNIException {
            this.fVersion = version;
        }

        public void startDocument(XMLLocator locator, String encoding, NamespaceContext namespaceContext, Augmentations augs) throws XNIException {
            this.fNamespaceContext = namespaceContext;
            this.fContentHandler.setDocumentLocator(new LocatorProxy(locator));
            try {
                this.fContentHandler.startDocument();
            }
            catch (SAXException e) {
                throw new XNIException(e);
            }
        }

        public void endDocument(Augmentations augs) throws XNIException {
            try {
                this.fContentHandler.endDocument();
            }
            catch (SAXException e) {
                throw new XNIException(e);
            }
        }

        public void processingInstruction(String target, XMLString data, Augmentations augs) throws XNIException {
            try {
                this.fContentHandler.processingInstruction(target, data.toString());
            }
            catch (SAXException e) {
                throw new XNIException(e);
            }
        }

        public void startElement(QName element, XMLAttributes attributes, Augmentations augs) throws XNIException {
            try {
                int count = this.fNamespaceContext.getDeclaredPrefixCount();
                if (count > 0) {
                    String prefix = null;
                    String uri = null;
                    for (int i = 0; i < count; ++i) {
                        uri = this.fNamespaceContext.getURI(prefix = this.fNamespaceContext.getDeclaredPrefixAt(i));
                        this.fContentHandler.startPrefixMapping(prefix, uri == null ? "" : uri);
                    }
                }
                String uri = element.uri != null ? element.uri : "";
                String localpart = element.localpart;
                this.fAttributesProxy.setAttributes(attributes);
                this.fContentHandler.startElement(uri, localpart, element.rawname, this.fAttributesProxy);
            }
            catch (SAXException e) {
                throw new XNIException(e);
            }
        }

        public void endElement(QName element, Augmentations augs) throws XNIException {
            try {
                String uri = element.uri != null ? element.uri : "";
                String localpart = element.localpart;
                this.fContentHandler.endElement(uri, localpart, element.rawname);
                int count = this.fNamespaceContext.getDeclaredPrefixCount();
                if (count > 0) {
                    for (int i = 0; i < count; ++i) {
                        this.fContentHandler.endPrefixMapping(this.fNamespaceContext.getDeclaredPrefixAt(i));
                    }
                }
            }
            catch (SAXException e) {
                throw new XNIException(e);
            }
        }

        public void emptyElement(QName element, XMLAttributes attributes, Augmentations augs) throws XNIException {
            this.startElement(element, attributes, augs);
            this.endElement(element, augs);
        }

        public void characters(XMLString text, Augmentations augs) throws XNIException {
            try {
                this.fContentHandler.characters(text.ch, text.offset, text.length);
            }
            catch (SAXException e) {
                throw new XNIException(e);
            }
        }

        public void ignorableWhitespace(XMLString text, Augmentations augs) throws XNIException {
            try {
                this.fContentHandler.ignorableWhitespace(text.ch, text.offset, text.length);
            }
            catch (SAXException e) {
                throw new XNIException(e);
            }
        }
    }

    private final class SAX2XNI
    extends DefaultHandler {
        private final Augmentations fAugmentations = new AugmentationsImpl();
        private final QName fQName = new QName();

        private SAX2XNI() {
        }

        public void characters(char[] ch, int start, int len) throws SAXException {
            try {
                this.handler().characters(new XMLString(ch, start, len), this.aug());
            }
            catch (XNIException e) {
                throw this.toSAXException(e);
            }
        }

        public void ignorableWhitespace(char[] ch, int start, int len) throws SAXException {
            try {
                this.handler().ignorableWhitespace(new XMLString(ch, start, len), this.aug());
            }
            catch (XNIException e) {
                throw this.toSAXException(e);
            }
        }

        public void startElement(String uri, String localName, String qname, Attributes atts) throws SAXException {
            try {
                JAXPValidatorComponent.this.updateAttributes(atts);
                this.handler().startElement(this.toQName(uri, localName, qname), JAXPValidatorComponent.this.fCurrentAttributes, this.elementAug());
            }
            catch (XNIException e) {
                throw this.toSAXException(e);
            }
        }

        public void endElement(String uri, String localName, String qname) throws SAXException {
            try {
                this.handler().endElement(this.toQName(uri, localName, qname), this.aug());
            }
            catch (XNIException e) {
                throw this.toSAXException(e);
            }
        }

        private Augmentations elementAug() {
            Augmentations aug = this.aug();
            return aug;
        }

        private Augmentations aug() {
            if (JAXPValidatorComponent.this.fCurrentAug != null) {
                Augmentations r = JAXPValidatorComponent.this.fCurrentAug;
                JAXPValidatorComponent.this.fCurrentAug = null;
                return r;
            }
            this.fAugmentations.removeAllItems();
            return this.fAugmentations;
        }

        private XMLDocumentHandler handler() {
            return JAXPValidatorComponent.this.getDocumentHandler();
        }

        private SAXException toSAXException(XNIException xe) {
            Exception e = xe.getException();
            if (e == null) {
                e = xe;
            }
            if (e instanceof SAXException) {
                return (SAXException)e;
            }
            return new SAXException(e);
        }

        private QName toQName(String uri, String localName, String qname) {
            String prefix = null;
            int idx = qname.indexOf(58);
            if (idx > 0) {
                prefix = JAXPValidatorComponent.this.symbolize(qname.substring(0, idx));
            }
            localName = JAXPValidatorComponent.this.symbolize(localName);
            qname = JAXPValidatorComponent.this.symbolize(qname);
            uri = JAXPValidatorComponent.this.symbolize(uri);
            this.fQName.setValues(prefix, localName, qname, uri);
            return this.fQName;
        }
    }
}

