/*
 * Decompiled with CFR 0.152.
 */
package cn.tianqu.libs.app;

import android.app.Activity;
import android.app.Application;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import cn.tianqu.libs.app.common.NetworkUtil;
import cn.tianqu.libs.app.common.PrefUtil;
import cn.tianqu.libs.app.ui.BaseActivity;
import java.util.ArrayList;
import java.util.List;

public class BaseApp
extends Application {
    protected List<Activity> activityList = new ArrayList<Activity>();
    protected NetworkBroadcast networkBroadcast;
    private int activityCount;

    public void onCreate() {
        super.onCreate();
        PrefUtil.init(this);
        this.activityList.clear();
    }

    public void addActivity(Activity activity) {
        this.activityList.add(activity);
        if (this.networkBroadcast == null && !this.activityList.isEmpty()) {
            this.networkBroadcast = new NetworkBroadcast((Context)this);
            this.registerReceiver(this.networkBroadcast, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
        }
    }

    public void removeActivity(Activity activity) {
        this.activityList.remove(activity);
        if (this.networkBroadcast != null && this.activityList.isEmpty()) {
            this.unregisterReceiver(this.networkBroadcast);
            this.networkBroadcast = null;
        }
    }

    public void exitApp() {
        for (Activity activity : this.activityList) {
            activity.finish();
        }
        this.activityList.clear();
        if (this.networkBroadcast != null) {
            this.unregisterReceiver(this.networkBroadcast);
            this.networkBroadcast = null;
        }
    }

    public int getActivityCount() {
        return this.activityCount;
    }

    class NetworkBroadcast
    extends BroadcastReceiver {
        private boolean isHasNetwork = false;

        public NetworkBroadcast(Context context) {
            this.isHasNetwork = NetworkUtil.isNetworkConnected(context);
        }

        public void onReceive(Context context, Intent intent) {
            if (intent != null && intent.getAction().equals("android.net.conn.CONNECTIVITY_CHANGE") && NetworkUtil.isNetworkConnected(context) != this.isHasNetwork) {
                this.isHasNetwork = NetworkUtil.isNetworkConnected(context);
                for (Activity activity : BaseApp.this.activityList) {
                    if (!(activity instanceof BaseActivity)) continue;
                    ((BaseActivity)activity).onNetworkChange(this.isHasNetwork);
                }
            }
        }
    }
}

