/*
 * Decompiled with CFR 0.152.
 */
package cn.tianqu.libs.app.common.net;

import android.content.Context;
import android.text.TextUtils;
import cn.tianqu.libs.app.common.log.LogUtil;
import cn.tianqu.libs.app.common.net.ApiCallback;
import cn.tianqu.libs.app.common.net.MyAsyncHttpClient;
import cn.tianqu.libs.app.common.net.SimpleDownloadCallback;
import cn.tianqu.libs.app.common.net.Task;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.loopj.android.http.AsyncHttpResponseHandler;
import com.loopj.android.http.FileAsyncHttpResponseHandler;
import com.loopj.android.http.RequestHandle;
import com.loopj.android.http.RequestParams;
import com.loopj.android.http.TextHttpResponseHandler;
import cz.msebera.android.httpclient.Header;
import cz.msebera.android.httpclient.HttpEntity;
import java.io.File;
import java.util.List;
import java.util.Map;

public class BaseApi {
    public static final boolean DEBUG = true;
    public static final String TAG = BaseApi.class.getSimpleName();

    public static <T> Object parse2Obj(String jsonStr, Class<T> tClass) throws JSONException {
        try {
            if (TextUtils.isEmpty((CharSequence)jsonStr)) {
                jsonStr = "{}";
            }
            return JSON.parseObject((String)jsonStr, tClass);
        }
        catch (JSONException e) {
            throw new JSONException(e.getMessage());
        }
    }

    public static <T> List<T> parse2List(String jsonStr, Class<T> tClass) throws JSONException {
        try {
            if (TextUtils.isEmpty((CharSequence)jsonStr)) {
                jsonStr = "[]";
            }
            return JSON.parseArray((String)jsonStr, tClass);
        }
        catch (JSONException e) {
            throw new JSONException(e.getMessage());
        }
    }

    private TextHttpResponseHandler createResponseHandler(final ApiCallback<String> callback) {
        return new TextHttpResponseHandler(){

            public void onFailure(int statusCode, Header[] headers, String responseString, Throwable throwable) {
                callback.onFailure(String.valueOf(statusCode), responseString);
            }

            public void onSuccess(int statusCode, Header[] headers, String responseString) {
                LogUtil.d(true, TAG, "\u8bf7\u6c42\u6210\u529f:" + responseString);
                callback.onSuccess(responseString);
            }

            public void onFinish() {
                super.onFinish();
                callback.onFinish();
            }

            public void onRetry(int retryNo) {
                super.onRetry(retryNo);
                LogUtil.d(true, TAG, "\u518d\u6b21\u8bf7\u6c42:" + retryNo);
            }

            public void onStart() {
                super.onStart();
                callback.onStart();
            }

            public void onCancel() {
                super.onCancel();
                callback.onCancel();
            }
        };
    }

    protected Task post(Context context, String url, Map<String, String> headerMap, HttpEntity entity, String contentType, ApiCallback<String> callback) {
        LogUtil.d(true, TAG, "\u63a5\u53e3POST\u8bf7\u6c42\u5f00\u59cb\uff1a" + url + " \u53c2\u6570\uff1a" + entity.toString());
        final RequestHandle rh = MyAsyncHttpClient.post(context, url, headerMap, entity, contentType, (AsyncHttpResponseHandler)this.createResponseHandler(callback));
        return new Task(){

            @Override
            public boolean isFinished() {
                return rh.isFinished();
            }

            @Override
            public boolean cancel(boolean mayInteruptIfRunning) {
                return rh.cancel(mayInteruptIfRunning);
            }

            @Override
            public boolean isCanceled() {
                return rh.isCancelled();
            }
        };
    }

    protected Task post(Context context, String url, Map<String, String> headerMap, RequestParams params, ApiCallback<String> callback) {
        LogUtil.d(true, TAG, "\u63a5\u53e3POST\u8bf7\u6c42\u5f00\u59cb\uff1a" + url + " \u53c2\u6570\uff1a" + params.toString());
        final RequestHandle rh = MyAsyncHttpClient.post(context, url, headerMap, params, (AsyncHttpResponseHandler)this.createResponseHandler(callback));
        return new Task(){

            @Override
            public boolean isFinished() {
                return rh.isFinished();
            }

            @Override
            public boolean cancel(boolean mayInteruptIfRunning) {
                return rh.cancel(mayInteruptIfRunning);
            }

            @Override
            public boolean isCanceled() {
                return rh.isCancelled();
            }
        };
    }

    protected Task post(Context context, String url, Map<String, String> paramsMap, ApiCallback<String> callback) {
        return this.post(context, url, new RequestParams(paramsMap), callback);
    }

    protected Task post(Context context, String url, RequestParams params, ApiCallback<String> callback) {
        return this.post(context, url, null, params, callback);
    }

    protected Task post(Context context, String url, Map<String, String> headerMap, Map<String, String> paramsMap, ApiCallback<String> callback) {
        return this.post(context, url, headerMap, new RequestParams(paramsMap), callback);
    }

    protected Task delete(Context context, String url, Map<String, String> headerMap, HttpEntity entity, String contentType, ApiCallback<String> callback) {
        LogUtil.d(true, TAG, "\u63a5\u53e3DELETE\u8bf7\u6c42\u5f00\u59cb\uff1a" + url + (entity == null ? "" : " \u53c2\u6570\uff1a" + entity.toString()));
        final RequestHandle rh = MyAsyncHttpClient.delete(context, url, headerMap, entity, contentType, (AsyncHttpResponseHandler)this.createResponseHandler(callback));
        return new Task(){

            @Override
            public boolean isFinished() {
                return rh.isFinished();
            }

            @Override
            public boolean cancel(boolean mayInteruptIfRunning) {
                return rh.cancel(mayInteruptIfRunning);
            }

            @Override
            public boolean isCanceled() {
                return rh.isCancelled();
            }
        };
    }

    protected Task get(Context context, String url, Map<String, String> headerMap, HttpEntity entity, String contentType, ApiCallback<String> callback) {
        LogUtil.d(true, TAG, "\u63a5\u53e3GET\u8bf7\u6c42\u5f00\u59cb\uff1a" + url + (entity == null ? "" : " \u53c2\u6570\uff1a" + entity.toString()));
        final RequestHandle rh = MyAsyncHttpClient.get(context, url, headerMap, entity, contentType, (AsyncHttpResponseHandler)this.createResponseHandler(callback));
        return new Task(){

            @Override
            public boolean isFinished() {
                return rh.isFinished();
            }

            @Override
            public boolean cancel(boolean mayInteruptIfRunning) {
                return rh.cancel(mayInteruptIfRunning);
            }

            @Override
            public boolean isCanceled() {
                return rh.isCancelled();
            }
        };
    }

    protected Task get(Context context, String url, Map<String, String> headerMap, RequestParams params, ApiCallback<String> callback) {
        LogUtil.d(true, TAG, "\u63a5\u53e3GET\u8bf7\u6c42\u5f00\u59cb\uff1a" + url + (params == null ? "" : " \u53c2\u6570\uff1a" + params.toString()));
        final RequestHandle rh = MyAsyncHttpClient.get(context, url, headerMap, params, (AsyncHttpResponseHandler)this.createResponseHandler(callback));
        return new Task(){

            @Override
            public boolean isFinished() {
                return rh.isFinished();
            }

            @Override
            public boolean cancel(boolean mayInteruptIfRunning) {
                return rh.cancel(mayInteruptIfRunning);
            }

            @Override
            public boolean isCanceled() {
                return rh.isCancelled();
            }
        };
    }

    protected Task get(Context context, String url, ApiCallback<String> callback) {
        return this.get(context, url, null, new RequestParams(), callback);
    }

    protected Task get(Context context, String url, Map<String, String> paramsMap, ApiCallback<String> callback) {
        return this.get(context, url, new RequestParams(paramsMap), callback);
    }

    protected Task get(Context context, String url, Map<String, String> headerMap, Map<String, String> paramsMap, ApiCallback<String> callback) {
        return this.get(context, url, headerMap, new RequestParams(paramsMap), callback);
    }

    protected Task get(Context context, String url, RequestParams params, ApiCallback<String> callback) {
        return this.get(context, url, null, params, callback);
    }

    public Task download(Context context, String url, File downloadPath, final SimpleDownloadCallback callback) {
        final RequestHandle rh = MyAsyncHttpClient.get(context, url, null, null, (AsyncHttpResponseHandler)new FileAsyncHttpResponseHandler(downloadPath){

            public void onStart() {
                super.onStart();
                callback.onStart(callback.getT());
            }

            public void onProgress(long bytesWritten, long totalSize) {
                super.onProgress(bytesWritten, totalSize);
                callback.onProgress(callback.getT(), bytesWritten, totalSize);
            }

            public void onFailure(int statusCode, Header[] headers, Throwable throwable, File file) {
                callback.onFailure(callback.getT(), file);
            }

            public void onSuccess(int statusCode, Header[] headers, File file) {
                callback.onSuccess(callback.getT(), file);
            }

            public void onFinish() {
                super.onFinish();
                callback.onFinish(callback.getT());
            }

            public void onCancel() {
                super.onCancel();
                callback.onCancel(callback.getT());
            }
        });
        return new Task(){

            @Override
            public boolean isFinished() {
                return rh.isFinished();
            }

            @Override
            public boolean cancel(boolean mayInteruptIfRunning) {
                return rh.cancel(mayInteruptIfRunning);
            }

            @Override
            public boolean isCanceled() {
                return rh.isCancelled();
            }
        };
    }
}

