/*
 * Decompiled with CFR 0.152.
 */
package cn.tianqu.libs.app.common.net;

import android.content.Context;
import android.net.NetworkInfo;
import android.support.annotation.NonNull;
import cn.tianqu.libs.app.common.NetworkUtil;
import com.loopj.android.http.AsyncHttpClient;
import com.loopj.android.http.AsyncHttpResponseHandler;
import com.loopj.android.http.RequestHandle;
import com.loopj.android.http.RequestParams;
import com.loopj.android.http.ResponseHandlerInterface;
import cz.msebera.android.httpclient.HttpEntity;
import java.util.Map;

public class MyAsyncHttpClient {
    private static AsyncHttpClient client = new AsyncHttpClient();

    public static void init() {
        client.setTimeout(30000);
        client.setMaxRetriesAndTimeout(2, 1000);
    }

    public static void initProxy(Context context) {
        NetworkInfo netInfo = NetworkUtil.getNetWorkInfo(context, 0);
        if (netInfo != null && netInfo.getType() == 0) {
            String netExtraInfo = netInfo.getExtraInfo();
            if ("cmwap".equalsIgnoreCase(netExtraInfo) || "uniwap".equalsIgnoreCase(netExtraInfo) || "3gwap".equalsIgnoreCase(netExtraInfo)) {
                client.setProxy("10.0.0.172", 80);
            } else if ("ctwap".equalsIgnoreCase(netExtraInfo)) {
                client.setProxy("10.0.0.200", 80);
            }
        }
    }

    public static RequestHandle post(Context context, String url, Map<String, String> headerMap, @NonNull RequestParams params, AsyncHttpResponseHandler rpsHandler) {
        if (headerMap != null && !headerMap.isEmpty()) {
            for (Map.Entry<String, String> entry : headerMap.entrySet()) {
                client.addHeader(entry.getKey(), entry.getValue());
            }
        }
        return client.post(context, url, params, (ResponseHandlerInterface)rpsHandler);
    }

    public static RequestHandle post(Context context, String url, Map<String, String> headerMap, HttpEntity httpEntity, String contentType, AsyncHttpResponseHandler rpsHandler) {
        if (headerMap != null && !headerMap.isEmpty()) {
            for (Map.Entry<String, String> entry : headerMap.entrySet()) {
                client.addHeader(entry.getKey(), entry.getValue());
            }
        }
        return client.post(context, url, httpEntity, contentType, (ResponseHandlerInterface)rpsHandler);
    }

    public static RequestHandle get(Context context, String url, Map<String, String> headerMap, RequestParams params, AsyncHttpResponseHandler rpsHandler) {
        if (headerMap != null && !headerMap.isEmpty()) {
            for (Map.Entry<String, String> entry : headerMap.entrySet()) {
                client.addHeader(entry.getKey(), entry.getValue());
            }
        }
        if (params == null) {
            return client.get(context, url, (ResponseHandlerInterface)rpsHandler);
        }
        return client.get(context, url, params, (ResponseHandlerInterface)rpsHandler);
    }

    public static RequestHandle get(Context context, String url, Map<String, String> headerMap, HttpEntity httpEntity, String contentType, AsyncHttpResponseHandler rpsHandler) {
        if (headerMap != null && !headerMap.isEmpty()) {
            for (Map.Entry<String, String> entry : headerMap.entrySet()) {
                client.addHeader(entry.getKey(), entry.getValue());
            }
        }
        return client.get(context, url, httpEntity, contentType, (ResponseHandlerInterface)rpsHandler);
    }

    public static RequestHandle delete(Context context, String url, Map<String, String> headerMap, HttpEntity httpEntity, String contentType, AsyncHttpResponseHandler rpsHandler) {
        if (headerMap != null && !headerMap.isEmpty()) {
            for (Map.Entry<String, String> entry : headerMap.entrySet()) {
                client.addHeader(entry.getKey(), entry.getValue());
            }
        }
        return client.delete(context, url, httpEntity, contentType, (ResponseHandlerInterface)rpsHandler);
    }

    public static void cancelRequests(Context context, boolean mayInterruptIfRunning) {
        client.cancelRequests(context, mayInterruptIfRunning);
    }

    public static void cancelAllRequests(boolean mayInterruptIfRunning) {
        client.cancelAllRequests(mayInterruptIfRunning);
    }
}

