/*
 * Decompiled with CFR 0.152.
 */
package cn.tianqu.libs.app.common.permission;

import android.content.DialogInterface;
import android.support.annotation.RequiresApi;
import cn.tianqu.libs.app.common.permission.PermissionUtils;
import cn.tianqu.libs.app.common.permission.RationaleDialogConfig;
import cn.tianqu.libs.app.common.permission.RationaleDialogFragment;
import cn.tianqu.libs.app.common.permission.RationaleDialogFragmentCompat;
import java.util.Arrays;

public class RationaleDialogClickListener
implements DialogInterface.OnClickListener {
    private Object mHost;
    private RationaleDialogConfig mConfig;
    private PermissionUtils.PermissionCallbacks mCallbacks;

    RationaleDialogClickListener(RationaleDialogFragmentCompat compatDialogFragment, RationaleDialogConfig config, PermissionUtils.PermissionCallbacks callbacks) {
        this.mHost = compatDialogFragment.getParentFragment() != null ? compatDialogFragment.getParentFragment() : compatDialogFragment.getActivity();
        this.mConfig = config;
        this.mCallbacks = callbacks;
    }

    @RequiresApi(api=11)
    RationaleDialogClickListener(RationaleDialogFragment dialogFragment, RationaleDialogConfig config, PermissionUtils.PermissionCallbacks callbacks) {
        this.mHost = dialogFragment.getActivity();
        this.mConfig = config;
        this.mCallbacks = callbacks;
    }

    public void onClick(DialogInterface dialog, int which) {
        if (which == -1) {
            PermissionUtils.executePermissionsRequest(this.mHost, this.mConfig.permissions, this.mConfig.requestCode);
        } else {
            this.notifyPermissionDenied();
        }
    }

    private void notifyPermissionDenied() {
        if (this.mCallbacks != null) {
            this.mCallbacks.onPermissionDenied(this.mConfig.requestCode, Arrays.asList(this.mConfig.permissions));
        }
    }
}

