/*
 * Decompiled with CFR 0.152.
 */
package cn.tianqu.libs.app.common.permission;

import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.StringRes;
import android.support.v7.app.AlertDialog;

public class RationaleDialogConfig {
    private static final String KEY_POSITIVE_BUTTON = "positiveButton";
    private static final String KEY_NEGATIVE_BUTTOn = "negativeButton";
    private static final String KEY_RATIONALE_MESSAGE = "rationaleMsg";
    private static final String KEY_REQUEST_CODE = "requestCode";
    private static final String KEY_PERMISSIONS = "permissions";
    int positiveButton;
    int negativeButton;
    int requestCode;
    String rationaleMsg;
    String[] permissions;

    RationaleDialogConfig(@StringRes int positiveButton, @StringRes int negativeButton, @NonNull String rationaleMsg, int requestCode, @NonNull String[] permissions) {
        this.positiveButton = positiveButton;
        this.negativeButton = negativeButton;
        this.rationaleMsg = rationaleMsg;
        this.requestCode = requestCode;
        this.permissions = permissions;
    }

    RationaleDialogConfig(Bundle bundle) {
        this.positiveButton = bundle.getInt(KEY_POSITIVE_BUTTON);
        this.negativeButton = bundle.getInt(KEY_NEGATIVE_BUTTOn);
        this.rationaleMsg = bundle.getString(KEY_RATIONALE_MESSAGE);
        this.requestCode = bundle.getInt(KEY_REQUEST_CODE);
        this.permissions = bundle.getStringArray(KEY_PERMISSIONS);
    }

    Bundle toBundle() {
        Bundle bundle = new Bundle();
        bundle.putInt(KEY_POSITIVE_BUTTON, this.positiveButton);
        bundle.putInt(KEY_NEGATIVE_BUTTOn, this.negativeButton);
        bundle.putString(KEY_RATIONALE_MESSAGE, this.rationaleMsg);
        bundle.putInt(KEY_REQUEST_CODE, this.requestCode);
        bundle.putStringArray(KEY_PERMISSIONS, this.permissions);
        return bundle;
    }

    AlertDialog createDialog(Context context, DialogInterface.OnClickListener listener) {
        return new AlertDialog.Builder(context).setCancelable(false).setPositiveButton(this.positiveButton, listener).setNegativeButton(this.negativeButton, listener).setMessage((CharSequence)this.rationaleMsg).create();
    }
}

