/*
 * Decompiled with CFR 0.152.
 */
package androidx.annotation.experimental.lint;

import androidx.annotation.experimental.lint.AnnotationRetentionDetectorKt;
import androidx.annotation.experimental.lint.ExperimentalDetectorKt;
import com.android.tools.lint.client.api.Configuration;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.AnnotationInfo;
import com.android.tools.lint.detector.api.AnnotationOrigin;
import com.android.tools.lint.detector.api.AnnotationUsageInfo;
import com.android.tools.lint.detector.api.AnnotationUsageType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.lang.Language;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.util.capitalizeDecapitalize.CapitalizeDecapitalizeKt;
import org.jetbrains.uast.UAnnotated;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UAnonymousClass;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.ULambdaExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0005\u0018\u0000 G2\u00020\u00012\u00020\u0002:\u0001GB\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016JL\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00052\b\u0010\u001c\u001a\u0004\u0018\u00010\u0019H\u0002J.\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002J \u0010#\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010$\u001a\u00020\u000b2\u0006\u0010%\u001a\u00020\u0017H\u0002J \u0010&\u001a\u00020'2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u0006H\u0002J \u0010+\u001a\u00020'2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010$\u001a\u00020\u000b2\u0006\u0010*\u001a\u00020\u0006H\u0002JV\u0010,\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010%\u001a\u0004\u0018\u00010\u00172\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00052\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00052\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00052\u0006\u0010$\u001a\u00020\u000b2\b\u00100\u001a\u0004\u0018\u000101H\u0002J$\u00102\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00052\u0006\u00103\u001a\u0002042\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0005H\u0002J2\u00105\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u0005062\b\u00100\u001a\u0004\u0018\u0001012\u0006\u00103\u001a\u000204H\u0002J\u0010\u00107\u001a\u0002082\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J0\u00109\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010$\u001a\u00020\u000b2\u0006\u0010*\u001a\u00020\u00062\u0006\u0010:\u001a\u00020\u00062\u0006\u0010;\u001a\u00020\u0006H\u0002J(\u0010<\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010(\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\u0018\u0010=\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010>\u001a\u00020?H\u0016J\u0018\u0010=\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010@\u001a\u00020AH\u0016J\u0012\u0010B\u001a\b\u0012\u0004\u0012\u00020\u00190C*\u00020\u0019H\u0002J*\u0010D\u001a\u000208*\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010E\u001a\u00020\u00062\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002J$\u0010F\u001a\u000208*\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010E\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR \u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006H"}, d2={"Landroidx/annotation/experimental/lint/ExperimentalDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "relevantAnnotations", "", "", "getRelevantAnnotations", "()Ljava/util/List;", "visitedUsages", "", "Lorg/jetbrains/uast/UElement;", "", "applicableAnnotations", "applicableSuperClasses", "checkAnnotations", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "argument", "type", "Lcom/android/tools/lint/detector/api/AnnotationUsageType;", "method", "Lcom/intellij/psi/PsiMethod;", "referenced", "Lcom/intellij/psi/PsiElement;", "annotations", "Lorg/jetbrains/uast/UAnnotation;", "annotated", "checkExperimentalUsage", "annotationInfo", "Lcom/android/tools/lint/detector/api/AnnotationInfo;", "usageInfo", "Lcom/android/tools/lint/detector/api/AnnotationUsageInfo;", "optInFqNames", "checkMethodOverride", "usage", "superMethod", "createAnnotateFix", "Lcom/android/tools/lint/detector/api/LintFix;", "element", "Lorg/jetbrains/uast/UDeclaration;", "annotation", "createLintFix", "doCheckMethodOverride", "methodAnnotations", "classAnnotations", "pkgAnnotations", "containingClass", "Lcom/intellij/psi/PsiClass;", "filterRelevantAnnotations", "evaluator", "Lcom/android/tools/lint/client/api/JavaEvaluator;", "getClassAndPkgAnnotations", "Lkotlin/Pair;", "isApplicableAnnotationUsage", "", "report", "message", "level", "visitAnnotationUsage", "visitClass", "declaration", "Lorg/jetbrains/uast/UClass;", "lambda", "Lorg/jetbrains/uast/ULambdaExpression;", "asIterable", "", "isExperimentalityAccepted", "annotationFqName", "isExperimentalityRequired", "Companion", "annotation-experimental-lint"})
@SourceDebugExtension(value={"SMAP\nExperimentalDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExperimentalDetector.kt\nandroidx/annotation/experimental/lint/ExperimentalDetector\n+ 2 UastContext.kt\norg/jetbrains/uast/UastContextKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 6 ExperimentalDetector.kt\nandroidx/annotation/experimental/lint/ExperimentalDetectorKt\n+ 7 ExperimentalDetector.kt\nandroidx/annotation/experimental/lint/ExperimentalDetectorKt$anyParentMatches$1\n+ 8 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,931:1\n171#2:932\n1282#3,2:933\n13309#3:936\n13309#3,2:937\n13310#3:939\n1#4:935\n372#5,7:940\n853#6,9:947\n862#6:957\n855#7:956\n288#8,2:958\n*S KotlinDebug\n*F\n+ 1 ExperimentalDetector.kt\nandroidx/annotation/experimental/lint/ExperimentalDetector\n*L\n109#1:932\n111#1:933,2\n119#1:936\n122#1:937,2\n119#1:939\n495#1:940,7\n612#1:947,9\n612#1:957\n612#1:956\n670#1:958,2\n*E\n"})
public final class ExperimentalDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<UElement, Set<String>> visitedUsages = new LinkedHashMap();
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(ExperimentalDetector.class, Scope.JAVA_FILE_SCOPE);
    @NotNull
    public static final String KOTLIN_EXPERIMENTAL_ANNOTATION = "kotlin.Experimental";
    @NotNull
    public static final String KOTLIN_USE_EXPERIMENTAL_ANNOTATION = "kotlin.UseExperimental";
    @NotNull
    public static final String KOTLIN_OPT_IN_ANNOTATION = "kotlin.OptIn";
    @NotNull
    public static final String KOTLIN_REQUIRES_OPT_IN_ANNOTATION = "kotlin.RequiresOptIn";
    @NotNull
    public static final String JAVA_EXPERIMENTAL_ANNOTATION = "androidx.annotation.experimental.Experimental";
    @NotNull
    public static final String JAVA_USE_EXPERIMENTAL_ANNOTATION = "androidx.annotation.experimental.UseExperimental";
    @NotNull
    public static final String JAVA_REQUIRES_OPT_IN_ANNOTATION = "androidx.annotation.RequiresOptIn";
    @NotNull
    public static final String JAVA_OPT_IN_ANNOTATION = "androidx.annotation.OptIn";
    @NotNull
    public static final String ENUM_ERROR = "ERROR";
    @NotNull
    public static final String ENUM_WARNING = "WARNING";
    @NotNull
    private static final Issue ISSUE_ERROR = androidx.annotation.experimental.lint.ExperimentalDetector$Companion.access$issueForLevel(Companion, "ERROR", Severity.ERROR);
    @NotNull
    private static final Issue ISSUE_WARNING = androidx.annotation.experimental.lint.ExperimentalDetector$Companion.access$issueForLevel(Companion, "WARNING", Severity.WARNING);
    @NotNull
    private static final List<Issue> ISSUES;

    @NotNull
    public List<String> applicableAnnotations() {
        Object[] objectArray = new String[]{JAVA_EXPERIMENTAL_ANNOTATION, KOTLIN_EXPERIMENTAL_ANNOTATION, JAVA_REQUIRES_OPT_IN_ANNOTATION, KOTLIN_REQUIRES_OPT_IN_ANNOTATION};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public List<String> applicableSuperClasses() {
        return CollectionsKt.listOf((Object)"java.lang.Object");
    }

    public boolean isApplicableAnnotationUsage(@NotNull AnnotationUsageType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return WhenMappings.$EnumSwitchMapping$0[type.ordinal()] == 1 ? true : super.isApplicableAnnotationUsage(type);
    }

    /*
     * WARNING - void declaration
     */
    public void visitClass(@NotNull JavaContext context, @NotNull ULambdaExpression lambda) {
        block4: {
            void $this$toUElementOfType$iv;
            PsiClass superClass;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)lambda, (String)"lambda");
            UMethod[] uMethodArray = lambda.getFunctionalInterfaceType();
            PsiClassReferenceType psiClassReferenceType = uMethodArray instanceof PsiClassReferenceType ? (PsiClassReferenceType)uMethodArray : null;
            Object object = superClass = psiClassReferenceType != null ? psiClassReferenceType.resolve() : null;
            if (superClass == null) break block4;
            uMethodArray = (PsiElement)superClass;
            boolean $i$f$toUElementOfType = false;
            UClass uClass = (UClass)UastContextKt.toUElement((PsiElement)$this$toUElementOfType$iv, UClass.class);
            if (uClass != null && (uMethodArray = uClass.getMethods()) != null) {
                Object var6_6;
                block3: {
                    Object v2;
                    void $this$firstOrNull$iv;
                    UMethod[] uMethodArray2 = uMethodArray;
                    boolean $i$f$firstOrNull = false;
                    int n = ((void)$this$firstOrNull$iv).length;
                    for (int i = 0; i < n; ++i) {
                        void element$iv;
                        void method = element$iv = $this$firstOrNull$iv[i];
                        boolean bl = false;
                        if (!ExperimentalDetectorKt.access$isAbstract((PsiModifierListOwner)method)) continue;
                        v2 = element$iv;
                        break block3;
                    }
                    v2 = var6_6 = null;
                }
                if (var6_6 != null) {
                    Object superMethod = var6_6;
                    boolean bl = false;
                    this.checkMethodOverride(context, (UElement)lambda, superMethod);
                }
            }
        }
    }

    public void visitClass(@NotNull JavaContext context, @NotNull UClass declaration) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        UMethod[] $this$forEach$iv = declaration.getMethods();
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            UMethod element$iv;
            UMethod method = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            JavaEvaluator eval = context.getEvaluator();
            if (!eval.isOverride(method, true)) continue;
            PsiMethod[] psiMethodArray = method.findSuperMethods();
            Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray, (String)"method.findSuperMethods()");
            Object[] $this$forEach$iv2 = psiMethodArray;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                PsiMethod superMethod = (PsiMethod)element$iv2;
                boolean bl2 = false;
                UElement uElement = (UElement)method;
                Intrinsics.checkNotNullExpressionValue((Object)superMethod, (String)"superMethod");
                this.checkMethodOverride(context, uElement, superMethod);
            }
        }
    }

    private final void checkMethodOverride(JavaContext context, UElement usage, PsiMethod superMethod) {
        JavaEvaluator evaluator = context.getEvaluator();
        List allAnnotations = JavaEvaluator.getAnnotations$default((JavaEvaluator)evaluator, (PsiModifierListOwner)((PsiModifierListOwner)superMethod), (boolean)true, null, (int)4, null);
        List<UAnnotation> methodAnnotations = this.filterRelevantAnnotations(evaluator, allAnnotations);
        PsiClass containingClass = superMethod.getContainingClass();
        Pair<List<UAnnotation>, List<UAnnotation>> pair = this.getClassAndPkgAnnotations(containingClass, evaluator);
        List classAnnotations = (List)pair.component1();
        List pkgAnnotations = (List)pair.component2();
        this.doCheckMethodOverride(context, superMethod, methodAnnotations, classAnnotations, pkgAnnotations, usage, containingClass);
    }

    private final void doCheckMethodOverride(JavaContext context, PsiMethod superMethod, List<? extends UAnnotation> methodAnnotations, List<? extends UAnnotation> classAnnotations, List<? extends UAnnotation> pkgAnnotations, UElement usage, PsiClass containingClass) {
        if (!((Collection)methodAnnotations).isEmpty()) {
            this.checkAnnotations(context, usage, AnnotationUsageType.METHOD_CALL, superMethod, (PsiElement)superMethod, methodAnnotations, (PsiElement)superMethod);
        }
        if (containingClass != null && !((Collection)classAnnotations).isEmpty()) {
            this.checkAnnotations(context, usage, AnnotationUsageType.METHOD_CALL_CLASS, superMethod, (PsiElement)superMethod, classAnnotations, (PsiElement)containingClass);
        }
        if (!((Collection)pkgAnnotations).isEmpty()) {
            this.checkAnnotations(context, usage, AnnotationUsageType.METHOD_CALL_PACKAGE, superMethod, (PsiElement)superMethod, pkgAnnotations, null);
        }
    }

    private final void checkAnnotations(JavaContext context, UElement argument, AnnotationUsageType type, PsiMethod method, PsiElement referenced, List<? extends UAnnotation> annotations, PsiElement annotated) {
        for (UAnnotation uAnnotation : annotations) {
            String signature;
            if (uAnnotation.getQualifiedName() == null) continue;
            List uAnnotations = null;
            if (!this.isApplicableAnnotationUsage(type)) continue;
            if (annotated != null && !this.inheritAnnotation(signature)) {
                PsiModifierListOwner owner;
                PsiElement psiElement = uAnnotation.getSourcePsi();
                PsiAnnotation psiAnnotation = psiElement instanceof PsiAnnotation ? (PsiAnnotation)psiElement : null;
                PsiAnnotationOwner annotationOwner = psiAnnotation != null ? psiAnnotation.getOwner() : null;
                PsiModifierListOwner psiModifierListOwner = owner = annotationOwner instanceof PsiElement ? (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)annotationOwner), PsiModifierListOwner.class) : null;
                if (owner != null) {
                    UElement annotatedPsi;
                    UElement uElement = annotated instanceof UElement ? (UElement)annotated : null;
                    if (uElement == null || (uElement = uElement.getSourcePsi()) == null) {
                        uElement = annotated;
                    }
                    if (!Intrinsics.areEqual((Object)owner, (Object)(annotatedPsi = uElement))) {
                        continue;
                    }
                } else {
                    String qualifiedName;
                    List list;
                    boolean bl;
                    if (annotated instanceof UAnnotated) {
                        boolean found = false;
                        ExperimentalDetector $this$checkAnnotations_u24lambda_u244 = this;
                        bl = false;
                        uAnnotations = list = context.getEvaluator().getAllAnnotations((UAnnotated)annotated, false);
                        for (UAnnotation uAnnotation2 : list) {
                            qualifiedName = uAnnotation2.getQualifiedName();
                            if (!Intrinsics.areEqual((Object)qualifiedName, (Object)signature)) continue;
                            found = true;
                            break;
                        }
                        if (!found) continue;
                    }
                    if (annotated instanceof PsiModifierListOwner) {
                        boolean found = false;
                        List list2 = uAnnotations;
                        if (list2 == null) {
                            ExperimentalDetector $this$checkAnnotations_u24lambda_u245 = this;
                            bl = false;
                            uAnnotations = list = JavaEvaluator.getAnnotations$default((JavaEvaluator)context.getEvaluator(), (PsiModifierListOwner)((PsiModifierListOwner)annotated), (boolean)false, null, (int)4, null);
                            list2 = list;
                        }
                        for (UAnnotation uAnnotation2 : list2) {
                            qualifiedName = uAnnotation2.getQualifiedName();
                            if (!Intrinsics.areEqual((Object)qualifiedName, (Object)signature)) continue;
                            found = true;
                            break;
                        }
                        if (!found) continue;
                    }
                }
            }
            AnnotationInfo annotationInfo = new AnnotationInfo(uAnnotation, signature, (PsiElement)method, AnnotationOrigin.METHOD);
            AnnotationUsageInfo usageInfo = new AnnotationUsageInfo(0, CollectionsKt.listOf((Object)annotationInfo), argument, referenced, type);
            this.visitAnnotationUsage(context, argument, annotationInfo, usageInfo);
        }
    }

    private final Pair<List<UAnnotation>, List<UAnnotation>> getClassAndPkgAnnotations(PsiClass containingClass, JavaEvaluator evaluator) {
        List<UAnnotation> classAnnotations = null;
        List pkgAnnotations = null;
        if (containingClass != null) {
            List<UAnnotation> list;
            List annotations = JavaEvaluator.getAnnotations$default((JavaEvaluator)evaluator, (PsiModifierListOwner)((PsiModifierListOwner)containingClass), (boolean)true, null, (int)4, null);
            classAnnotations = this.filterRelevantAnnotations(evaluator, annotations);
            PsiPackage pkg = evaluator.getPackage((PsiElement)containingClass);
            if (pkg != null) {
                List annotations2 = JavaEvaluator.getAnnotations$default((JavaEvaluator)evaluator, (PsiModifierListOwner)((PsiModifierListOwner)pkg), (boolean)false, null, (int)4, null);
                list = this.filterRelevantAnnotations(evaluator, annotations2);
            } else {
                list = CollectionsKt.emptyList();
            }
            pkgAnnotations = list;
        } else {
            classAnnotations = CollectionsKt.emptyList();
            pkgAnnotations = CollectionsKt.emptyList();
        }
        return new Pair((Object)classAnnotations, (Object)pkgAnnotations);
    }

    private final List<UAnnotation> filterRelevantAnnotations(JavaEvaluator evaluator, List<? extends UAnnotation> annotations) {
        List result = null;
        int length = annotations.size();
        if (length == 0) {
            return CollectionsKt.emptyList();
        }
        for (UAnnotation uAnnotation : annotations) {
            String signature = uAnnotation.getQualifiedName();
            if (signature == null || (StringsKt.startsWith$default((String)signature, (String)"kotlin.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)signature, (String)"java.", (boolean)false, (int)2, null)) && !this.getRelevantAnnotations().contains(signature)) continue;
            if (this.getRelevantAnnotations().contains(signature)) {
                if (length == 1) {
                    return CollectionsKt.listOf((Object)uAnnotation);
                }
                if (result == null) {
                    result = new ArrayList(2);
                }
                result.add(uAnnotation);
                continue;
            }
            PsiClass cls = uAnnotation.resolve();
            if (cls == null || !cls.isAnnotationType()) continue;
            List innerAnnotations = JavaEvaluator.getAnnotations$default((JavaEvaluator)evaluator, (PsiModifierListOwner)((PsiModifierListOwner)cls), (boolean)false, null, (int)4, null);
            int n = ((Collection)innerAnnotations).size();
            for (int j = 0; j < n; ++j) {
                UAnnotation inner = (UAnnotation)innerAnnotations.get(j);
                String a = inner.getQualifiedName();
                if (a == null || !this.getRelevantAnnotations().contains(a)) continue;
                if (result == null) {
                    result = new ArrayList(2);
                }
                result.add(inner);
            }
        }
        List list = result;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private final List<String> getRelevantAnnotations() {
        return this.applicableAnnotations();
    }

    public void visitAnnotationUsage(@NotNull JavaContext context, @NotNull UElement element, @NotNull AnnotationInfo annotationInfo, @NotNull AnnotationUsageInfo usageInfo) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)annotationInfo, (String)"annotationInfo");
        Intrinsics.checkNotNullParameter((Object)usageInfo, (String)"usageInfo");
        PsiElement referenced = usageInfo.getReferenced();
        AnnotationUsageType type = usageInfo.getType();
        if (referenced instanceof PsiField && type == AnnotationUsageType.ASSIGNMENT_RHS || referenced instanceof PsiMethod && type == AnnotationUsageType.ASSIGNMENT_RHS || referenced instanceof PsiMethod && type == AnnotationUsageType.FIELD_REFERENCE || referenced instanceof PsiMethod && type == AnnotationUsageType.METHOD_CALL_PARAMETER) {
            return;
        }
        switch (annotationInfo.getQualifiedName()) {
            case "androidx.annotation.experimental.Experimental": 
            case "androidx.annotation.RequiresOptIn": {
                Object[] objectArray = new String[]{JAVA_USE_EXPERIMENTAL_ANNOTATION, JAVA_OPT_IN_ANNOTATION};
                this.checkExperimentalUsage(context, annotationInfo, usageInfo, CollectionsKt.listOf((Object[])objectArray));
                break;
            }
            case "kotlin.RequiresOptIn": 
            case "kotlin.Experimental": {
                if (Lint.isKotlin((Language)usageInfo.getUsage().getLang())) break;
                Object[] objectArray = new String[]{KOTLIN_USE_EXPERIMENTAL_ANNOTATION, KOTLIN_OPT_IN_ANNOTATION, JAVA_USE_EXPERIMENTAL_ANNOTATION, JAVA_OPT_IN_ANNOTATION};
                this.checkExperimentalUsage(context, annotationInfo, usageInfo, CollectionsKt.listOf((Object[])objectArray));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkExperimentalUsage(JavaContext context, AnnotationInfo annotationInfo, AnnotationUsageInfo usageInfo, List<String> optInFqNames) {
        Set visitedAnnotations;
        Object object;
        void $this$getOrPut$iv;
        UAnnotation annotation = annotationInfo.getAnnotation();
        Object object2 = annotation.getUastParent();
        Object object3 = object2 instanceof UClass ? (UClass)object2 : null;
        if (object3 == null || (object3 = object3.getQualifiedName()) == null) {
            return;
        }
        Object annotationFqName = object3;
        object2 = this.visitedUsages;
        UElement key$iv = usageInfo.getUsage();
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            Set answer$iv = new LinkedHashSet();
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        if (!(visitedAnnotations = (Set)object).add(annotationFqName)) {
            return;
        }
        PsiElement referenced = usageInfo.getReferenced();
        UElement usage = usageInfo.getUsage();
        UElement uElement = referenced instanceof UElement ? (UElement)referenced : null;
        if (uElement == null && (uElement = UastContextKt.toUElement((PsiElement)referenced)) == null && (uElement = ExperimentalDetectorKt.access$getReferencedElement(usage)) == null) {
            return;
        }
        UElement decl = uElement;
        if (!this.isExperimentalityRequired(decl, context, (String)annotationFqName, usageInfo.getType())) {
            return;
        }
        if (this.isExperimentalityAccepted(usage, context, (String)annotationFqName, optInFqNames)) {
            return;
        }
        String level = AnnotationRetentionDetectorKt.extractAttribute(annotation, context, "level", ENUM_ERROR);
        String missingLevelErrorPrefix = "Failed to read `level` from `@" + (String)annotationFqName + "` -- assuming `ERROR`. ";
        String defaultMessage = "This declaration is opt-in and its usage should be marked with `@" + (String)annotationFqName + "` or `@OptIn(markerClass = " + (String)annotationFqName + ".class)`";
        Object message = AnnotationRetentionDetectorKt.extractAttribute(annotation, context, "message", defaultMessage);
        CharSequence charSequence = (CharSequence)message;
        if (charSequence == null || charSequence.length() == 0) {
            message = defaultMessage;
        }
        Object object4 = level == null ? missingLevelErrorPrefix + (String)message : message;
        String string = level;
        if (string == null) {
            string = ENUM_ERROR;
        }
        this.report(context, usage, (String)annotationFqName, (String)object4, string);
    }

    private final boolean isExperimentalityRequired(UElement $this$isExperimentalityRequired, JavaContext context, String annotationFqName, AnnotationUsageType type) {
        JavaEvaluator evaluator;
        JavaEvaluator javaEvaluator;
        JavaEvaluator it = javaEvaluator = context.getEvaluator();
        boolean bl = false;
        Object object = evaluator = type == AnnotationUsageType.DEFINITION ? javaEvaluator : null;
        if (ExperimentalDetectorKt.access$isDeclarationAnnotatedWith($this$isExperimentalityRequired, annotationFqName, evaluator)) {
            return true;
        }
        UElement uElement = $this$isExperimentalityRequired.getUastParent();
        UClass uClass = uElement instanceof UClass ? (UClass)uElement : null;
        boolean bl2 = uClass != null ? this.isExperimentalityRequired((UElement)uClass, context, annotationFqName, type) : false;
        if (bl2) {
            return true;
        }
        PsiPackage psiPackage = context.getEvaluator().getPackage($this$isExperimentalityRequired);
        if ((psiPackage != null ? psiPackage.getAnnotation(annotationFqName) : null) != null) {
            return true;
        }
        if ($this$isExperimentalityRequired.getSourcePsi() instanceof KtProperty && $this$isExperimentalityRequired instanceof UMethod) {
            UField backingField;
            UField uField;
            block8: {
                UElement uElement2 = $this$isExperimentalityRequired.getUastParent();
                UField[] uFieldArray = uElement2 instanceof UClass ? (UField[])uElement2 : null;
                if (uFieldArray != null && (uFieldArray = uFieldArray.getFields()) != null) {
                    UField[] uFieldArray2 = uFieldArray;
                    int n = uFieldArray2.length;
                    for (int i = 0; i < n; ++i) {
                        UField uField2;
                        UField it2 = uField2 = uFieldArray2[i];
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)it2.getSourcePsi(), (Object)$this$isExperimentalityRequired.getSourcePsi())) continue;
                        uField = uField2;
                        break block8;
                    }
                    uField = null;
                } else {
                    uField = null;
                }
            }
            UField uField3 = backingField = uField;
            boolean bl4 = uField3 != null ? ExperimentalDetectorKt.access$isDeclarationAnnotatedWith((UElement)uField3, annotationFqName, context.getEvaluator()) : false;
            if (bl4) {
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isExperimentalityAccepted(UElement $this$isExperimentalityAccepted, JavaContext context, String annotationFqName, List<String> optInFqNames) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        Configuration config = context.getConfiguration();
        String string = Configuration.getOption$default((Configuration)config, (Issue)ISSUE_ERROR, (String)"opt-in", null, (int)4, null);
        if (string != null) {
            if (StringsKt.contains$default((CharSequence)string, (CharSequence)annotationFqName, (boolean)false, (int)2, null)) {
                return true;
            }
            bl3 = false;
        } else {
            bl3 = false;
        }
        if (bl3) return true;
        String string2 = Configuration.getOption$default((Configuration)config, (Issue)ISSUE_WARNING, (String)"opt-in", null, (int)4, null);
        if (string2 != null) {
            if (StringsKt.contains$default((CharSequence)string2, (CharSequence)annotationFqName, (boolean)false, (int)2, null)) {
                return true;
            }
            bl2 = false;
        } else {
            bl2 = false;
        }
        if (bl2) return true;
        UElement $this$anyParentMatches_u24default$iv = $this$isExperimentalityAccepted;
        boolean defaultValue$iv = false;
        boolean $i$f$anyParentMatches = false;
        UElement element$iv = $this$anyParentMatches_u24default$iv;
        while (true) {
            UElement element = element$iv;
            boolean bl4 = false;
            if (ExperimentalDetectorKt.isDeclarationAnnotatedWith$default(element, annotationFqName, null, 2, null)) return true;
            if (ExperimentalDetectorKt.access$isDeclarationAnnotatedWithOptInOf(element, annotationFqName, optInFqNames)) {
                return true;
            }
            boolean bl5 = false;
            if (bl5) {
                return true;
            }
            element = element$iv;
            boolean bl6 = false;
            UElement it = element;
            if (false) {
                bl = false;
                break;
            }
            if (element$iv.getUastParent() != null) continue;
            bl = defaultValue$iv;
            break;
        }
        if (bl) return true;
        PsiPackage psiPackage = context.getEvaluator().getPackage($this$isExperimentalityAccepted);
        if (psiPackage == null) return false;
        PsiPackage element = psiPackage;
        boolean bl7 = false;
        if (ExperimentalDetectorKt.access$isAnnotatedWith(element, annotationFqName)) return true;
        if (!ExperimentalDetectorKt.access$isAnnotatedWithOptInOf(element, annotationFqName, optInFqNames)) return false;
        return true;
    }

    private final LintFix createLintFix(JavaContext context, UElement usage, String annotation) {
        LintFix.GroupBuilder lintFixes;
        block2: {
            String propagateAnnotation = "@" + annotation;
            lintFixes = this.fix().alternatives();
            boolean addedFix = false;
            UMethod uMethod = UastUtils.getContainingUMethod((UElement)usage);
            if (uMethod != null) {
                UMethod containingMethod = uMethod;
                boolean bl = false;
                boolean isKotlin = Lint.isKotlin((Language)usage.getLang());
                String optInAnnotation = isKotlin ? "@androidx.annotation.OptIn(" + annotation + "::class)" : "@androidx.annotation.OptIn(markerClass = " + annotation + ".class)";
                lintFixes.add(this.createAnnotateFix(context, (UDeclaration)containingMethod, optInAnnotation));
                lintFixes.add(this.createAnnotateFix(context, (UDeclaration)containingMethod, propagateAnnotation));
                addedFix = true;
            }
            if (addedFix) break block2;
            UClass uClass = UastUtils.getContainingUClass((UElement)usage);
            if (uClass != null) {
                UClass containingClass = uClass;
                boolean bl = false;
                lintFixes.add(this.createAnnotateFix(context, (UDeclaration)containingClass, propagateAnnotation));
            }
        }
        return lintFixes.build();
    }

    private final LintFix createAnnotateFix(JavaContext context, UDeclaration element, String annotation) {
        PsiElement psiElement;
        Object object;
        UDeclaration uDeclaration = element;
        if (uDeclaration instanceof UMethod) {
            object = "'" + ((UMethod)element).getName() + "'";
        } else if (uDeclaration instanceof UAnonymousClass) {
            object = "containing anonymous class";
        } else if (uDeclaration instanceof UClass) {
            object = "containing class '" + ((UClass)element).getName() + "'";
        } else {
            throw new IllegalArgumentException("Unsupported element type");
        }
        Object elementLabel = object;
        PsiElement elementSourcePsi = element.getSourcePsi();
        if (elementSourcePsi instanceof PsiModifierListOwner) {
            PsiElement psiElement2;
            block10: {
                Iterable<PsiElement> $this$firstOrNull$iv = this.asIterable(elementSourcePsi);
                boolean $i$f$firstOrNull = false;
                Iterator<PsiElement> iterator2 = $this$firstOrNull$iv.iterator();
                while (iterator2.hasNext()) {
                    PsiElement element$iv;
                    PsiElement child = element$iv = iterator2.next();
                    boolean bl = false;
                    if (!(!(child instanceof PsiWhiteSpace) && !(child instanceof PsiComment))) continue;
                    psiElement2 = element$iv;
                    break block10;
                }
                psiElement2 = null;
            }
            if ((psiElement = (PsiElement)psiElement2) == null) {
                throw new IllegalArgumentException("Failed to locate element declaration");
            }
        } else {
            psiElement = (PsiElement)element;
        }
        PsiElement elementForInsert = psiElement;
        return this.fix().name("Add '" + annotation + "' annotation to " + (String)elementLabel).annotate(annotation, (Context)context, (PsiElement)element, true).range(context.getLocation(elementForInsert)).build();
    }

    private final Iterable<PsiElement> asIterable(PsiElement $this$asIterable) {
        return new Iterable<PsiElement>($this$asIterable){
            final /* synthetic */ PsiElement $this_asIterable;
            {
                this.$this_asIterable = $receiver;
            }

            public Iterator<PsiElement> iterator() {
                return new Iterator<PsiElement>(this.$this_asIterable){
                    private PsiElement current;
                    {
                        this.current = $receiver.getFirstChild();
                    }

                    public boolean hasNext() {
                        return this.current != null;
                    }

                    public PsiElement next() {
                        PsiElement psiElement;
                        PsiElement $this$next_u24lambda_u240 = psiElement = this.current;
                        boolean bl = false;
                        this.current = $this$next_u24lambda_u240.getNextSibling();
                        PsiElement psiElement2 = psiElement;
                        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"current.apply { current = nextSibling }");
                        return psiElement2;
                    }

                    public void remove() {
                        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
                    }
                };
            }
        };
    }

    private final void report(JavaContext context, UElement usage, String annotation, String message, String level) {
        block7: {
            Issue issue;
            String string = level;
            if (Intrinsics.areEqual((Object)string, (Object)ENUM_ERROR)) {
                issue = ISSUE_ERROR;
            } else if (Intrinsics.areEqual((Object)string, (Object)ENUM_WARNING)) {
                issue = ISSUE_WARNING;
            } else {
                throw new IllegalArgumentException("Level was \"" + level + "\" but must be one of: ERROR, WARNING");
            }
            Issue issue2 = issue;
            try {
                String string2 = Configuration.getOption$default((Configuration)context.getConfiguration(), (Issue)issue2, (String)"opt-in", null, (int)4, null);
                if (!(string2 != null ? StringsKt.contains$default((CharSequence)string2, (CharSequence)annotation, (boolean)false, (int)2, null) : false)) {
                    context.report(issue2, usage, context.getNameLocation(usage), StringsKt.trimIndent((String)message), this.createLintFix(context, usage, annotation));
                }
            }
            catch (UnsupportedOperationException e) {
                if (Intrinsics.areEqual((Object)"Method not implemented", (Object)e.getMessage())) break block7;
                throw e;
            }
        }
    }

    static {
        Object[] objectArray = new Issue[]{ISSUE_ERROR, ISSUE_WARNING};
        ISSUES = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u000e\u0010\u0012\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Landroidx/annotation/experimental/lint/ExperimentalDetector$Companion;", "", "()V", "ENUM_ERROR", "", "ENUM_WARNING", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "ISSUES", "", "Lcom/android/tools/lint/detector/api/Issue;", "getISSUES", "()Ljava/util/List;", "ISSUE_ERROR", "getISSUE_ERROR", "()Lcom/android/tools/lint/detector/api/Issue;", "ISSUE_WARNING", "getISSUE_WARNING", "JAVA_EXPERIMENTAL_ANNOTATION", "JAVA_OPT_IN_ANNOTATION", "JAVA_REQUIRES_OPT_IN_ANNOTATION", "JAVA_USE_EXPERIMENTAL_ANNOTATION", "KOTLIN_EXPERIMENTAL_ANNOTATION", "KOTLIN_OPT_IN_ANNOTATION", "KOTLIN_REQUIRES_OPT_IN_ANNOTATION", "KOTLIN_USE_EXPERIMENTAL_ANNOTATION", "issueForLevel", "levelEnum", "severity", "Lcom/android/tools/lint/detector/api/Severity;", "annotation-experimental-lint"})
    public static final class Companion {
        private Companion() {
        }

        private final Issue issueForLevel(String levelEnum, Severity severity) {
            String levelText = CapitalizeDecapitalizeKt.toLowerCaseAsciiOnly((String)levelEnum);
            String issueId = "UnsafeOptInUsage" + CapitalizeDecapitalizeKt.capitalizeAsciiOnly((String)levelText);
            return Issue.Companion.create(issueId, "Unsafe opt-in usage intended to be " + levelText + "-level severity", "\n                This API has been flagged as opt-in with " + levelText + "-level severity.\n\n                Any declaration annotated with this marker is considered part of an unstable or\n                otherwise non-standard API surface and its call sites should accept the opt-in\n                aspect of it by using the `@OptIn` annotation, using the marker annotation --\n                effectively causing further propagation of the opt-in aspect -- or configuring\n                the `" + issueId + "` check's options for project-wide opt-in.\n\n                To configure project-wide opt-in, specify the `opt-in` option value in `lint.xml`\n                as a comma-delimited list of opted-in annotations:\n\n                ```\n                <lint>\n                    <issue id=\"" + issueId + "\">\n                        <option name=\"opt-in\" value=\"com.foo.ExperimentalBarAnnotation\" />\n                    </issue>\n                </lint>\n                ```\n                ", Category.CORRECTNESS, 4, severity, IMPLEMENTATION);
        }

        @NotNull
        public final Issue getISSUE_ERROR() {
            return ISSUE_ERROR;
        }

        @NotNull
        public final Issue getISSUE_WARNING() {
            return ISSUE_WARNING;
        }

        @NotNull
        public final List<Issue> getISSUES() {
            return ISSUES;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        public static final /* synthetic */ Issue access$issueForLevel(Companion $this, String levelEnum, Severity severity) {
            return $this.issueForLevel(levelEnum, severity);
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AnnotationUsageType.values().length];
            try {
                nArray[AnnotationUsageType.DEFINITION.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

