/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal;

import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.util.Range;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.experimental.UseExperimental;
import androidx.camera.camera2.impl.Camera2ImplConfig;
import androidx.camera.camera2.internal.Camera2CameraControlImpl;
import androidx.camera.camera2.internal.ExposureStateImpl;
import androidx.camera.camera2.internal.compat.CameraCharacteristicsCompat;
import androidx.camera.core.CameraControl;
import androidx.camera.core.ExperimentalExposureCompensation;
import androidx.camera.core.ExposureState;
import androidx.camera.core.impl.utils.futures.Futures;
import androidx.concurrent.futures.CallbackToFutureAdapter;
import androidx.core.util.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.Executor;

@UseExperimental(markerClass=ExperimentalExposureCompensation.class)
public class ExposureControl {
    private static final int DEFAULT_EXPOSURE_COMPENSATION = 0;
    @NonNull
    private final Camera2CameraControlImpl mCameraControl;
    @NonNull
    private final ExposureStateImpl mExposureStateImpl;
    @NonNull
    private final Executor mExecutor;
    private boolean mIsActive = false;
    @Nullable
    private CallbackToFutureAdapter.Completer<Integer> mRunningCompleter;
    @Nullable
    private Camera2CameraControlImpl.CaptureResultListener mRunningCaptureResultListener;

    ExposureControl(@NonNull Camera2CameraControlImpl cameraControl, @NonNull CameraCharacteristicsCompat cameraCharacteristics, @NonNull Executor executor) {
        this.mCameraControl = cameraControl;
        this.mExposureStateImpl = new ExposureStateImpl(cameraCharacteristics, 0);
        this.mExecutor = executor;
    }

    static ExposureState getDefaultExposureState(CameraCharacteristicsCompat cameraCharacteristics) {
        return new ExposureStateImpl(cameraCharacteristics, 0);
    }

    void setActive(boolean isActive) {
        if (isActive == this.mIsActive) {
            return;
        }
        this.mIsActive = isActive;
        if (!this.mIsActive) {
            this.mExposureStateImpl.setExposureCompensationIndex(0);
            this.clearRunningTask();
        }
    }

    void setCaptureRequestOption(@NonNull Camera2ImplConfig.Builder configBuilder) {
        configBuilder.setCaptureRequestOption(CaptureRequest.CONTROL_AE_EXPOSURE_COMPENSATION, this.mExposureStateImpl.getExposureCompensationIndex());
    }

    @NonNull
    ExposureState getExposureState() {
        return this.mExposureStateImpl;
    }

    @NonNull
    ListenableFuture<Integer> setExposureCompensationIndex(int exposure) {
        if (!this.mExposureStateImpl.isExposureCompensationSupported()) {
            return Futures.immediateFailedFuture((Throwable)new IllegalArgumentException("ExposureCompensation is not supported"));
        }
        Range<Integer> range = this.mExposureStateImpl.getExposureCompensationRange();
        if (!range.contains((Comparable)Integer.valueOf(exposure))) {
            return Futures.immediateFailedFuture((Throwable)new IllegalArgumentException("Requested ExposureCompensation " + exposure + " is not within valid range [" + range.getUpper() + ".." + range.getLower() + "]"));
        }
        this.mExposureStateImpl.setExposureCompensationIndex(exposure);
        return Futures.nonCancellationPropagating((ListenableFuture)CallbackToFutureAdapter.getFuture(completer -> {
            this.mExecutor.execute(() -> {
                if (!this.mIsActive) {
                    this.mExposureStateImpl.setExposureCompensationIndex(0);
                    completer.setException((Throwable)new CameraControl.OperationCanceledException("Camera is not active."));
                    return;
                }
                this.clearRunningTask();
                Preconditions.checkState((this.mRunningCompleter == null ? 1 : 0) != 0, (String)"mRunningCompleter should be null when starting set a new exposure compensation value");
                Preconditions.checkState((this.mRunningCaptureResultListener == null ? 1 : 0) != 0, (String)"mRunningCaptureResultListener should be null when starting set a new exposure compensation value");
                this.mRunningCaptureResultListener = captureResult -> {
                    block6: {
                        Integer evResult;
                        block5: {
                            Integer state = (Integer)captureResult.get(CaptureResult.CONTROL_AE_STATE);
                            evResult = (Integer)captureResult.get(CaptureResult.CONTROL_AE_EXPOSURE_COMPENSATION);
                            if (state == null || evResult == null) break block5;
                            switch (state) {
                                case 2: 
                                case 3: 
                                case 4: {
                                    if (evResult == exposure) {
                                        completer.set((Object)exposure);
                                        return true;
                                    } else {
                                        break;
                                    }
                                }
                            }
                            break block6;
                        }
                        if (evResult != null && evResult == exposure) {
                            completer.set((Object)exposure);
                            return true;
                        }
                    }
                    return false;
                };
                this.mRunningCompleter = completer;
                this.mCameraControl.addCaptureResultListener(this.mRunningCaptureResultListener);
                this.mCameraControl.updateSessionConfigSynchronous();
            });
            return "setExposureCompensationIndex[" + exposure + "]";
        }));
    }

    private void clearRunningTask() {
        if (this.mRunningCompleter != null) {
            this.mRunningCompleter.setException((Throwable)new CameraControl.OperationCanceledException("Cancelled by another setExposureCompensationIndex()"));
            this.mRunningCompleter = null;
        }
        if (this.mRunningCaptureResultListener != null) {
            this.mCameraControl.removeCaptureResultListener(this.mRunningCaptureResultListener);
            this.mRunningCaptureResultListener = null;
        }
    }
}

