/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal;

import android.hardware.camera2.CameraDevice;
import android.os.Build;
import android.os.Handler;
import android.view.Surface;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.camera.camera2.internal.CaptureSessionRepository;
import androidx.camera.camera2.internal.SynchronizedCaptureSession;
import androidx.camera.camera2.internal.SynchronizedCaptureSessionBaseImpl;
import androidx.camera.camera2.internal.SynchronizedCaptureSessionImpl;
import androidx.camera.camera2.internal.compat.params.OutputConfigurationCompat;
import androidx.camera.camera2.internal.compat.params.SessionConfigurationCompat;
import androidx.camera.core.impl.DeferrableSurface;
import com.google.common.util.concurrent.ListenableFuture;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;

final class SynchronizedCaptureSessionOpener {
    static final String FEATURE_FORCE_CLOSE = "force_close";
    static final String FEATURE_DEFERRABLE_SURFACE_CLOSE = "deferrableSurface_close";
    static final String FEATURE_WAIT_FOR_REQUEST = "wait_for_request";
    @NonNull
    private final OpenerImpl mImpl;

    SynchronizedCaptureSessionOpener(@NonNull OpenerImpl impl) {
        this.mImpl = impl;
    }

    @NonNull
    ListenableFuture<Void> openCaptureSession(@NonNull CameraDevice cameraDevice, @NonNull SessionConfigurationCompat sessionConfigurationCompat) {
        return this.mImpl.openCaptureSession(cameraDevice, sessionConfigurationCompat);
    }

    @NonNull
    SessionConfigurationCompat createSessionConfigurationCompat(int sessionType, @NonNull List<OutputConfigurationCompat> outputsCompat, @NonNull SynchronizedCaptureSession.StateCallback stateCallback) {
        return this.mImpl.createSessionConfigurationCompat(sessionType, outputsCompat, stateCallback);
    }

    @NonNull
    ListenableFuture<List<Surface>> startWithDeferrableSurface(@NonNull List<DeferrableSurface> deferrableSurfaces, long timeout) {
        return this.mImpl.startWithDeferrableSurface(deferrableSurfaces, timeout);
    }

    boolean stop() {
        return this.mImpl.stop();
    }

    @NonNull
    public Executor getExecutor() {
        return this.mImpl.getExecutor();
    }

    static interface OpenerImpl {
        @NonNull
        public ListenableFuture<Void> openCaptureSession(@NonNull CameraDevice var1, @NonNull SessionConfigurationCompat var2);

        @NonNull
        public SessionConfigurationCompat createSessionConfigurationCompat(int var1, @NonNull List<OutputConfigurationCompat> var2, @NonNull SynchronizedCaptureSession.StateCallback var3);

        @NonNull
        public Executor getExecutor();

        @NonNull
        public ListenableFuture<List<Surface>> startWithDeferrableSurface(@NonNull List<DeferrableSurface> var1, long var2);

        public boolean stop();
    }

    static class Builder {
        private final Executor mExecutor;
        private final ScheduledExecutorService mScheduledExecutorService;
        private final Handler mCompatHandler;
        private final CaptureSessionRepository mCaptureSessionRepository;
        private final int mSupportedHardwareLevel;
        private final Set<String> mEnableFeature = new HashSet<String>();

        Builder(@NonNull Executor executor, @NonNull ScheduledExecutorService scheduledExecutorService, @NonNull Handler compatHandler, @NonNull CaptureSessionRepository captureSessionRepository, int supportedHardwareLevel) {
            this.mExecutor = executor;
            this.mScheduledExecutorService = scheduledExecutorService;
            this.mCompatHandler = compatHandler;
            this.mCaptureSessionRepository = captureSessionRepository;
            this.mSupportedHardwareLevel = supportedHardwareLevel;
            if (Build.VERSION.SDK_INT < 23) {
                this.mEnableFeature.add(SynchronizedCaptureSessionOpener.FEATURE_FORCE_CLOSE);
            }
            if (this.mSupportedHardwareLevel == 2 || Build.VERSION.SDK_INT <= 23) {
                this.mEnableFeature.add(SynchronizedCaptureSessionOpener.FEATURE_DEFERRABLE_SURFACE_CLOSE);
            }
            if (this.mSupportedHardwareLevel == 2) {
                this.mEnableFeature.add(SynchronizedCaptureSessionOpener.FEATURE_WAIT_FOR_REQUEST);
            }
        }

        @NonNull
        SynchronizedCaptureSessionOpener build() {
            if (this.mEnableFeature.isEmpty()) {
                return new SynchronizedCaptureSessionOpener(new SynchronizedCaptureSessionBaseImpl(this.mCaptureSessionRepository, this.mExecutor, this.mScheduledExecutorService, this.mCompatHandler));
            }
            return new SynchronizedCaptureSessionOpener(new SynchronizedCaptureSessionImpl(this.mEnableFeature, this.mCaptureSessionRepository, this.mExecutor, this.mScheduledExecutorService, this.mCompatHandler));
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static @interface SynchronizedSessionFeature {
    }
}

