/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.interop;

import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.camera.camera2.impl.Camera2ImplConfig;
import androidx.camera.camera2.internal.Camera2CameraControlImpl;
import androidx.camera.camera2.interop.CaptureRequestOptions;
import androidx.camera.camera2.interop.ExperimentalCamera2Interop;
import androidx.camera.core.CameraControl;
import androidx.camera.core.impl.Config;
import androidx.camera.core.impl.TagBundle;
import androidx.camera.core.impl.utils.futures.Futures;
import androidx.concurrent.futures.CallbackToFutureAdapter;
import androidx.core.util.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Iterator;
import java.util.concurrent.Executor;

@ExperimentalCamera2Interop
public final class Camera2CameraControl {
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static final String TAG_KEY = "Camera2CameraControl";
    private boolean mIsActive = false;
    private boolean mPendingUpdate = false;
    private final Camera2CameraControlImpl mCamera2CameraControlImpl;
    final Executor mExecutor;
    final Object mLock = new Object();
    @GuardedBy(value="mLock")
    private Camera2ImplConfig.Builder mBuilder = new Camera2ImplConfig.Builder();
    CallbackToFutureAdapter.Completer<Void> mCompleter;
    private final Camera2CameraControlImpl.CaptureResultListener mCaptureResultListener = captureResult -> {
        Integer tagInteger;
        Object tag;
        CallbackToFutureAdapter.Completer<Void> completerToSet = null;
        if (this.mCompleter != null && (tag = captureResult.getRequest().getTag()) instanceof TagBundle && (tagInteger = ((TagBundle)tag).getTag(TAG_KEY)) != null && tagInteger.equals(this.mCompleter.hashCode())) {
            completerToSet = this.mCompleter;
            this.mCompleter = null;
        }
        if (completerToSet != null) {
            completerToSet.set(null);
        }
        return false;
    };

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public Camera2CameraControl(@NonNull Camera2CameraControlImpl camera2CameraControlImpl, @NonNull Executor executor) {
        this.mCamera2CameraControlImpl = camera2CameraControlImpl;
        this.mExecutor = executor;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @NonNull
    public Camera2CameraControlImpl.CaptureResultListener getCaptureRequestListener() {
        return this.mCaptureResultListener;
    }

    @NonNull
    public static Camera2CameraControl from(@NonNull CameraControl cameraControl) {
        Preconditions.checkArgument((boolean)(cameraControl instanceof Camera2CameraControlImpl), (Object)"CameraControl doesn't contain Camera2 implementation.");
        return ((Camera2CameraControlImpl)cameraControl).getCamera2CameraControl();
    }

    @NonNull
    public ListenableFuture<Void> setCaptureRequestOptions(@NonNull CaptureRequestOptions bundle) {
        this.clearCaptureRequestOptionsInternal();
        this.addCaptureRequestOptionsInternal(bundle);
        return Futures.nonCancellationPropagating((ListenableFuture)CallbackToFutureAdapter.getFuture(completer -> {
            this.mExecutor.execute(() -> this.updateConfig((CallbackToFutureAdapter.Completer<Void>)completer));
            return "setCaptureRequestOptions";
        }));
    }

    @NonNull
    public ListenableFuture<Void> addCaptureRequestOptions(@NonNull CaptureRequestOptions bundle) {
        this.addCaptureRequestOptionsInternal(bundle);
        return Futures.nonCancellationPropagating((ListenableFuture)CallbackToFutureAdapter.getFuture(completer -> {
            this.mExecutor.execute(() -> this.updateConfig((CallbackToFutureAdapter.Completer<Void>)completer));
            return "addCaptureRequestOptions";
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public CaptureRequestOptions getCaptureRequestOptions() {
        Object object = this.mLock;
        synchronized (object) {
            return CaptureRequestOptions.Builder.from((Config)this.mBuilder.build()).build();
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @NonNull
    public ListenableFuture<Void> clearCaptureRequestOptions() {
        this.clearCaptureRequestOptionsInternal();
        return Futures.nonCancellationPropagating((ListenableFuture)CallbackToFutureAdapter.getFuture(completer -> {
            this.mExecutor.execute(() -> this.updateConfig((CallbackToFutureAdapter.Completer<Void>)completer));
            return "clearCaptureRequestOptions";
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @NonNull
    public Camera2ImplConfig getCamera2ImplConfig() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mCompleter != null) {
                this.mBuilder.getMutableConfig().insertOption(Camera2ImplConfig.CAPTURE_REQUEST_TAG_OPTION, (Object)this.mCompleter.hashCode());
            }
            return this.mBuilder.build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCaptureRequestOptionsInternal(@NonNull CaptureRequestOptions bundle) {
        Object object = this.mLock;
        synchronized (object) {
            Iterator iterator = bundle.listOptions().iterator();
            while (iterator.hasNext()) {
                Config.Option option;
                Config.Option objectOpt = option = (Config.Option)iterator.next();
                this.mBuilder.getMutableConfig().insertOption(objectOpt, bundle.retrieveOption(objectOpt));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearCaptureRequestOptionsInternal() {
        Object object = this.mLock;
        synchronized (object) {
            this.mBuilder = new Camera2ImplConfig.Builder();
        }
    }

    private void updateConfig(CallbackToFutureAdapter.Completer<Void> completer) {
        this.mPendingUpdate = true;
        CallbackToFutureAdapter.Completer<Void> completerToCancel = null;
        if (this.mCompleter != null) {
            completerToCancel = this.mCompleter;
        }
        this.mCompleter = completer;
        if (this.mIsActive) {
            this.updateSession();
        }
        if (completerToCancel != null) {
            completerToCancel.setException((Throwable)new CameraControl.OperationCanceledException("Camera2CameraControl was updated with new options."));
        }
    }

    private void updateSession() {
        this.mCamera2CameraControlImpl.updateSessionConfig();
        this.mPendingUpdate = false;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public void setActive(boolean isActive) {
        this.mExecutor.execute(() -> this.setActiveInternal(isActive));
    }

    private void setActiveInternal(boolean isActive) {
        if (this.mIsActive == isActive) {
            return;
        }
        this.mIsActive = isActive;
        if (this.mIsActive) {
            if (this.mPendingUpdate) {
                this.updateSession();
            }
        } else {
            this.clearCaptureRequestOptionsInternal();
            if (this.mCompleter != null) {
                this.mCompleter.setException((Throwable)new CameraControl.OperationCanceledException("The camera control has became inactive."));
                this.mCompleter = null;
            }
        }
    }
}

