/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal;

import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.camera.core.impl.SurfaceCombination;
import androidx.camera.core.impl.SurfaceConfig;
import java.util.ArrayList;
import java.util.List;

@RequiresApi(value=21)
public final class GuaranteedConfigurationsUtil {
    private GuaranteedConfigurationsUtil() {
    }

    @NonNull
    public static List<SurfaceCombination> getLegacySupportedCombinationList() {
        ArrayList<SurfaceCombination> combinationList = new ArrayList<SurfaceCombination>();
        SurfaceCombination surfaceCombination1 = new SurfaceCombination();
        surfaceCombination1.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.PRIV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.MAXIMUM));
        combinationList.add(surfaceCombination1);
        SurfaceCombination surfaceCombination2 = new SurfaceCombination();
        surfaceCombination2.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.JPEG, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.MAXIMUM));
        combinationList.add(surfaceCombination2);
        SurfaceCombination surfaceCombination3 = new SurfaceCombination();
        surfaceCombination3.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.YUV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.MAXIMUM));
        combinationList.add(surfaceCombination3);
        SurfaceCombination surfaceCombination4 = new SurfaceCombination();
        surfaceCombination4.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.PRIV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.PREVIEW));
        surfaceCombination4.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.JPEG, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.MAXIMUM));
        combinationList.add(surfaceCombination4);
        SurfaceCombination surfaceCombination5 = new SurfaceCombination();
        surfaceCombination5.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.YUV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.PREVIEW));
        surfaceCombination5.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.JPEG, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.MAXIMUM));
        combinationList.add(surfaceCombination5);
        SurfaceCombination surfaceCombination6 = new SurfaceCombination();
        surfaceCombination6.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.PRIV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.PREVIEW));
        surfaceCombination6.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.PRIV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.PREVIEW));
        combinationList.add(surfaceCombination6);
        SurfaceCombination surfaceCombination7 = new SurfaceCombination();
        surfaceCombination7.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.PRIV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.PREVIEW));
        surfaceCombination7.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.YUV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.PREVIEW));
        combinationList.add(surfaceCombination7);
        SurfaceCombination surfaceCombination8 = new SurfaceCombination();
        surfaceCombination8.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.PRIV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.PREVIEW));
        surfaceCombination8.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.YUV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.PREVIEW));
        surfaceCombination8.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.JPEG, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.MAXIMUM));
        combinationList.add(surfaceCombination8);
        return combinationList;
    }

    @NonNull
    public static List<SurfaceCombination> getLimitedSupportedCombinationList() {
        ArrayList<SurfaceCombination> combinationList = new ArrayList<SurfaceCombination>();
        SurfaceCombination surfaceCombination1 = new SurfaceCombination();
        surfaceCombination1.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.PRIV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.PREVIEW));
        surfaceCombination1.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.PRIV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.RECORD));
        combinationList.add(surfaceCombination1);
        SurfaceCombination surfaceCombination2 = new SurfaceCombination();
        surfaceCombination2.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.PRIV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.PREVIEW));
        surfaceCombination2.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.YUV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.RECORD));
        combinationList.add(surfaceCombination2);
        SurfaceCombination surfaceCombination3 = new SurfaceCombination();
        surfaceCombination3.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.YUV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.PREVIEW));
        surfaceCombination3.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.YUV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.RECORD));
        combinationList.add(surfaceCombination3);
        SurfaceCombination surfaceCombination4 = new SurfaceCombination();
        surfaceCombination4.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.PRIV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.PREVIEW));
        surfaceCombination4.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.PRIV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.RECORD));
        surfaceCombination4.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.JPEG, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.RECORD));
        combinationList.add(surfaceCombination4);
        SurfaceCombination surfaceCombination5 = new SurfaceCombination();
        surfaceCombination5.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.PRIV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.PREVIEW));
        surfaceCombination5.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.YUV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.RECORD));
        surfaceCombination5.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.JPEG, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.RECORD));
        combinationList.add(surfaceCombination5);
        SurfaceCombination surfaceCombination6 = new SurfaceCombination();
        surfaceCombination6.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.YUV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.PREVIEW));
        surfaceCombination6.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.YUV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.PREVIEW));
        surfaceCombination6.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.JPEG, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.MAXIMUM));
        combinationList.add(surfaceCombination6);
        return combinationList;
    }

    @NonNull
    public static List<SurfaceCombination> getFullSupportedCombinationList() {
        ArrayList<SurfaceCombination> combinationList = new ArrayList<SurfaceCombination>();
        SurfaceCombination surfaceCombination1 = new SurfaceCombination();
        surfaceCombination1.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.PRIV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.PREVIEW));
        surfaceCombination1.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.PRIV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.MAXIMUM));
        combinationList.add(surfaceCombination1);
        SurfaceCombination surfaceCombination2 = new SurfaceCombination();
        surfaceCombination2.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.PRIV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.PREVIEW));
        surfaceCombination2.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.YUV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.MAXIMUM));
        combinationList.add(surfaceCombination2);
        SurfaceCombination surfaceCombination3 = new SurfaceCombination();
        surfaceCombination3.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.YUV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.PREVIEW));
        surfaceCombination3.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.YUV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.MAXIMUM));
        combinationList.add(surfaceCombination3);
        SurfaceCombination surfaceCombination4 = new SurfaceCombination();
        surfaceCombination4.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.PRIV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.PREVIEW));
        surfaceCombination4.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.PRIV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.PREVIEW));
        surfaceCombination4.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.JPEG, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.MAXIMUM));
        combinationList.add(surfaceCombination4);
        SurfaceCombination surfaceCombination5 = new SurfaceCombination();
        surfaceCombination5.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.YUV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.VGA));
        surfaceCombination5.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.PRIV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.PREVIEW));
        surfaceCombination5.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.YUV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.MAXIMUM));
        combinationList.add(surfaceCombination5);
        SurfaceCombination surfaceCombination6 = new SurfaceCombination();
        surfaceCombination6.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.YUV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.VGA));
        surfaceCombination6.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.YUV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.PREVIEW));
        surfaceCombination6.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.YUV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.MAXIMUM));
        combinationList.add(surfaceCombination6);
        return combinationList;
    }

    @NonNull
    public static List<SurfaceCombination> getRAWSupportedCombinationList() {
        ArrayList<SurfaceCombination> combinationList = new ArrayList<SurfaceCombination>();
        SurfaceCombination surfaceCombination1 = new SurfaceCombination();
        surfaceCombination1.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.RAW, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.MAXIMUM));
        combinationList.add(surfaceCombination1);
        SurfaceCombination surfaceCombination2 = new SurfaceCombination();
        surfaceCombination2.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.PRIV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.PREVIEW));
        surfaceCombination2.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.RAW, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.MAXIMUM));
        combinationList.add(surfaceCombination2);
        SurfaceCombination surfaceCombination3 = new SurfaceCombination();
        surfaceCombination3.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.YUV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.PREVIEW));
        surfaceCombination3.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.RAW, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.MAXIMUM));
        combinationList.add(surfaceCombination3);
        SurfaceCombination surfaceCombination4 = new SurfaceCombination();
        surfaceCombination4.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.PRIV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.PREVIEW));
        surfaceCombination4.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.PRIV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.PREVIEW));
        surfaceCombination4.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.RAW, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.MAXIMUM));
        combinationList.add(surfaceCombination4);
        SurfaceCombination surfaceCombination5 = new SurfaceCombination();
        surfaceCombination5.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.PRIV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.PREVIEW));
        surfaceCombination5.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.YUV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.PREVIEW));
        surfaceCombination5.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.RAW, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.MAXIMUM));
        combinationList.add(surfaceCombination5);
        SurfaceCombination surfaceCombination6 = new SurfaceCombination();
        surfaceCombination6.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.YUV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.PREVIEW));
        surfaceCombination6.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.YUV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.PREVIEW));
        surfaceCombination6.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.RAW, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.MAXIMUM));
        combinationList.add(surfaceCombination6);
        SurfaceCombination surfaceCombination7 = new SurfaceCombination();
        surfaceCombination7.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.PRIV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.PREVIEW));
        surfaceCombination7.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.JPEG, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.MAXIMUM));
        surfaceCombination7.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.RAW, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.MAXIMUM));
        combinationList.add(surfaceCombination7);
        SurfaceCombination surfaceCombination8 = new SurfaceCombination();
        surfaceCombination8.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.YUV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.PREVIEW));
        surfaceCombination8.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.JPEG, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.MAXIMUM));
        surfaceCombination8.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.RAW, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.MAXIMUM));
        combinationList.add(surfaceCombination8);
        return combinationList;
    }

    @NonNull
    public static List<SurfaceCombination> getBurstSupportedCombinationList() {
        ArrayList<SurfaceCombination> combinationList = new ArrayList<SurfaceCombination>();
        SurfaceCombination surfaceCombination1 = new SurfaceCombination();
        surfaceCombination1.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.PRIV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.PREVIEW));
        surfaceCombination1.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.PRIV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.MAXIMUM));
        combinationList.add(surfaceCombination1);
        SurfaceCombination surfaceCombination2 = new SurfaceCombination();
        surfaceCombination2.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.PRIV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.PREVIEW));
        surfaceCombination2.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.YUV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.MAXIMUM));
        combinationList.add(surfaceCombination2);
        SurfaceCombination surfaceCombination3 = new SurfaceCombination();
        surfaceCombination3.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.YUV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.PREVIEW));
        surfaceCombination3.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.YUV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.MAXIMUM));
        combinationList.add(surfaceCombination3);
        return combinationList;
    }

    @NonNull
    public static List<SurfaceCombination> getLevel3SupportedCombinationList() {
        ArrayList<SurfaceCombination> combinationList = new ArrayList<SurfaceCombination>();
        SurfaceCombination surfaceCombination1 = new SurfaceCombination();
        surfaceCombination1.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.PRIV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.PREVIEW));
        surfaceCombination1.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.PRIV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.VGA));
        surfaceCombination1.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.YUV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.MAXIMUM));
        surfaceCombination1.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.RAW, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.MAXIMUM));
        combinationList.add(surfaceCombination1);
        SurfaceCombination surfaceCombination2 = new SurfaceCombination();
        surfaceCombination2.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.PRIV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.PREVIEW));
        surfaceCombination2.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.PRIV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.VGA));
        surfaceCombination2.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.JPEG, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.MAXIMUM));
        surfaceCombination2.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.RAW, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.MAXIMUM));
        combinationList.add(surfaceCombination2);
        return combinationList;
    }

    @NonNull
    public static List<SurfaceCombination> generateSupportedCombinationList(int hardwareLevel, boolean isRawSupported, boolean isBurstCaptureSupported) {
        ArrayList<SurfaceCombination> surfaceCombinations = new ArrayList<SurfaceCombination>();
        surfaceCombinations.addAll(GuaranteedConfigurationsUtil.getLegacySupportedCombinationList());
        if (hardwareLevel == 0 || hardwareLevel == 1 || hardwareLevel == 3) {
            surfaceCombinations.addAll(GuaranteedConfigurationsUtil.getLimitedSupportedCombinationList());
        }
        if (hardwareLevel == 1 || hardwareLevel == 3) {
            surfaceCombinations.addAll(GuaranteedConfigurationsUtil.getFullSupportedCombinationList());
        }
        if (isRawSupported) {
            surfaceCombinations.addAll(GuaranteedConfigurationsUtil.getRAWSupportedCombinationList());
        }
        if (isBurstCaptureSupported && hardwareLevel == 0) {
            surfaceCombinations.addAll(GuaranteedConfigurationsUtil.getBurstSupportedCombinationList());
        }
        if (hardwareLevel == 3) {
            surfaceCombinations.addAll(GuaranteedConfigurationsUtil.getLevel3SupportedCombinationList());
        }
        return surfaceCombinations;
    }
}

