/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.extensions;

import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.TotalCaptureResult;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.camera2.impl.Camera2CameraCaptureResultConverter;
import androidx.camera.core.ImageInfo;
import androidx.camera.core.impl.CameraCaptureResult;
import androidx.camera.core.impl.CameraCaptureResults;
import androidx.camera.core.impl.CaptureStage;
import androidx.camera.core.impl.ImageInfoProcessor;
import androidx.camera.extensions.AdaptingCaptureStage;
import androidx.camera.extensions.BlockingCloseAccessCounter;
import androidx.camera.extensions.PreviewExtender;
import androidx.camera.extensions.impl.CaptureStageImpl;
import androidx.camera.extensions.impl.PreviewExtenderImpl;
import androidx.camera.extensions.impl.RequestUpdateProcessorImpl;
import androidx.core.util.Preconditions;

final class AdaptingRequestUpdateProcessor
implements ImageInfoProcessor,
PreviewExtender.CloseableProcessor {
    private final PreviewExtenderImpl mPreviewExtenderImpl;
    private final RequestUpdateProcessorImpl mProcessorImpl;
    private BlockingCloseAccessCounter mAccessCounter = new BlockingCloseAccessCounter();

    AdaptingRequestUpdateProcessor(PreviewExtenderImpl previewExtenderImpl) {
        Preconditions.checkArgument((previewExtenderImpl.getProcessorType() == PreviewExtenderImpl.ProcessorType.PROCESSOR_TYPE_REQUEST_UPDATE_ONLY ? 1 : 0) != 0, (Object)"AdaptingRequestUpdateProcess can only adapt extender with PROCESSOR_TYPE_REQUEST_UPDATE_ONLY ProcessorType.");
        this.mPreviewExtenderImpl = previewExtenderImpl;
        this.mProcessorImpl = (RequestUpdateProcessorImpl)this.mPreviewExtenderImpl.getProcessor();
    }

    @Nullable
    public CaptureStage getCaptureStage() {
        if (!this.mAccessCounter.tryIncrement()) {
            return null;
        }
        try {
            AdaptingCaptureStage adaptingCaptureStage = new AdaptingCaptureStage(this.mPreviewExtenderImpl.getCaptureStage());
            return adaptingCaptureStage;
        }
        finally {
            this.mAccessCounter.decrement();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean process(@NonNull ImageInfo imageInfo) {
        if (!this.mAccessCounter.tryIncrement()) {
            return false;
        }
        try {
            boolean processResult = false;
            CameraCaptureResult result = CameraCaptureResults.retrieveCameraCaptureResult((ImageInfo)imageInfo);
            CaptureResult captureResult = Camera2CameraCaptureResultConverter.getCaptureResult((CameraCaptureResult)result);
            if (captureResult instanceof TotalCaptureResult) {
                CaptureStageImpl captureStageImpl = this.mProcessorImpl.process((TotalCaptureResult)captureResult);
                processResult = captureStageImpl != null;
            }
            boolean bl = processResult;
            return bl;
        }
        finally {
            this.mAccessCounter.decrement();
        }
    }

    @Override
    public void close() {
        this.mAccessCounter.destroyAndWaitForZeroAccess();
    }
}

