/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.extensions;

import android.util.Log;
import androidx.camera.extensions.Version;
import androidx.camera.extensions.VersionName;
import androidx.camera.extensions.impl.ExtensionVersionImpl;

abstract class ExtensionVersion {
    private static final String TAG = "ExtenderVersion";
    private static volatile ExtensionVersion sExtensionVersion;

    ExtensionVersion() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ExtensionVersion getInstance() {
        if (sExtensionVersion != null) {
            return sExtensionVersion;
        }
        Class<ExtensionVersion> clazz = ExtensionVersion.class;
        synchronized (ExtensionVersion.class) {
            if (sExtensionVersion == null) {
                try {
                    sExtensionVersion = new VendorExtenderVersioning();
                }
                catch (NoClassDefFoundError e) {
                    Log.d((String)TAG, (String)"No versioning extender found. Falling back to default.");
                    sExtensionVersion = new DefaultExtenderVersioning();
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sExtensionVersion;
        }
    }

    static boolean isExtensionVersionSupported() {
        return ExtensionVersion.getInstance().getVersionObject() != null;
    }

    static Version getRuntimeVersion() {
        return ExtensionVersion.getInstance().getVersionObject();
    }

    abstract Version getVersionObject();

    private static class DefaultExtenderVersioning
    extends ExtensionVersion {
        DefaultExtenderVersioning() {
        }

        @Override
        Version getVersionObject() {
            return null;
        }
    }

    private static class VendorExtenderVersioning
    extends ExtensionVersion {
        private ExtensionVersionImpl mImpl = new ExtensionVersionImpl();
        private Version mRuntimeVersion;

        VendorExtenderVersioning() {
            String vendorVersion = this.mImpl.checkApiVersion(VersionName.getCurrentVersion().toVersionString());
            Version vendorVersionObj = Version.parse(vendorVersion);
            if (vendorVersionObj != null && VersionName.getCurrentVersion().getVersion().getMajor() == vendorVersionObj.getMajor()) {
                this.mRuntimeVersion = vendorVersionObj;
            }
            Log.d((String)ExtensionVersion.TAG, (String)("Selected vendor runtime: " + this.mRuntimeVersion));
        }

        @Override
        Version getVersionObject() {
            return this.mRuntimeVersion;
        }
    }
}

