/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.extensions;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.core.CameraSelector;
import androidx.camera.core.CameraX;
import androidx.camera.core.ImageCapture;
import androidx.camera.core.Preview;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import androidx.camera.core.impl.utils.futures.Futures;
import androidx.camera.extensions.AutoImageCaptureExtender;
import androidx.camera.extensions.AutoPreviewExtender;
import androidx.camera.extensions.BeautyImageCaptureExtender;
import androidx.camera.extensions.BeautyPreviewExtender;
import androidx.camera.extensions.BokehImageCaptureExtender;
import androidx.camera.extensions.BokehPreviewExtender;
import androidx.camera.extensions.ExtensionVersion;
import androidx.camera.extensions.ExtensionsErrorListener;
import androidx.camera.extensions.HdrImageCaptureExtender;
import androidx.camera.extensions.HdrPreviewExtender;
import androidx.camera.extensions.ImageCaptureExtender;
import androidx.camera.extensions.NightImageCaptureExtender;
import androidx.camera.extensions.NightPreviewExtender;
import androidx.camera.extensions.PreviewExtender;
import androidx.camera.extensions.Version;
import androidx.camera.extensions.VersionName;
import androidx.camera.extensions.impl.InitializerImpl;
import androidx.concurrent.futures.CallbackToFutureAdapter;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.Executor;

public final class ExtensionsManager {
    private static final String TAG = "ExtensionsManager";
    private static final Object ERROR_LOCK = new Object();
    @GuardedBy(value="ERROR_LOCK")
    private static final Handler DEFAULT_HANDLER = new Handler(Looper.getMainLooper());
    @GuardedBy(value="ERROR_LOCK")
    private static volatile ExtensionsErrorListener sExtensionsErrorListener = null;

    @NonNull
    public static ListenableFuture<ExtensionsAvailability> init() {
        if (ExtensionVersion.getRuntimeVersion() == null) {
            return Futures.immediateFuture((Object)((Object)ExtensionsAvailability.NONE));
        }
        if (ExtensionVersion.getRuntimeVersion().compareTo(Version.VERSION_1_1) < 0) {
            return Futures.immediateFuture((Object)((Object)ExtensionsAvailability.LIBRARY_AVAILABLE));
        }
        return CallbackToFutureAdapter.getFuture(completer -> {
            try {
                InitializerImpl.init((String)VersionName.getCurrentVersion().toVersionString(), (Context)CameraX.getContext(), (InitializerImpl.OnExtensionsInitializedCallback)new InitializerImpl.OnExtensionsInitializedCallback(){

                    public void onSuccess() {
                        Log.d((String)ExtensionsManager.TAG, (String)"Successfully initialized extensions");
                        completer.set((Object)ExtensionsAvailability.LIBRARY_AVAILABLE);
                    }

                    public void onFailure(int error) {
                        Log.d((String)ExtensionsManager.TAG, (String)"Failed to initialize extensions");
                        completer.set((Object)ExtensionsAvailability.LIBRARY_UNAVAILABLE_ERROR_LOADING);
                    }
                }, (Executor)CameraXExecutors.mainThreadExecutor());
            }
            catch (NoClassDefFoundError | NoSuchMethodError e) {
                completer.set((Object)ExtensionsAvailability.LIBRARY_UNAVAILABLE_MISSING_IMPLEMENTATION);
            }
            return "Initialize extensions";
        });
    }

    public static boolean isExtensionAvailable(EffectMode effectMode, int lensFacing) {
        boolean isPreviewAvailable;
        boolean isImageCaptureAvailable = ExtensionsManager.checkImageCaptureExtensionCapability(effectMode, lensFacing);
        if (isImageCaptureAvailable != (isPreviewAvailable = ExtensionsManager.checkPreviewExtensionCapability(effectMode, lensFacing))) {
            Log.e((String)TAG, (String)("ImageCapture and Preview are not available simultaneously for " + effectMode.name()));
        }
        return isImageCaptureAvailable && isPreviewAvailable;
    }

    public static boolean isExtensionAvailable(Class<?> klass, EffectMode effectMode, int lensFacing) {
        boolean isAvailable = false;
        if (klass == ImageCapture.class) {
            isAvailable = ExtensionsManager.checkImageCaptureExtensionCapability(effectMode, lensFacing);
        } else if (klass.equals(Preview.class)) {
            isAvailable = ExtensionsManager.checkPreviewExtensionCapability(effectMode, lensFacing);
        }
        return isAvailable;
    }

    private static boolean checkImageCaptureExtensionCapability(EffectMode effectMode, int lensFacing) {
        ImageCaptureExtender extender;
        ImageCapture.Builder builder = new ImageCapture.Builder();
        CameraSelector selector = new CameraSelector.Builder().requireLensFacing(lensFacing).build();
        switch (effectMode) {
            case BOKEH: {
                extender = BokehImageCaptureExtender.create(builder);
                break;
            }
            case HDR: {
                extender = HdrImageCaptureExtender.create(builder);
                break;
            }
            case NIGHT: {
                extender = NightImageCaptureExtender.create(builder);
                break;
            }
            case BEAUTY: {
                extender = BeautyImageCaptureExtender.create(builder);
                break;
            }
            case AUTO: {
                extender = AutoImageCaptureExtender.create(builder);
                break;
            }
            case NORMAL: {
                return true;
            }
            default: {
                return false;
            }
        }
        return extender.isExtensionAvailable(selector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setExtensionsErrorListener(@Nullable ExtensionsErrorListener listener) {
        Object object = ERROR_LOCK;
        synchronized (object) {
            sExtensionsErrorListener = listener;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void postExtensionsError(final ExtensionsErrorListener.ExtensionsErrorCode errorCode) {
        Object object = ERROR_LOCK;
        synchronized (object) {
            final ExtensionsErrorListener listenerReference = sExtensionsErrorListener;
            if (listenerReference != null) {
                DEFAULT_HANDLER.post(new Runnable(){

                    @Override
                    public void run() {
                        listenerReference.onError(errorCode);
                    }
                });
            }
        }
    }

    private static boolean checkPreviewExtensionCapability(EffectMode effectMode, int lensFacing) {
        PreviewExtender extender;
        Preview.Builder builder = new Preview.Builder();
        CameraSelector cameraSelector = new CameraSelector.Builder().requireLensFacing(lensFacing).build();
        switch (effectMode) {
            case BOKEH: {
                extender = BokehPreviewExtender.create(builder);
                break;
            }
            case HDR: {
                extender = HdrPreviewExtender.create(builder);
                break;
            }
            case NIGHT: {
                extender = NightPreviewExtender.create(builder);
                break;
            }
            case BEAUTY: {
                extender = BeautyPreviewExtender.create(builder);
                break;
            }
            case AUTO: {
                extender = AutoPreviewExtender.create(builder);
                break;
            }
            case NORMAL: {
                return true;
            }
            default: {
                return false;
            }
        }
        return extender.isExtensionAvailable(cameraSelector);
    }

    private ExtensionsManager() {
    }

    public static enum ExtensionsAvailability {
        LIBRARY_AVAILABLE,
        LIBRARY_UNAVAILABLE_ERROR_LOADING,
        LIBRARY_UNAVAILABLE_MISSING_IMPLEMENTATION,
        NONE;

    }

    public static enum EffectMode {
        NORMAL,
        BOKEH,
        HDR,
        NIGHT,
        BEAUTY,
        AUTO;

    }
}

