/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.extensions;

import android.hardware.camera2.CameraCharacteristics;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.camera.camera2.impl.Camera2ImplConfig;
import androidx.camera.camera2.impl.CameraEventCallback;
import androidx.camera.camera2.impl.CameraEventCallbacks;
import androidx.camera.core.CameraSelector;
import androidx.camera.core.CameraX;
import androidx.camera.core.ExtendableBuilder;
import androidx.camera.core.ImageCapture;
import androidx.camera.core.UseCase;
import androidx.camera.core.impl.CameraFilter;
import androidx.camera.core.impl.CaptureBundle;
import androidx.camera.core.impl.CaptureConfig;
import androidx.camera.core.impl.CaptureProcessor;
import androidx.camera.core.impl.CaptureStage;
import androidx.camera.core.impl.Config;
import androidx.camera.extensions.AdaptingCaptureProcessor;
import androidx.camera.extensions.AdaptingCaptureStage;
import androidx.camera.extensions.CameraUtil;
import androidx.camera.extensions.ExtensionCameraFilter;
import androidx.camera.extensions.ExtensionVersion;
import androidx.camera.extensions.ExtensionsErrorListener;
import androidx.camera.extensions.ExtensionsManager;
import androidx.camera.extensions.PreviewExtender;
import androidx.camera.extensions.Version;
import androidx.camera.extensions.impl.CaptureProcessorImpl;
import androidx.camera.extensions.impl.CaptureStageImpl;
import androidx.camera.extensions.impl.ImageCaptureExtenderImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class ImageCaptureExtender {
    private static final String TAG = "ImageCaptureExtender";
    static final Config.Option<ExtensionsManager.EffectMode> OPTION_IMAGE_CAPTURE_EXTENDER_MODE = Config.Option.create((String)"camerax.extensions.imageCaptureExtender.mode", ExtensionsManager.EffectMode.class);
    private ImageCapture.Builder mBuilder;
    private ImageCaptureExtenderImpl mImpl;
    private ExtensionsManager.EffectMode mEffectMode;
    private ExtensionCameraFilter mExtensionCameraFilter;

    void init(ImageCapture.Builder builder, ImageCaptureExtenderImpl implementation, ExtensionsManager.EffectMode effectMode) {
        this.mBuilder = builder;
        this.mImpl = implementation;
        this.mEffectMode = effectMode;
        this.mExtensionCameraFilter = new ExtensionCameraFilter(this.mImpl);
    }

    public boolean isExtensionAvailable(@NonNull CameraSelector cameraSelector) {
        return this.getCameraWithExtension(cameraSelector) != null;
    }

    private String getCameraWithExtension(@NonNull CameraSelector cameraSelector) {
        CameraSelector.Builder extensionCameraSelectorBuilder = CameraSelector.Builder.fromSelector((CameraSelector)cameraSelector);
        extensionCameraSelectorBuilder.appendFilter((CameraFilter)this.mExtensionCameraFilter);
        return CameraUtil.getCameraIdUnchecked(extensionCameraSelectorBuilder.build());
    }

    public void enableExtension(@NonNull CameraSelector cameraSelector) {
        String cameraId = this.getCameraWithExtension(cameraSelector);
        if (cameraId == null) {
            return;
        }
        CameraSelector originalSelector = this.mBuilder.getUseCaseConfig().getCameraSelector(null);
        if (originalSelector == null) {
            this.mBuilder.setCameraSelector(new CameraSelector.Builder().appendFilter((CameraFilter)this.mExtensionCameraFilter).build());
        } else {
            this.mBuilder.setCameraSelector(CameraSelector.Builder.fromSelector((CameraSelector)originalSelector).appendFilter((CameraFilter)this.mExtensionCameraFilter).build());
        }
        CameraCharacteristics cameraCharacteristics = CameraUtil.getCameraCharacteristics(cameraId);
        this.mImpl.init(cameraId, cameraCharacteristics);
        CaptureProcessorImpl captureProcessor = this.mImpl.getCaptureProcessor();
        if (captureProcessor != null) {
            this.mBuilder.setCaptureProcessor((CaptureProcessor)new AdaptingCaptureProcessor(captureProcessor));
        }
        if (this.mImpl.getMaxCaptureStage() > 0) {
            this.mBuilder.setMaxCaptureStages(this.mImpl.getMaxCaptureStage());
        }
        ImageCaptureAdapter imageCaptureAdapter = new ImageCaptureAdapter(this.mImpl, this.mEffectMode);
        new Camera2ImplConfig.Extender((ExtendableBuilder)this.mBuilder).setCameraEventCallback(new CameraEventCallbacks(new CameraEventCallback[]{imageCaptureAdapter}));
        this.mBuilder.setUseCaseEventCallback((UseCase.EventCallback)imageCaptureAdapter);
        this.mBuilder.setCaptureBundle((CaptureBundle)imageCaptureAdapter);
        this.mBuilder.getMutableConfig().insertOption(OPTION_IMAGE_CAPTURE_EXTENDER_MODE, (Object)this.mEffectMode);
        this.setSupportedResolutions();
    }

    private void setSupportedResolutions() {
        if (ExtensionVersion.getRuntimeVersion().compareTo(Version.VERSION_1_1) < 0) {
            return;
        }
        List supportedResolutions = null;
        try {
            supportedResolutions = this.mImpl.getSupportedResolutions();
        }
        catch (NoSuchMethodError e) {
            Log.e((String)TAG, (String)"getSupportedResolution interface is not implemented in vendor library.");
        }
        if (supportedResolutions != null) {
            this.mBuilder.setSupportedResolutions(supportedResolutions);
        }
    }

    static void checkPreviewEnabled(ExtensionsManager.EffectMode effectMode, Collection<UseCase> activeUseCases) {
        boolean isPreviewExtenderEnabled = false;
        boolean isMismatched = false;
        if (activeUseCases == null || activeUseCases.isEmpty()) {
            return;
        }
        for (UseCase useCase : activeUseCases) {
            ExtensionsManager.EffectMode previewExtenderMode = (ExtensionsManager.EffectMode)((Object)useCase.getUseCaseConfig().retrieveOption(PreviewExtender.OPTION_PREVIEW_EXTENDER_MODE, null));
            if (effectMode == previewExtenderMode) {
                isPreviewExtenderEnabled = true;
                continue;
            }
            if (previewExtenderMode == null) continue;
            isMismatched = true;
        }
        if (isMismatched) {
            ExtensionsManager.postExtensionsError(ExtensionsErrorListener.ExtensionsErrorCode.MISMATCHED_EXTENSIONS_ENABLED);
        } else if (!isPreviewExtenderEnabled) {
            ExtensionsManager.postExtensionsError(ExtensionsErrorListener.ExtensionsErrorCode.PREVIEW_EXTENSION_REQUIRED);
        }
    }

    static class ImageCaptureAdapter
    extends CameraEventCallback
    implements UseCase.EventCallback,
    CaptureBundle {
        final ExtensionsManager.EffectMode mEffectMode;
        private final ImageCaptureExtenderImpl mImpl;
        private final AtomicBoolean mActive = new AtomicBoolean(true);
        private final Object mLock = new Object();
        @GuardedBy(value="mLock")
        private volatile int mEnabledSessionCount = 0;
        @GuardedBy(value="mLock")
        private volatile boolean mUnbind = false;

        ImageCaptureAdapter(ImageCaptureExtenderImpl impl, ExtensionsManager.EffectMode effectMode) {
            this.mImpl = impl;
            this.mEffectMode = effectMode;
        }

        public void onBind(@NonNull String cameraId) {
            if (this.mActive.get()) {
                CameraCharacteristics cameraCharacteristics = CameraUtil.getCameraCharacteristics(cameraId);
                this.mImpl.onInit(cameraId, cameraCharacteristics, CameraX.getContext());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onUnbind() {
            Object object = this.mLock;
            synchronized (object) {
                this.mUnbind = true;
                if (this.mEnabledSessionCount == 0) {
                    this.callDeInit();
                }
            }
        }

        private void callDeInit() {
            if (this.mActive.get()) {
                this.mImpl.onDeInit();
                this.mActive.set(false);
            }
        }

        public CaptureConfig onPresetSession() {
            if (this.mActive.get()) {
                Handler handler = new Handler(Looper.getMainLooper());
                handler.post(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ImageCaptureExtender.checkPreviewEnabled(mEffectMode, CameraX.getActiveUseCases());
                        }
                        catch (IllegalStateException e) {
                            Log.e((String)ImageCaptureExtender.TAG, (String)"CameraX has been shutdown. Don't need to check for active use cases.");
                        }
                    }
                });
                CaptureStageImpl captureStageImpl = this.mImpl.onPresetSession();
                if (captureStageImpl != null) {
                    return new AdaptingCaptureStage(captureStageImpl).getCaptureConfig();
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CaptureConfig onEnableSession() {
            try {
                CaptureStageImpl captureStageImpl;
                if (this.mActive.get() && (captureStageImpl = this.mImpl.onEnableSession()) != null) {
                    CaptureConfig captureConfig = new AdaptingCaptureStage(captureStageImpl).getCaptureConfig();
                    return captureConfig;
                }
                CaptureConfig captureConfig = null;
                return captureConfig;
            }
            finally {
                Object object = this.mLock;
                synchronized (object) {
                    ++this.mEnabledSessionCount;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CaptureConfig onDisableSession() {
            try {
                CaptureStageImpl captureStageImpl;
                if (this.mActive.get() && (captureStageImpl = this.mImpl.onDisableSession()) != null) {
                    CaptureConfig captureConfig = new AdaptingCaptureStage(captureStageImpl).getCaptureConfig();
                    return captureConfig;
                }
                CaptureConfig captureConfig = null;
                return captureConfig;
            }
            finally {
                Object object = this.mLock;
                synchronized (object) {
                    --this.mEnabledSessionCount;
                    if (this.mEnabledSessionCount == 0 && this.mUnbind) {
                        this.callDeInit();
                    }
                }
            }
        }

        public List<CaptureStage> getCaptureStages() {
            List captureStages;
            if (this.mActive.get() && (captureStages = this.mImpl.getCaptureStages()) != null && !captureStages.isEmpty()) {
                ArrayList<CaptureStage> ret = new ArrayList<CaptureStage>();
                for (CaptureStageImpl s : captureStages) {
                    ret.add(new AdaptingCaptureStage(s));
                }
                return ret;
            }
            return null;
        }
    }
}

