/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.extensions;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.camera.extensions.AutoValue_Version;
import com.google.auto.value.AutoValue;
import java.math.BigInteger;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@AutoValue
abstract class Version
implements Comparable<Version> {
    static final Version VERSION_1_0 = Version.create(1, 0, 0, "");
    static final Version VERSION_1_1 = Version.create(1, 1, 0, "");
    private static final Pattern VERSION_STRING_PATTERN = Pattern.compile("(\\d+)(?:\\.(\\d+))(?:\\.(\\d+))(?:\\-(.+))?");

    public static Version parse(String versionString) {
        if (TextUtils.isEmpty((CharSequence)versionString)) {
            return null;
        }
        Matcher matcher = VERSION_STRING_PATTERN.matcher(versionString);
        if (!matcher.matches()) {
            return null;
        }
        int major = Integer.parseInt(matcher.group(1));
        int minor = Integer.parseInt(matcher.group(2));
        int patch = Integer.parseInt(matcher.group(3));
        String description = matcher.group(4) != null ? matcher.group(4) : "";
        return Version.create(major, minor, patch, description);
    }

    public static Version create(int major, int minor, int patch, String description) {
        return new AutoValue_Version(major, minor, patch, description);
    }

    Version() {
    }

    abstract int getMajor();

    abstract int getMinor();

    abstract int getPatch();

    abstract String getDescription();

    @NonNull
    public final String toString() {
        StringBuilder sb = new StringBuilder(this.getMajor() + "." + this.getMinor() + "." + this.getPatch());
        if (!TextUtils.isEmpty((CharSequence)this.getDescription())) {
            sb.append("-" + this.getDescription());
        }
        return sb.toString();
    }

    @Override
    public int compareTo(Version other) {
        return Version.createBigInteger(this).compareTo(Version.createBigInteger(other));
    }

    @Override
    public int compareTo(int majorVersion) {
        return this.compareTo(majorVersion, 0);
    }

    public int compareTo(int majorVersion, int minorVersion) {
        if (this.getMajor() == majorVersion) {
            return Integer.compare(this.getMinor(), minorVersion);
        }
        return Integer.compare(this.getMajor(), majorVersion);
    }

    private static BigInteger createBigInteger(Version version) {
        return BigInteger.valueOf(version.getMajor()).shiftLeft(32).or(BigInteger.valueOf(version.getMinor())).shiftLeft(32).or(BigInteger.valueOf(version.getPatch()));
    }

    public final boolean equals(Object obj) {
        if (!(obj instanceof Version)) {
            return false;
        }
        Version otherVersionObj = (Version)obj;
        return Objects.equals(this.getMajor(), otherVersionObj.getMajor()) && Objects.equals(this.getMinor(), otherVersionObj.getMinor()) && Objects.equals(this.getPatch(), otherVersionObj.getPatch());
    }

    public final int hashCode() {
        return Objects.hash(this.getMajor(), this.getMinor(), this.getPatch());
    }
}

