/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.extensions;

import androidx.annotation.NonNull;
import androidx.camera.core.CameraSelector;
import androidx.camera.core.ImageCapture;
import androidx.camera.core.Logger;
import androidx.camera.extensions.ExtensionVersion;
import androidx.camera.extensions.ExtensionsManager;
import androidx.camera.extensions.ImageCaptureExtender;
import androidx.camera.extensions.impl.BokehImageCaptureExtenderImpl;
import androidx.camera.extensions.impl.ImageCaptureExtenderImpl;

public class BokehImageCaptureExtender
extends ImageCaptureExtender {
    private static final String TAG = "BokehImgCaptureExtender";

    @NonNull
    public static BokehImageCaptureExtender create(@NonNull ImageCapture.Builder builder) {
        if (ExtensionVersion.isExtensionVersionSupported()) {
            try {
                return new VendorBokehImageCaptureExtender(builder);
            }
            catch (NoClassDefFoundError e) {
                Logger.d((String)TAG, (String)"No bokeh image capture extender found. Falling back to default.");
            }
        }
        return new DefaultBokehImageCaptureExtender();
    }

    private BokehImageCaptureExtender() {
    }

    private static class VendorBokehImageCaptureExtender
    extends BokehImageCaptureExtender {
        private final BokehImageCaptureExtenderImpl mImpl = new BokehImageCaptureExtenderImpl();

        VendorBokehImageCaptureExtender(ImageCapture.Builder builder) {
            this.init(builder, (ImageCaptureExtenderImpl)this.mImpl, ExtensionsManager.EffectMode.BOKEH);
        }
    }

    private static class DefaultBokehImageCaptureExtender
    extends BokehImageCaptureExtender {
        DefaultBokehImageCaptureExtender() {
        }

        @Override
        public boolean isExtensionAvailable(@NonNull CameraSelector selector) {
            return false;
        }

        @Override
        public void enableExtension(@NonNull CameraSelector selector) {
        }
    }
}

