/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.extensions;

import androidx.annotation.NonNull;
import androidx.camera.core.CameraSelector;
import androidx.camera.core.Logger;
import androidx.camera.core.Preview;
import androidx.camera.extensions.ExtensionVersion;
import androidx.camera.extensions.ExtensionsManager;
import androidx.camera.extensions.PreviewExtender;
import androidx.camera.extensions.impl.BokehPreviewExtenderImpl;
import androidx.camera.extensions.impl.PreviewExtenderImpl;

public class BokehPreviewExtender
extends PreviewExtender {
    private static final String TAG = "BokehPreviewExtender";

    @NonNull
    public static BokehPreviewExtender create(@NonNull Preview.Builder builder) {
        if (ExtensionVersion.isExtensionVersionSupported()) {
            try {
                return new VendorBokehPreviewExtender(builder);
            }
            catch (NoClassDefFoundError e) {
                Logger.d((String)TAG, (String)"No bokeh preview extender found. Falling back to default.");
            }
        }
        return new DefaultBokehPreviewExtender();
    }

    private BokehPreviewExtender() {
    }

    private static class VendorBokehPreviewExtender
    extends BokehPreviewExtender {
        private final BokehPreviewExtenderImpl mImpl = new BokehPreviewExtenderImpl();

        VendorBokehPreviewExtender(Preview.Builder builder) {
            this.init(builder, (PreviewExtenderImpl)this.mImpl, ExtensionsManager.EffectMode.BOKEH);
        }
    }

    private static class DefaultBokehPreviewExtender
    extends BokehPreviewExtender {
        DefaultBokehPreviewExtender() {
        }

        @Override
        public boolean isExtensionAvailable(@NonNull CameraSelector selector) {
            return false;
        }

        @Override
        public void enableExtension(@NonNull CameraSelector selector) {
        }
    }
}

