/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.extensions.internal;

import android.content.Context;
import android.hardware.camera2.CameraCharacteristics;
import android.util.Pair;
import android.util.Size;
import androidx.annotation.NonNull;
import androidx.annotation.experimental.UseExperimental;
import androidx.camera.camera2.impl.Camera2ImplConfig;
import androidx.camera.camera2.impl.CameraEventCallback;
import androidx.camera.camera2.impl.CameraEventCallbacks;
import androidx.camera.camera2.interop.Camera2CameraInfo;
import androidx.camera.camera2.interop.ExperimentalCamera2Interop;
import androidx.camera.core.CameraInfo;
import androidx.camera.core.ExtendableBuilder;
import androidx.camera.core.Preview;
import androidx.camera.core.UseCase;
import androidx.camera.core.impl.CaptureProcessor;
import androidx.camera.core.impl.ConfigProvider;
import androidx.camera.core.impl.ImageInfoProcessor;
import androidx.camera.core.impl.OptionsBundle;
import androidx.camera.core.impl.PreviewConfig;
import androidx.camera.extensions.PreviewExtender;
import androidx.camera.extensions.impl.AutoPreviewExtenderImpl;
import androidx.camera.extensions.impl.BeautyPreviewExtenderImpl;
import androidx.camera.extensions.impl.BokehPreviewExtenderImpl;
import androidx.camera.extensions.impl.HdrPreviewExtenderImpl;
import androidx.camera.extensions.impl.NightPreviewExtenderImpl;
import androidx.camera.extensions.impl.PreviewExtenderImpl;
import androidx.camera.extensions.impl.PreviewImageProcessorImpl;
import androidx.camera.extensions.internal.AdaptingPreviewProcessor;
import androidx.camera.extensions.internal.AdaptingRequestUpdateProcessor;
import java.util.List;

public class PreviewConfigProvider
implements ConfigProvider<PreviewConfig> {
    private PreviewExtenderImpl mImpl;
    private Context mContext;

    @UseExperimental(markerClass=ExperimentalCamera2Interop.class)
    public PreviewConfigProvider(int mode, @NonNull CameraInfo cameraInfo, @NonNull Context context) {
        try {
            switch (mode) {
                case 1: {
                    this.mImpl = new BokehPreviewExtenderImpl();
                    break;
                }
                case 2: {
                    this.mImpl = new HdrPreviewExtenderImpl();
                    break;
                }
                case 3: {
                    this.mImpl = new NightPreviewExtenderImpl();
                    break;
                }
                case 4: {
                    this.mImpl = new BeautyPreviewExtenderImpl();
                    break;
                }
                case 5: {
                    this.mImpl = new AutoPreviewExtenderImpl();
                    break;
                }
                default: {
                    return;
                }
            }
        }
        catch (NoClassDefFoundError e) {
            throw new IllegalArgumentException("Extension mode does not exist: " + mode);
        }
        this.mContext = context;
        String cameraId = Camera2CameraInfo.from((CameraInfo)cameraInfo).getCameraId();
        CameraCharacteristics cameraCharacteristics = Camera2CameraInfo.extractCameraCharacteristics((CameraInfo)cameraInfo);
        this.mImpl.init(cameraId, cameraCharacteristics);
    }

    @NonNull
    public PreviewConfig getConfig() {
        PreviewExtender.PreviewExtenderAdapter previewExtenderAdapter;
        if (this.mImpl == null) {
            return new PreviewConfig(OptionsBundle.emptyBundle());
        }
        Preview.Builder builder = new Preview.Builder();
        switch (this.mImpl.getProcessorType()) {
            case PROCESSOR_TYPE_REQUEST_UPDATE_ONLY: {
                AdaptingRequestUpdateProcessor adaptingRequestUpdateProcessor = new AdaptingRequestUpdateProcessor(this.mImpl);
                builder.setImageInfoProcessor((ImageInfoProcessor)adaptingRequestUpdateProcessor);
                previewExtenderAdapter = new PreviewExtender.PreviewExtenderAdapter(this.mImpl, this.mContext, adaptingRequestUpdateProcessor);
                break;
            }
            case PROCESSOR_TYPE_IMAGE_PROCESSOR: {
                AdaptingPreviewProcessor adaptingPreviewProcessor = new AdaptingPreviewProcessor((PreviewImageProcessorImpl)this.mImpl.getProcessor());
                builder.setCaptureProcessor((CaptureProcessor)adaptingPreviewProcessor);
                previewExtenderAdapter = new PreviewExtender.PreviewExtenderAdapter(this.mImpl, this.mContext, adaptingPreviewProcessor);
                break;
            }
            default: {
                previewExtenderAdapter = new PreviewExtender.PreviewExtenderAdapter(this.mImpl, this.mContext, null);
            }
        }
        new Camera2ImplConfig.Extender((ExtendableBuilder)builder).setCameraEventCallback(new CameraEventCallbacks(new CameraEventCallback[]{previewExtenderAdapter}));
        builder.setUseCaseEventCallback((UseCase.EventCallback)previewExtenderAdapter);
        List<Pair<Integer, Size[]>> supportedResolutions = PreviewExtender.getSupportedResolutions(this.mImpl);
        if (supportedResolutions != null) {
            builder.setSupportedResolutions(supportedResolutions);
        }
        return builder.getUseCaseConfig();
    }
}

