/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.extensions;

import android.hardware.camera2.CameraCharacteristics;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.OptIn;
import androidx.camera.camera2.interop.Camera2CameraInfo;
import androidx.camera.camera2.interop.ExperimentalCamera2Interop;
import androidx.camera.core.CameraFilter;
import androidx.camera.core.CameraInfo;
import androidx.camera.core.ExperimentalCameraFilter;
import androidx.camera.core.impl.CameraInfoInternal;
import androidx.camera.extensions.impl.ImageCaptureExtenderImpl;
import androidx.camera.extensions.impl.PreviewExtenderImpl;
import androidx.core.util.Preconditions;
import java.util.ArrayList;
import java.util.List;

@OptIn(markerClass={ExperimentalCameraFilter.class})
public final class ExtensionCameraFilter
implements CameraFilter {
    private final PreviewExtenderImpl mPreviewExtenderImpl;
    private final ImageCaptureExtenderImpl mImageCaptureExtenderImpl;

    ExtensionCameraFilter(@Nullable PreviewExtenderImpl previewExtenderImpl) {
        this.mPreviewExtenderImpl = previewExtenderImpl;
        this.mImageCaptureExtenderImpl = null;
    }

    ExtensionCameraFilter(@Nullable ImageCaptureExtenderImpl imageCaptureExtenderImpl) {
        this.mPreviewExtenderImpl = null;
        this.mImageCaptureExtenderImpl = imageCaptureExtenderImpl;
    }

    ExtensionCameraFilter(@Nullable PreviewExtenderImpl previewExtenderImpl, @Nullable ImageCaptureExtenderImpl imageCaptureExtenderImpl) {
        this.mPreviewExtenderImpl = previewExtenderImpl;
        this.mImageCaptureExtenderImpl = imageCaptureExtenderImpl;
    }

    @OptIn(markerClass={ExperimentalCamera2Interop.class})
    @NonNull
    public List<CameraInfo> filter(@NonNull List<CameraInfo> cameraInfos) {
        ArrayList<CameraInfo> result = new ArrayList<CameraInfo>();
        for (CameraInfo cameraInfo : cameraInfos) {
            Preconditions.checkArgument((boolean)(cameraInfo instanceof CameraInfoInternal), (Object)"The camera info doesn't contain internal implementation.");
            String cameraId = Camera2CameraInfo.from((CameraInfo)cameraInfo).getCameraId();
            CameraCharacteristics cameraCharacteristics = Camera2CameraInfo.extractCameraCharacteristics((CameraInfo)cameraInfo);
            boolean available = true;
            if (this.mPreviewExtenderImpl != null) {
                available = this.mPreviewExtenderImpl.isExtensionAvailable(cameraId, cameraCharacteristics);
            }
            if (this.mImageCaptureExtenderImpl != null) {
                available = this.mImageCaptureExtenderImpl.isExtensionAvailable(cameraId, cameraCharacteristics);
            }
            if (!available) continue;
            result.add(cameraInfo);
        }
        return result;
    }
}

