/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.extensions;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.OptIn;
import androidx.annotation.RestrictTo;
import androidx.camera.core.Camera;
import androidx.camera.core.CameraFilter;
import androidx.camera.core.CameraInfo;
import androidx.camera.core.CameraSelector;
import androidx.camera.core.ExperimentalCameraFilter;
import androidx.camera.core.UseCase;
import androidx.camera.core.impl.CameraConfig;
import androidx.camera.core.impl.CameraFilters;
import androidx.camera.core.impl.CameraInternal;
import androidx.camera.core.internal.CameraUseCaseAdapter;
import androidx.camera.extensions.ExtensionCameraFilter;
import androidx.camera.extensions.ExtensionsConfig;
import androidx.camera.extensions.impl.AutoImageCaptureExtenderImpl;
import androidx.camera.extensions.impl.AutoPreviewExtenderImpl;
import androidx.camera.extensions.impl.BeautyImageCaptureExtenderImpl;
import androidx.camera.extensions.impl.BeautyPreviewExtenderImpl;
import androidx.camera.extensions.impl.BokehImageCaptureExtenderImpl;
import androidx.camera.extensions.impl.BokehPreviewExtenderImpl;
import androidx.camera.extensions.impl.HdrImageCaptureExtenderImpl;
import androidx.camera.extensions.impl.HdrPreviewExtenderImpl;
import androidx.camera.extensions.impl.ImageCaptureExtenderImpl;
import androidx.camera.extensions.impl.NightImageCaptureExtenderImpl;
import androidx.camera.extensions.impl.NightPreviewExtenderImpl;
import androidx.camera.extensions.impl.PreviewExtenderImpl;
import androidx.camera.extensions.internal.ExtensionsUseCaseConfigFactory;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.LinkedHashSet;
import java.util.List;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class Extensions {
    private static final String TAG = "Extensions";
    public static final int EXTENSION_MODE_NONE = 0;
    public static final int EXTENSION_MODE_BOKEH = 1;
    public static final int EXTENSION_MODE_HDR = 2;
    public static final int EXTENSION_MODE_NIGHT = 3;
    public static final int EXTENSION_MODE_BEAUTY = 4;
    public static final int EXTENSION_MODE_AUTO = 5;
    private final Context mContext;

    Extensions(@NonNull Context context) {
        this.mContext = context;
    }

    @OptIn(markerClass={ExperimentalCameraFilter.class})
    public void setExtension(@NonNull Camera camera, int mode) {
        if (!this.isExtensionAvailable(camera, mode)) {
            throw new IllegalArgumentException("Extension mode not supported on camera: " + mode);
        }
        CameraSelector cameraSelector = new CameraSelector.Builder().addCameraFilter(this.getFilter(mode)).build();
        CameraInternal extensionCamera = cameraSelector.select(new LinkedHashSet(camera.getCameraInternals()));
        CameraInfo extensionsCameraInfo = extensionCamera.getCameraInfo();
        ExtensionsUseCaseConfigFactory factory = new ExtensionsUseCaseConfigFactory(mode, extensionsCameraInfo, this.mContext);
        ExtensionsConfig extensionsConfig = new ExtensionsConfig.Builder().setExtensionMode(mode).setCameraFilter(this.getFilter(mode)).setUseCaseConfigFactory(factory).build();
        try {
            camera.setExtendedConfig((CameraConfig)extensionsConfig);
        }
        catch (CameraUseCaseAdapter.CameraException e) {
            throw new IllegalArgumentException("Camera unable to support the extension with the attached UseCases. " + (Object)((Object)e));
        }
    }

    public int getExtension(@NonNull Camera camera) {
        CameraConfig extensionsConfigObject = camera.getExtendedConfig();
        if (extensionsConfigObject instanceof ExtensionsConfig) {
            ExtensionsConfig extensionsConfig = (ExtensionsConfig)extensionsConfigObject;
            return extensionsConfig.getExtensionMode();
        }
        return 0;
    }

    @OptIn(markerClass={ExperimentalCameraFilter.class})
    public boolean isExtensionAvailable(@NonNull Camera camera, int mode) {
        CameraSelector cameraSelector = new CameraSelector.Builder().addCameraFilter(this.getFilter(mode)).build();
        try {
            cameraSelector.select(new LinkedHashSet(camera.getCameraInternals()));
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }

    @OptIn(markerClass={ExperimentalCameraFilter.class})
    private CameraFilter getFilter(int mode) {
        CameraFilter filter;
        try {
            switch (mode) {
                case 1: {
                    filter = new ExtensionCameraFilter((PreviewExtenderImpl)new BokehPreviewExtenderImpl(), (ImageCaptureExtenderImpl)new BokehImageCaptureExtenderImpl());
                    break;
                }
                case 2: {
                    filter = new ExtensionCameraFilter((PreviewExtenderImpl)new HdrPreviewExtenderImpl(), (ImageCaptureExtenderImpl)new HdrImageCaptureExtenderImpl());
                    break;
                }
                case 3: {
                    filter = new ExtensionCameraFilter((PreviewExtenderImpl)new NightPreviewExtenderImpl(), (ImageCaptureExtenderImpl)new NightImageCaptureExtenderImpl());
                    break;
                }
                case 4: {
                    filter = new ExtensionCameraFilter((PreviewExtenderImpl)new BeautyPreviewExtenderImpl(), (ImageCaptureExtenderImpl)new BeautyImageCaptureExtenderImpl());
                    break;
                }
                case 5: {
                    filter = new ExtensionCameraFilter((PreviewExtenderImpl)new AutoPreviewExtenderImpl(), (ImageCaptureExtenderImpl)new AutoImageCaptureExtenderImpl());
                    break;
                }
                default: {
                    filter = CameraFilters.ANY;
                    break;
                }
            }
        }
        catch (NoClassDefFoundError e) {
            filter = CameraFilters.NONE;
        }
        return filter;
    }

    @NonNull
    public List<List<UseCase>> checkUseCases(@NonNull Camera camera, @NonNull List<UseCase> useCases, int mode) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface ExtensionMode {
    }
}

