/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.extensions;

import android.content.Context;
import android.hardware.camera2.CameraCharacteristics;
import android.os.Build;
import android.util.Pair;
import android.util.Size;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.OptIn;
import androidx.annotation.RestrictTo;
import androidx.camera.camera2.impl.Camera2ImplConfig;
import androidx.camera.camera2.impl.CameraEventCallback;
import androidx.camera.camera2.impl.CameraEventCallbacks;
import androidx.camera.camera2.interop.Camera2CameraInfo;
import androidx.camera.camera2.interop.ExperimentalCamera2Interop;
import androidx.camera.core.CameraFilter;
import androidx.camera.core.CameraInfo;
import androidx.camera.core.CameraSelector;
import androidx.camera.core.CameraX;
import androidx.camera.core.ExperimentalCameraFilter;
import androidx.camera.core.ExtendableBuilder;
import androidx.camera.core.Logger;
import androidx.camera.core.Preview;
import androidx.camera.core.UseCase;
import androidx.camera.core.impl.CaptureConfig;
import androidx.camera.core.impl.CaptureProcessor;
import androidx.camera.core.impl.Config;
import androidx.camera.core.impl.ImageInfoProcessor;
import androidx.camera.extensions.CameraUtil;
import androidx.camera.extensions.ExtensionCameraFilter;
import androidx.camera.extensions.ExtensionVersion;
import androidx.camera.extensions.ExtensionsErrorListener;
import androidx.camera.extensions.ExtensionsManager;
import androidx.camera.extensions.ImageCaptureExtender;
import androidx.camera.extensions.Version;
import androidx.camera.extensions.impl.CaptureStageImpl;
import androidx.camera.extensions.impl.PreviewExtenderImpl;
import androidx.camera.extensions.impl.PreviewImageProcessorImpl;
import androidx.camera.extensions.internal.AdaptingCaptureStage;
import androidx.camera.extensions.internal.AdaptingPreviewProcessor;
import androidx.camera.extensions.internal.AdaptingRequestUpdateProcessor;
import androidx.core.util.Consumer;
import java.util.Collection;
import java.util.List;

public abstract class PreviewExtender {
    private static final String TAG = "PreviewExtender";
    static final Config.Option<Integer> OPTION_PREVIEW_EXTENDER_MODE = Config.Option.create((String)"camerax.extensions.previewExtender.mode", Integer.class);
    private Preview.Builder mBuilder;
    private PreviewExtenderImpl mImpl;
    private int mEffectMode;
    private ExtensionCameraFilter mExtensionCameraFilter;

    @OptIn(markerClass={ExperimentalCameraFilter.class})
    void init(Preview.Builder builder, PreviewExtenderImpl implementation, int effectMode) {
        this.mBuilder = builder;
        this.mImpl = implementation;
        this.mEffectMode = effectMode;
        this.mExtensionCameraFilter = new ExtensionCameraFilter(this.mImpl);
    }

    public boolean isExtensionAvailable(@NonNull CameraSelector cameraSelector) {
        return this.getCameraWithExtension(cameraSelector) != null;
    }

    @OptIn(markerClass={ExperimentalCameraFilter.class})
    private String getCameraWithExtension(@NonNull CameraSelector cameraSelector) {
        CameraSelector.Builder extensionCameraSelectorBuilder = CameraSelector.Builder.fromSelector((CameraSelector)cameraSelector);
        extensionCameraSelectorBuilder.addCameraFilter((CameraFilter)this.mExtensionCameraFilter);
        return CameraUtil.getCameraIdUnchecked(extensionCameraSelectorBuilder.build());
    }

    @OptIn(markerClass={ExperimentalCameraFilter.class})
    public void enableExtension(@NonNull CameraSelector cameraSelector) {
        String cameraId = this.getCameraWithExtension(cameraSelector);
        if (cameraId == null) {
            return;
        }
        CameraSelector originalSelector = this.mBuilder.getUseCaseConfig().getCameraSelector(null);
        if (originalSelector == null) {
            this.mBuilder.setCameraSelector(new CameraSelector.Builder().addCameraFilter((CameraFilter)this.mExtensionCameraFilter).build());
        } else {
            this.mBuilder.setCameraSelector(CameraSelector.Builder.fromSelector((CameraSelector)originalSelector).addCameraFilter((CameraFilter)this.mExtensionCameraFilter).build());
        }
        CameraCharacteristics cameraCharacteristics = CameraUtil.getCameraCharacteristics(cameraId);
        this.mImpl.init(cameraId, cameraCharacteristics);
        Context context = CameraX.getContext();
        PreviewExtender.updateBuilderConfig(this.mBuilder, this.mEffectMode, this.mImpl, context);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static void updateBuilderConfig(@NonNull Preview.Builder builder, int effectMode, @NonNull PreviewExtenderImpl impl, @NonNull Context context) {
        PreviewExtenderAdapter previewExtenderAdapter;
        switch (impl.getProcessorType()) {
            case PROCESSOR_TYPE_REQUEST_UPDATE_ONLY: {
                AdaptingRequestUpdateProcessor adaptingRequestUpdateProcessor = new AdaptingRequestUpdateProcessor(impl);
                builder.setImageInfoProcessor((ImageInfoProcessor)adaptingRequestUpdateProcessor);
                previewExtenderAdapter = new PreviewExtenderAdapter(impl, context, adaptingRequestUpdateProcessor);
                break;
            }
            case PROCESSOR_TYPE_IMAGE_PROCESSOR: {
                AdaptingPreviewProcessor adaptingPreviewProcessor = new AdaptingPreviewProcessor((PreviewImageProcessorImpl)impl.getProcessor());
                builder.setCaptureProcessor((CaptureProcessor)adaptingPreviewProcessor);
                previewExtenderAdapter = new PreviewExtenderAdapter(impl, context, adaptingPreviewProcessor);
                break;
            }
            default: {
                previewExtenderAdapter = new PreviewExtenderAdapter(impl, context, null);
            }
        }
        new Camera2ImplConfig.Extender((ExtendableBuilder)builder).setCameraEventCallback(new CameraEventCallbacks(new CameraEventCallback[]{previewExtenderAdapter}));
        builder.setUseCaseEventCallback((UseCase.EventCallback)previewExtenderAdapter);
        try {
            Consumer attachedUseCasesUpdateListener = useCases -> PreviewExtender.checkImageCaptureEnabled(effectMode, useCases);
            builder.setAttachedUseCasesUpdateListener(attachedUseCasesUpdateListener);
        }
        catch (NoSuchMethodError e) {
            Logger.e((String)TAG, (String)"Can't set attached use cases update listener.");
        }
        builder.getMutableConfig().insertOption(OPTION_PREVIEW_EXTENDER_MODE, (Object)effectMode);
        List<Pair<Integer, Size[]>> supportedResolutions = PreviewExtender.getSupportedResolutions(impl);
        if (supportedResolutions != null) {
            builder.setSupportedResolutions(supportedResolutions);
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @Nullable
    public static List<Pair<Integer, Size[]>> getSupportedResolutions(@NonNull PreviewExtenderImpl impl) {
        if (ExtensionVersion.getRuntimeVersion().compareTo(Version.VERSION_1_1) < 0) {
            return null;
        }
        try {
            return impl.getSupportedResolutions();
        }
        catch (NoSuchMethodError e) {
            Logger.e((String)TAG, (String)"getSupportedResolution interface is not implemented in vendor library.");
            return null;
        }
    }

    static void checkImageCaptureEnabled(int effectMode, Collection<UseCase> activeUseCases) {
        boolean isImageCaptureExtenderEnabled = false;
        boolean isMismatched = false;
        if (activeUseCases == null || activeUseCases.isEmpty()) {
            return;
        }
        for (UseCase useCase : activeUseCases) {
            int imageCaptureExtenderMode = (Integer)useCase.getCurrentConfig().retrieveOption(ImageCaptureExtender.OPTION_IMAGE_CAPTURE_EXTENDER_MODE, (Object)0);
            if (effectMode == imageCaptureExtenderMode) {
                isImageCaptureExtenderEnabled = true;
                continue;
            }
            if (imageCaptureExtenderMode == 0) continue;
            isMismatched = true;
        }
        if (isMismatched) {
            ExtensionsManager.postExtensionsError(ExtensionsErrorListener.ExtensionsErrorCode.MISMATCHED_EXTENSIONS_ENABLED);
        } else if (!isImageCaptureExtenderEnabled) {
            ExtensionsManager.postExtensionsError(ExtensionsErrorListener.ExtensionsErrorCode.IMAGE_CAPTURE_EXTENSION_REQUIRED);
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static interface CloseableProcessor {
        public void close();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static class PreviewExtenderAdapter
    extends CameraEventCallback
    implements UseCase.EventCallback {
        @NonNull
        final PreviewExtenderImpl mImpl;
        @NonNull
        private final Context mContext;
        final CloseableProcessor mCloseableProcessor;
        @GuardedBy(value="mLock")
        volatile boolean mActive = true;
        final Object mLock = new Object();
        @GuardedBy(value="mLock")
        private volatile int mEnabledSessionCount = 0;
        @GuardedBy(value="mLock")
        private volatile boolean mUnbind = false;

        public PreviewExtenderAdapter(@NonNull PreviewExtenderImpl impl, @NonNull Context context, @Nullable CloseableProcessor closeableProcessor) {
            this.mImpl = impl;
            this.mContext = context;
            this.mCloseableProcessor = closeableProcessor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @OptIn(markerClass={ExperimentalCamera2Interop.class})
        public void onAttach(@NonNull CameraInfo cameraInfo) {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mActive) {
                    String cameraId = Camera2CameraInfo.from((CameraInfo)cameraInfo).getCameraId();
                    CameraCharacteristics cameraCharacteristics = Camera2CameraInfo.extractCameraCharacteristics((CameraInfo)cameraInfo);
                    this.mImpl.onInit(cameraId, cameraCharacteristics, this.mContext);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onDetach() {
            Object object = this.mLock;
            synchronized (object) {
                this.mUnbind = true;
                if (this.mEnabledSessionCount == 0) {
                    this.callDeInit();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void callDeInit() {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mActive) {
                    if (this.mCloseableProcessor != null) {
                        this.mCloseableProcessor.close();
                    }
                    this.mImpl.onDeInit();
                    this.mActive = false;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public CaptureConfig onPresetSession() {
            Object object = this.mLock;
            synchronized (object) {
                CaptureStageImpl captureStageImpl = this.mImpl.onPresetSession();
                if (captureStageImpl != null) {
                    if (Build.VERSION.SDK_INT >= 28) {
                        return new AdaptingCaptureStage(captureStageImpl).getCaptureConfig();
                    }
                    Logger.w((String)PreviewExtender.TAG, (String)"The CaptureRequest parameters returned from onPresetSession() will be passed to the camera device as part of the capture session via SessionConfiguration#setSessionParameters(CaptureRequest) which only supported from API level 28!");
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Nullable
        public CaptureConfig onEnableSession() {
            Object object;
            block12: {
                CaptureConfig captureConfig;
                try {
                    CaptureStageImpl captureStageImpl;
                    object = this.mLock;
                    // MONITORENTER : object
                    if (!this.mActive || (captureStageImpl = this.mImpl.onEnableSession()) == null) break block12;
                    captureConfig = new AdaptingCaptureStage(captureStageImpl).getCaptureConfig();
                    // MONITOREXIT : object
                    Object object2 = this.mLock;
                }
                catch (Throwable throwable) {
                    Object object3 = this.mLock;
                    // MONITORENTER : object3
                    ++this.mEnabledSessionCount;
                    // MONITOREXIT : object3
                    throw throwable;
                }
                ++this.mEnabledSessionCount;
                // MONITOREXIT : object2
                return captureConfig;
            }
            // MONITOREXIT : object
            object = null;
            Object object4 = this.mLock;
            ++this.mEnabledSessionCount;
            // MONITOREXIT : object4
            return object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Nullable
        public CaptureConfig onDisableSession() {
            Object object;
            block15: {
                CaptureConfig captureConfig;
                try {
                    CaptureStageImpl captureStageImpl;
                    object = this.mLock;
                    // MONITORENTER : object
                    if (!this.mActive || (captureStageImpl = this.mImpl.onDisableSession()) == null) break block15;
                    captureConfig = new AdaptingCaptureStage(captureStageImpl).getCaptureConfig();
                    // MONITOREXIT : object
                    Object object2 = this.mLock;
                }
                catch (Throwable throwable) {
                    Object object3 = this.mLock;
                    // MONITORENTER : object3
                    --this.mEnabledSessionCount;
                    if (this.mEnabledSessionCount == 0 && this.mUnbind) {
                        this.callDeInit();
                    }
                    // MONITOREXIT : object3
                    throw throwable;
                }
                --this.mEnabledSessionCount;
                if (this.mEnabledSessionCount == 0 && this.mUnbind) {
                    this.callDeInit();
                }
                // MONITOREXIT : object2
                return captureConfig;
            }
            // MONITOREXIT : object
            object = null;
            Object object4 = this.mLock;
            --this.mEnabledSessionCount;
            if (this.mEnabledSessionCount == 0 && this.mUnbind) {
                this.callDeInit();
            }
            // MONITOREXIT : object4
            return object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public CaptureConfig onRepeating() {
            Object object = this.mLock;
            synchronized (object) {
                CaptureStageImpl captureStageImpl;
                if (this.mActive && (captureStageImpl = this.mImpl.getCaptureStage()) != null) {
                    return new AdaptingCaptureStage(captureStageImpl).getCaptureConfig();
                }
            }
            return null;
        }
    }
}

