/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.extensions.internal;

import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.TotalCaptureResult;
import android.media.Image;
import android.util.Size;
import android.view.Surface;
import androidx.annotation.NonNull;
import androidx.camera.camera2.impl.Camera2CameraCaptureResultConverter;
import androidx.camera.core.ExperimentalGetImage;
import androidx.camera.core.ImageInfo;
import androidx.camera.core.ImageProxy;
import androidx.camera.core.Logger;
import androidx.camera.core.impl.CameraCaptureResult;
import androidx.camera.core.impl.CameraCaptureResults;
import androidx.camera.core.impl.CaptureProcessor;
import androidx.camera.core.impl.ImageProxyBundle;
import androidx.camera.extensions.PreviewExtender;
import androidx.camera.extensions.impl.PreviewImageProcessorImpl;
import androidx.camera.extensions.internal.BlockingCloseAccessCounter;
import androidx.core.util.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.concurrent.ExecutionException;

public final class AdaptingPreviewProcessor
implements CaptureProcessor,
PreviewExtender.CloseableProcessor {
    private static final String TAG = "AdaptingPreviewProcesso";
    private final PreviewImageProcessorImpl mImpl;
    private BlockingCloseAccessCounter mAccessCounter = new BlockingCloseAccessCounter();

    public AdaptingPreviewProcessor(@NonNull PreviewImageProcessorImpl impl) {
        this.mImpl = impl;
    }

    public void onOutputSurface(@NonNull Surface surface, int imageFormat) {
        if (!this.mAccessCounter.tryIncrement()) {
            return;
        }
        try {
            this.mImpl.onOutputSurface(surface, imageFormat);
            this.mImpl.onImageFormatUpdate(35);
        }
        finally {
            this.mAccessCounter.decrement();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExperimentalGetImage
    public void process(@NonNull ImageProxyBundle bundle) {
        ImageProxy imageProxy;
        List ids = bundle.getCaptureIds();
        Preconditions.checkArgument((ids.size() == 1 ? 1 : 0) != 0, (Object)("Processing preview bundle must be 1, but found " + ids.size()));
        ListenableFuture imageProxyListenableFuture = bundle.getImageProxy(((Integer)ids.get(0)).intValue());
        Preconditions.checkArgument((boolean)imageProxyListenableFuture.isDone());
        try {
            imageProxy = (ImageProxy)imageProxyListenableFuture.get();
        }
        catch (InterruptedException | ExecutionException e) {
            Logger.e((String)TAG, (String)"Unable to retrieve ImageProxy from bundle");
            return;
        }
        Image image = imageProxy.getImage();
        ImageInfo imageInfo = imageProxy.getImageInfo();
        CameraCaptureResult result = CameraCaptureResults.retrieveCameraCaptureResult((ImageInfo)imageInfo);
        CaptureResult captureResult = Camera2CameraCaptureResultConverter.getCaptureResult((CameraCaptureResult)result);
        TotalCaptureResult totalCaptureResult = null;
        if (captureResult instanceof TotalCaptureResult) {
            totalCaptureResult = (TotalCaptureResult)captureResult;
        }
        if (image == null) {
            return;
        }
        if (!this.mAccessCounter.tryIncrement()) {
            return;
        }
        try {
            this.mImpl.process(image, totalCaptureResult);
        }
        finally {
            this.mAccessCounter.decrement();
        }
    }

    public void onResolutionUpdate(@NonNull Size size) {
        if (!this.mAccessCounter.tryIncrement()) {
            return;
        }
        try {
            this.mImpl.onResolutionUpdate(size);
        }
        finally {
            this.mAccessCounter.decrement();
        }
    }

    @Override
    public void close() {
        this.mAccessCounter.destroyAndWaitForZeroAccess();
    }
}

