/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video;

import android.util.Range;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.camera.video.AutoValue_AudioSpec;
import com.google.auto.value.AutoValue;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

@RequiresApi(value=21)
@RestrictTo(value={RestrictTo.Scope.LIBRARY})
@AutoValue
public abstract class AudioSpec {
    public static final int SOURCE_FORMAT_AUTO = -1;
    public static final int SOURCE_FORMAT_PCM_16BIT = 2;
    public static final int CHANNEL_COUNT_AUTO = -1;
    public static final int CHANNEL_COUNT_NONE = 0;
    public static final int CHANNEL_COUNT_MONO = 1;
    public static final int CHANNEL_COUNT_STEREO = 2;
    public static final int SOURCE_AUTO = -1;
    public static final int SOURCE_CAMCORDER = 5;
    @NonNull
    public static final Range<Integer> BITRATE_RANGE_AUTO = new Range((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(Integer.MAX_VALUE));
    @NonNull
    public static final Range<Integer> SAMPLE_RATE_RANGE_AUTO = new Range((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(Integer.MAX_VALUE));
    public static final AudioSpec NO_AUDIO = AudioSpec.builder().setChannelCount(0).build();

    AudioSpec() {
    }

    @NonNull
    public static Builder builder() {
        return new AutoValue_AudioSpec.Builder().setSourceFormat(-1).setSource(-1).setChannelCount(-1).setBitrate(BITRATE_RANGE_AUTO).setSampleRate(SAMPLE_RATE_RANGE_AUTO);
    }

    @NonNull
    public abstract Range<Integer> getBitrate();

    public abstract int getSourceFormat();

    public abstract int getSource();

    @NonNull
    public abstract Range<Integer> getSampleRate();

    public abstract int getChannelCount();

    @NonNull
    public abstract Builder toBuilder();

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @AutoValue.Builder
    public static abstract class Builder {
        Builder() {
        }

        @NonNull
        public abstract Builder setBitrate(@NonNull Range<Integer> var1);

        @NonNull
        public abstract Builder setSourceFormat(int var1);

        @NonNull
        public abstract Builder setSource(int var1);

        @NonNull
        public abstract Builder setSampleRate(@NonNull Range<Integer> var1);

        @NonNull
        public abstract Builder setChannelCount(int var1);

        @NonNull
        public abstract AudioSpec build();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static @interface Source {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static @interface ChannelCount {
    }
}

