/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video.internal.encoder;

import android.media.MediaFormat;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.camera.core.impl.Timebase;
import androidx.camera.video.internal.encoder.AutoValue_AudioEncoderConfig;
import androidx.camera.video.internal.encoder.EncoderConfig;
import com.google.auto.value.AutoValue;
import java.util.Objects;

@RequiresApi(value=21)
@AutoValue
public abstract class AudioEncoderConfig
implements EncoderConfig {
    AudioEncoderConfig() {
    }

    @NonNull
    public static Builder builder() {
        return new AutoValue_AudioEncoderConfig.Builder().setProfile(-1);
    }

    @Override
    @NonNull
    public abstract String getMimeType();

    @Override
    public abstract int getProfile();

    @Override
    @NonNull
    public abstract Timebase getInputTimebase();

    public abstract int getBitrate();

    public abstract int getSampleRate();

    public abstract int getChannelCount();

    @Override
    @NonNull
    public MediaFormat toMediaFormat() {
        MediaFormat mediaFormat = MediaFormat.createAudioFormat((String)this.getMimeType(), (int)this.getSampleRate(), (int)this.getChannelCount());
        mediaFormat.setInteger("bitrate", this.getBitrate());
        if (this.getProfile() != -1) {
            if (this.getMimeType().equals("audio/mp4a-latm")) {
                mediaFormat.setInteger("aac-profile", this.getProfile());
            } else {
                mediaFormat.setInteger("profile", this.getProfile());
            }
        }
        return mediaFormat;
    }

    @AutoValue.Builder
    public static abstract class Builder {
        Builder() {
        }

        @NonNull
        public abstract Builder setMimeType(@NonNull String var1);

        @NonNull
        public abstract Builder setProfile(int var1);

        @NonNull
        public abstract Builder setInputTimebase(@NonNull Timebase var1);

        @NonNull
        public abstract Builder setBitrate(int var1);

        @NonNull
        public abstract Builder setSampleRate(int var1);

        @NonNull
        public abstract Builder setChannelCount(int var1);

        @NonNull
        abstract AudioEncoderConfig autoBuild();

        @NonNull
        public AudioEncoderConfig build() {
            AudioEncoderConfig config = this.autoBuild();
            if (Objects.equals(config.getMimeType(), "audio/mp4a-latm") && config.getProfile() == -1) {
                throw new IllegalArgumentException("Encoder mime set to AAC, but no AAC profile was provided.");
            }
            return config;
        }
    }
}

