/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video;

import android.util.Range;
import androidx.annotation.NonNull;
import androidx.camera.video.AudioSpec;

final class AutoValue_AudioSpec
extends AudioSpec {
    private final Range<Integer> bitrate;
    private final int sourceFormat;
    private final int source;
    private final Range<Integer> sampleRate;
    private final int channelCount;

    private AutoValue_AudioSpec(Range<Integer> bitrate, int sourceFormat, int source, Range<Integer> sampleRate, int channelCount) {
        this.bitrate = bitrate;
        this.sourceFormat = sourceFormat;
        this.source = source;
        this.sampleRate = sampleRate;
        this.channelCount = channelCount;
    }

    @Override
    @NonNull
    public Range<Integer> getBitrate() {
        return this.bitrate;
    }

    @Override
    public int getSourceFormat() {
        return this.sourceFormat;
    }

    @Override
    public int getSource() {
        return this.source;
    }

    @Override
    @NonNull
    public Range<Integer> getSampleRate() {
        return this.sampleRate;
    }

    @Override
    public int getChannelCount() {
        return this.channelCount;
    }

    public String toString() {
        return "AudioSpec{bitrate=" + this.bitrate + ", sourceFormat=" + this.sourceFormat + ", source=" + this.source + ", sampleRate=" + this.sampleRate + ", channelCount=" + this.channelCount + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AudioSpec) {
            AudioSpec that = (AudioSpec)o;
            return this.bitrate.equals(that.getBitrate()) && this.sourceFormat == that.getSourceFormat() && this.source == that.getSource() && this.sampleRate.equals(that.getSampleRate()) && this.channelCount == that.getChannelCount();
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.bitrate.hashCode();
        h$ *= 1000003;
        h$ ^= this.sourceFormat;
        h$ *= 1000003;
        h$ ^= this.source;
        h$ *= 1000003;
        h$ ^= this.sampleRate.hashCode();
        h$ *= 1000003;
        return h$ ^= this.channelCount;
    }

    @Override
    public AudioSpec.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends AudioSpec.Builder {
        private Range<Integer> bitrate;
        private Integer sourceFormat;
        private Integer source;
        private Range<Integer> sampleRate;
        private Integer channelCount;

        Builder() {
        }

        private Builder(AudioSpec source) {
            this.bitrate = source.getBitrate();
            this.sourceFormat = source.getSourceFormat();
            this.source = source.getSource();
            this.sampleRate = source.getSampleRate();
            this.channelCount = source.getChannelCount();
        }

        @Override
        public AudioSpec.Builder setBitrate(Range<Integer> bitrate) {
            if (bitrate == null) {
                throw new NullPointerException("Null bitrate");
            }
            this.bitrate = bitrate;
            return this;
        }

        @Override
        public AudioSpec.Builder setSourceFormat(int sourceFormat) {
            this.sourceFormat = sourceFormat;
            return this;
        }

        @Override
        public AudioSpec.Builder setSource(int source) {
            this.source = source;
            return this;
        }

        @Override
        public AudioSpec.Builder setSampleRate(Range<Integer> sampleRate) {
            if (sampleRate == null) {
                throw new NullPointerException("Null sampleRate");
            }
            this.sampleRate = sampleRate;
            return this;
        }

        @Override
        public AudioSpec.Builder setChannelCount(int channelCount) {
            this.channelCount = channelCount;
            return this;
        }

        @Override
        public AudioSpec build() {
            String missing = "";
            if (this.bitrate == null) {
                missing = missing + " bitrate";
            }
            if (this.sourceFormat == null) {
                missing = missing + " sourceFormat";
            }
            if (this.source == null) {
                missing = missing + " source";
            }
            if (this.sampleRate == null) {
                missing = missing + " sampleRate";
            }
            if (this.channelCount == null) {
                missing = missing + " channelCount";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_AudioSpec(this.bitrate, this.sourceFormat, this.source, this.sampleRate, this.channelCount);
        }
    }
}

