/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video;

import android.location.Location;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.core.util.Preconditions;

@RequiresApi(value=21)
public abstract class OutputOptions {
    public static final int FILE_SIZE_UNLIMITED = 0;
    public static final int DURATION_UNLIMITED = 0;
    private final OutputOptionsInternal mOutputOptionsInternal;

    OutputOptions(@NonNull OutputOptionsInternal outputOptionsInternal) {
        this.mOutputOptionsInternal = outputOptionsInternal;
    }

    @IntRange(from=0L)
    public long getFileSizeLimit() {
        return this.mOutputOptionsInternal.getFileSizeLimit();
    }

    @Nullable
    public Location getLocation() {
        return this.mOutputOptionsInternal.getLocation();
    }

    @IntRange(from=0L)
    public long getDurationLimitMillis() {
        return this.mOutputOptionsInternal.getDurationLimitMillis();
    }

    static abstract class OutputOptionsInternal {
        OutputOptionsInternal() {
        }

        @IntRange(from=0L)
        abstract long getFileSizeLimit();

        @IntRange(from=0L)
        abstract long getDurationLimitMillis();

        @Nullable
        abstract Location getLocation();

        static abstract class Builder<B> {
            Builder() {
            }

            @NonNull
            abstract B setFileSizeLimit(@IntRange(from=0L) long var1);

            @NonNull
            abstract B setDurationLimitMillis(@IntRange(from=0L) long var1);

            @NonNull
            abstract B setLocation(@Nullable Location var1);

            @NonNull
            abstract OutputOptionsInternal build();
        }
    }

    static abstract class Builder<T extends OutputOptions, B> {
        final OutputOptionsInternal.Builder<?> mRootInternalBuilder;

        Builder(@NonNull OutputOptionsInternal.Builder<?> builder) {
            this.mRootInternalBuilder = builder;
            this.mRootInternalBuilder.setFileSizeLimit(0L);
            this.mRootInternalBuilder.setDurationLimitMillis(0L);
        }

        @NonNull
        public B setFileSizeLimit(@IntRange(from=0L) long fileSizeLimitBytes) {
            Preconditions.checkArgument((fileSizeLimitBytes >= 0L ? 1 : 0) != 0, (Object)"The specified file size limit can't be negative.");
            this.mRootInternalBuilder.setFileSizeLimit(fileSizeLimitBytes);
            return (B)this;
        }

        @NonNull
        public B setDurationLimitMillis(@IntRange(from=0L) long durationLimitMillis) {
            Preconditions.checkArgument((durationLimitMillis >= 0L ? 1 : 0) != 0, (Object)"The specified duration limit can't be negative.");
            this.mRootInternalBuilder.setDurationLimitMillis(durationLimitMillis);
            return (B)this;
        }

        @NonNull
        public B setLocation(@Nullable Location location) {
            if (location != null) {
                Preconditions.checkArgument((location.getLatitude() >= -90.0 && location.getLatitude() <= 90.0 ? 1 : 0) != 0, (Object)"Latitude must be in the range [-90, 90]");
                Preconditions.checkArgument((location.getLongitude() >= -180.0 && location.getLongitude() <= 180.0 ? 1 : 0) != 0, (Object)"Longitude must be in the range [-180, 180]");
            }
            this.mRootInternalBuilder.setLocation(location);
            return (B)this;
        }

        @NonNull
        abstract T build();
    }
}

