/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video;

import android.util.Range;
import android.util.Rational;
import android.util.Size;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.camera.core.impl.utils.AspectRatioUtil;
import androidx.camera.core.internal.utils.SizeUtil;
import androidx.camera.video.AutoValue_QualityRatioToResolutionsTable_QualityRatio;
import androidx.camera.video.Quality;
import com.google.auto.value.AutoValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@RequiresApi(value=21)
class QualityRatioToResolutionsTable {
    private static final Map<Quality, Range<Integer>> sQualityRangeMap = new HashMap<Quality, Range<Integer>>();
    private static final Map<Integer, Rational> sAspectRatioMap;
    private final Map<QualityRatio, List<Size>> mTable = new HashMap<QualityRatio, List<Size>>();

    QualityRatioToResolutionsTable(@NonNull List<Size> resolutions, @NonNull Map<Quality, Size> profileQualityToSizeMap) {
        for (Quality quality : sQualityRangeMap.keySet()) {
            this.mTable.put(QualityRatio.of(quality, -1), new ArrayList());
            for (Integer aspectRatio : sAspectRatioMap.keySet()) {
                this.mTable.put(QualityRatio.of(quality, aspectRatio), new ArrayList());
            }
        }
        this.addProfileSizesToTable(profileQualityToSizeMap);
        this.addResolutionsToTable(resolutions);
        this.sortQualityRatioRow(profileQualityToSizeMap);
    }

    @NonNull
    List<Size> getResolutions(@NonNull Quality quality, int aspectRatio) {
        List<Size> qualityRatioRow = this.getQualityRatioRow(quality, aspectRatio);
        return qualityRatioRow != null ? new ArrayList<Size>(qualityRatioRow) : new ArrayList(0);
    }

    private void addProfileSizesToTable(@NonNull Map<Quality, Size> profileQualityToSizeMap) {
        for (Map.Entry<Quality, Size> entry : profileQualityToSizeMap.entrySet()) {
            Objects.requireNonNull(this.getQualityRatioRow(entry.getKey(), -1)).add(entry.getValue());
        }
    }

    private void addResolutionsToTable(@NonNull List<Size> resolutions) {
        for (Size resolution : resolutions) {
            Integer aspectRatio;
            Quality quality = QualityRatioToResolutionsTable.findMappedQuality(resolution);
            if (quality == null || (aspectRatio = QualityRatioToResolutionsTable.findMappedAspectRatio(resolution)) == null) continue;
            List<Size> qualityRatioRow = Objects.requireNonNull(this.getQualityRatioRow(quality, aspectRatio));
            qualityRatioRow.add(resolution);
        }
    }

    private void sortQualityRatioRow(@NonNull Map<Quality, Size> profileQualityToSizeMap) {
        for (Map.Entry<QualityRatio, List<Size>> entry : this.mTable.entrySet()) {
            Size profileSize = profileQualityToSizeMap.get(entry.getKey().getQuality());
            if (profileSize == null) continue;
            int qualitySizeArea = SizeUtil.getArea((Size)profileSize);
            Collections.sort(entry.getValue(), (s1, s2) -> {
                int s1Diff = Math.abs(SizeUtil.getArea((Size)s1) - qualitySizeArea);
                int s2Diff = Math.abs(SizeUtil.getArea((Size)s2) - qualitySizeArea);
                return s1Diff - s2Diff;
            });
        }
    }

    @Nullable
    private static Quality findMappedQuality(@NonNull Size resolution) {
        for (Map.Entry<Quality, Range<Integer>> entry : sQualityRangeMap.entrySet()) {
            if (!entry.getValue().contains((Comparable)Integer.valueOf(resolution.getHeight()))) continue;
            return entry.getKey();
        }
        return null;
    }

    @Nullable
    private static Integer findMappedAspectRatio(@NonNull Size resolution) {
        for (Map.Entry<Integer, Rational> entry : sAspectRatioMap.entrySet()) {
            if (!AspectRatioUtil.hasMatchingAspectRatio((Size)resolution, (Rational)entry.getValue(), (Size)SizeUtil.RESOLUTION_QVGA)) continue;
            return entry.getKey();
        }
        return null;
    }

    @Nullable
    private List<Size> getQualityRatioRow(@NonNull Quality quality, int aspectRatio) {
        return this.mTable.get(QualityRatio.of(quality, aspectRatio));
    }

    static {
        sQualityRangeMap.put(Quality.UHD, (Range<Integer>)Range.create((Comparable)Integer.valueOf(2160), (Comparable)Integer.valueOf(4319)));
        sQualityRangeMap.put(Quality.FHD, (Range<Integer>)Range.create((Comparable)Integer.valueOf(1080), (Comparable)Integer.valueOf(1439)));
        sQualityRangeMap.put(Quality.HD, (Range<Integer>)Range.create((Comparable)Integer.valueOf(720), (Comparable)Integer.valueOf(1079)));
        sQualityRangeMap.put(Quality.SD, (Range<Integer>)Range.create((Comparable)Integer.valueOf(241), (Comparable)Integer.valueOf(719)));
        sAspectRatioMap = new HashMap<Integer, Rational>();
        sAspectRatioMap.put(0, AspectRatioUtil.ASPECT_RATIO_4_3);
        sAspectRatioMap.put(1, AspectRatioUtil.ASPECT_RATIO_16_9);
    }

    @AutoValue
    static abstract class QualityRatio {
        QualityRatio() {
        }

        static QualityRatio of(@NonNull Quality quality, int aspectRatio) {
            return new AutoValue_QualityRatioToResolutionsTable_QualityRatio(quality, aspectRatio);
        }

        @NonNull
        abstract Quality getQuality();

        abstract int getAspectRatio();
    }
}

