/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video.internal;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.camera.core.DynamicRange;
import androidx.camera.core.impl.EncoderProfilesProvider;
import androidx.camera.core.impl.EncoderProfilesProxy;
import androidx.camera.video.internal.utils.DynamicRangeUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

@RequiresApi(value=21)
public class DynamicRangeMatchedEncoderProfilesProvider
implements EncoderProfilesProvider {
    private final EncoderProfilesProvider mEncoderProfilesProvider;
    private final DynamicRange mDynamicRange;
    private final Map<Integer, EncoderProfilesProxy> mEncoderProfilesCache = new HashMap<Integer, EncoderProfilesProxy>();

    public DynamicRangeMatchedEncoderProfilesProvider(@NonNull EncoderProfilesProvider provider, @NonNull DynamicRange dynamicRange) {
        this.mEncoderProfilesProvider = provider;
        this.mDynamicRange = dynamicRange;
    }

    public boolean hasProfile(int quality) {
        if (!this.mEncoderProfilesProvider.hasProfile(quality)) {
            return false;
        }
        return this.getProfilesInternal(quality) != null;
    }

    @Nullable
    public EncoderProfilesProxy getAll(int quality) {
        return this.getProfilesInternal(quality);
    }

    @Nullable
    private EncoderProfilesProxy getProfilesInternal(int quality) {
        if (this.mEncoderProfilesCache.containsKey(quality)) {
            return this.mEncoderProfilesCache.get(quality);
        }
        EncoderProfilesProxy profiles = null;
        if (this.mEncoderProfilesProvider.hasProfile(quality)) {
            EncoderProfilesProxy baseProfiles = this.mEncoderProfilesProvider.getAll(quality);
            profiles = DynamicRangeMatchedEncoderProfilesProvider.filterUnmatchedDynamicRange(baseProfiles, this.mDynamicRange);
            this.mEncoderProfilesCache.put(quality, profiles);
        }
        return profiles;
    }

    @Nullable
    private static EncoderProfilesProxy filterUnmatchedDynamicRange(@Nullable EncoderProfilesProxy encoderProfiles, @NonNull DynamicRange dynamicRange) {
        if (encoderProfiles == null) {
            return null;
        }
        ArrayList<EncoderProfilesProxy.VideoProfileProxy> validVideoProfiles = new ArrayList<EncoderProfilesProxy.VideoProfileProxy>();
        for (EncoderProfilesProxy.VideoProfileProxy videoProfile : encoderProfiles.getVideoProfiles()) {
            if (!DynamicRangeMatchedEncoderProfilesProvider.isBitDepthMatched(videoProfile, dynamicRange) || !DynamicRangeMatchedEncoderProfilesProvider.isHdrEncodingMatched(videoProfile, dynamicRange)) continue;
            validVideoProfiles.add(videoProfile);
        }
        return validVideoProfiles.isEmpty() ? null : EncoderProfilesProxy.ImmutableEncoderProfilesProxy.create((int)encoderProfiles.getDefaultDurationSeconds(), (int)encoderProfiles.getRecommendedFileFormat(), (List)encoderProfiles.getAudioProfiles(), validVideoProfiles);
    }

    private static boolean isBitDepthMatched(@NonNull EncoderProfilesProxy.VideoProfileProxy videoProfile, @NonNull DynamicRange dynamicRange) {
        Set<Integer> matchedBitDepths = DynamicRangeUtil.DR_TO_VP_BIT_DEPTH_MAP.get(dynamicRange.getBitDepth());
        return matchedBitDepths != null && matchedBitDepths.contains(videoProfile.getBitDepth());
    }

    private static boolean isHdrEncodingMatched(@NonNull EncoderProfilesProxy.VideoProfileProxy videoProfile, @NonNull DynamicRange dynamicRange) {
        Set<Integer> matchedHdrEncodings = DynamicRangeUtil.DR_TO_VP_FORMAT_MAP.get(dynamicRange.getEncoding());
        return matchedHdrEncodings != null && matchedHdrEncodings.contains(videoProfile.getHdrFormat());
    }
}

