/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video.internal.compat.quirk;

import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.camera.core.impl.CameraInfoInternal;
import androidx.camera.video.Quality;
import androidx.camera.video.internal.compat.quirk.VideoQualityQuirk;

@RequiresApi(value=21)
public class ExcludeStretchedVideoQualityQuirk
implements VideoQualityQuirk {
    static boolean load() {
        return ExcludeStretchedVideoQualityQuirk.isSamsungJ4() || ExcludeStretchedVideoQualityQuirk.isSamsungJ7PrimeApi27Above() || ExcludeStretchedVideoQualityQuirk.isSamsungJ7Api27Above();
    }

    private static boolean isSamsungJ4() {
        return "Samsung".equalsIgnoreCase(Build.BRAND) && "SM-J400G".equalsIgnoreCase(Build.MODEL);
    }

    private static boolean isSamsungJ7PrimeApi27Above() {
        return "Samsung".equalsIgnoreCase(Build.BRAND) && "SM-G610M".equalsIgnoreCase(Build.MODEL) && Build.VERSION.SDK_INT >= 27;
    }

    private static boolean isSamsungJ7Api27Above() {
        return "Samsung".equalsIgnoreCase(Build.BRAND) && "SM-J710MN".equalsIgnoreCase(Build.MODEL) && Build.VERSION.SDK_INT >= 27;
    }

    @Override
    public boolean isProblematicVideoQuality(@NonNull CameraInfoInternal cameraInfo, @NonNull Quality quality) {
        if (ExcludeStretchedVideoQualityQuirk.isSamsungJ4()) {
            return quality == Quality.FHD || quality == Quality.UHD;
        }
        if (ExcludeStretchedVideoQualityQuirk.isSamsungJ7PrimeApi27Above() || ExcludeStretchedVideoQualityQuirk.isSamsungJ7Api27Above()) {
            return quality == Quality.FHD;
        }
        return false;
    }
}

