/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video.internal.config;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.core.impl.EncoderProfilesProxy;
import androidx.camera.video.internal.config.AudioMimeInfo;

final class AutoValue_AudioMimeInfo
extends AudioMimeInfo {
    private final String mimeType;
    private final int profile;
    private final EncoderProfilesProxy.AudioProfileProxy compatibleAudioProfile;

    private AutoValue_AudioMimeInfo(String mimeType, int profile, @Nullable EncoderProfilesProxy.AudioProfileProxy compatibleAudioProfile) {
        this.mimeType = mimeType;
        this.profile = profile;
        this.compatibleAudioProfile = compatibleAudioProfile;
    }

    @Override
    @NonNull
    public String getMimeType() {
        return this.mimeType;
    }

    @Override
    public int getProfile() {
        return this.profile;
    }

    @Override
    @Nullable
    public EncoderProfilesProxy.AudioProfileProxy getCompatibleAudioProfile() {
        return this.compatibleAudioProfile;
    }

    public String toString() {
        return "AudioMimeInfo{mimeType=" + this.mimeType + ", profile=" + this.profile + ", compatibleAudioProfile=" + this.compatibleAudioProfile + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AudioMimeInfo) {
            AudioMimeInfo that = (AudioMimeInfo)o;
            return this.mimeType.equals(that.getMimeType()) && this.profile == that.getProfile() && (this.compatibleAudioProfile == null ? that.getCompatibleAudioProfile() == null : this.compatibleAudioProfile.equals(that.getCompatibleAudioProfile()));
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.mimeType.hashCode();
        h$ *= 1000003;
        h$ ^= this.profile;
        h$ *= 1000003;
        return h$ ^= this.compatibleAudioProfile == null ? 0 : this.compatibleAudioProfile.hashCode();
    }

    static final class Builder
    extends AudioMimeInfo.Builder {
        private String mimeType;
        private Integer profile;
        private EncoderProfilesProxy.AudioProfileProxy compatibleAudioProfile;

        Builder() {
        }

        @Override
        protected AudioMimeInfo.Builder setMimeType(String mimeType) {
            if (mimeType == null) {
                throw new NullPointerException("Null mimeType");
            }
            this.mimeType = mimeType;
            return this;
        }

        @Override
        public AudioMimeInfo.Builder setProfile(int profile) {
            this.profile = profile;
            return this;
        }

        @Override
        public AudioMimeInfo.Builder setCompatibleAudioProfile(@Nullable EncoderProfilesProxy.AudioProfileProxy compatibleAudioProfile) {
            this.compatibleAudioProfile = compatibleAudioProfile;
            return this;
        }

        @Override
        public AudioMimeInfo build() {
            String missing = "";
            if (this.mimeType == null) {
                missing = missing + " mimeType";
            }
            if (this.profile == null) {
                missing = missing + " profile";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_AudioMimeInfo(this.mimeType, this.profile, this.compatibleAudioProfile);
        }
    }
}

