/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video.internal.workaround;

import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.media.MediaFormat;
import android.os.Build;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import androidx.camera.core.Logger;
import androidx.camera.video.internal.DebugUtils;
import androidx.camera.video.internal.compat.quirk.DeviceQuirks;
import androidx.camera.video.internal.compat.quirk.MediaCodecInfoReportIncorrectInfoQuirk;
import androidx.camera.video.internal.compat.quirk.MediaFormatMustNotUseFrameRateToFindEncoderQuirk;
import androidx.camera.video.internal.encoder.InvalidConfigException;
import androidx.core.util.Preconditions;
import java.io.IOException;

@RequiresApi(value=21)
public class EncoderFinder {
    private static final String TAG = "EncoderFinder";
    private final boolean mShouldRemoveKeyFrameRate;

    public EncoderFinder() {
        MediaFormatMustNotUseFrameRateToFindEncoderQuirk quirk = DeviceQuirks.get(MediaFormatMustNotUseFrameRateToFindEncoderQuirk.class);
        this.mShouldRemoveKeyFrameRate = quirk != null;
    }

    @NonNull
    public MediaCodec findEncoder(@NonNull MediaFormat mediaFormat) throws InvalidConfigException {
        MediaCodec codec;
        MediaCodecList mediaCodecList = new MediaCodecList(1);
        String encoderName = this.findEncoderForFormat(mediaFormat, mediaCodecList);
        try {
            if (TextUtils.isEmpty((CharSequence)encoderName)) {
                String mimeType = mediaFormat.getString("mime");
                codec = MediaCodec.createEncoderByType((String)mimeType);
                String msg = DebugUtils.dumpCodecCapabilities(mimeType, codec, mediaFormat);
                Logger.w((String)TAG, (String)String.format("No encoder found that supports requested MediaFormat %s. Create encoder by MIME type. Dump codec info:\n%s", mediaFormat, msg));
            } else {
                codec = MediaCodec.createByCodecName((String)encoderName);
            }
        }
        catch (IOException | IllegalArgumentException | NullPointerException e) {
            boolean isMediaFormatInQuirk = this.shouldCreateCodecByType(mediaFormat);
            String msg = DebugUtils.dumpMediaCodecListForFormat(mediaCodecList, mediaFormat);
            throw new InvalidConfigException("Encoder cannot created: " + encoderName + ", isMediaFormatInQuirk: " + isMediaFormatInQuirk + "\n" + msg, e);
        }
        return codec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    @Nullable
    String findEncoderForFormat(@NonNull MediaFormat mediaFormat, @NonNull MediaCodecList mediaCodecList) {
        Integer tempFrameRate = null;
        Integer tempAacProfile = null;
        try {
            String name;
            if (this.mShouldRemoveKeyFrameRate && mediaFormat.containsKey("frame-rate")) {
                tempFrameRate = mediaFormat.getInteger("frame-rate");
                mediaFormat.setString("frame-rate", null);
            }
            if (Build.VERSION.SDK_INT <= 23 && mediaFormat.containsKey("aac-profile")) {
                tempAacProfile = mediaFormat.getInteger("aac-profile");
                mediaFormat.setString("aac-profile", null);
            }
            if ((name = mediaCodecList.findEncoderForFormat(mediaFormat)) == null) {
                name = this.findEncoderWithNearestCompatibleBitrate(mediaFormat, mediaCodecList.getCodecInfos());
            }
            String string = name;
            return string;
        }
        finally {
            if (tempFrameRate != null) {
                mediaFormat.setInteger("frame-rate", tempFrameRate.intValue());
            }
            if (tempAacProfile != null) {
                mediaFormat.setInteger("aac-profile", tempAacProfile.intValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private String findEncoderWithNearestCompatibleBitrate(@NonNull MediaFormat mediaFormat, @NonNull MediaCodecInfo[] codecInfoList) {
        String mime = mediaFormat.getString("mime");
        if (mime == null) {
            Logger.w((String)TAG, (String)"MediaFormat does not contain mime info.");
            return null;
        }
        for (MediaCodecInfo info : codecInfoList) {
            if (!info.isEncoder()) continue;
            Integer origBitrate = null;
            try {
                MediaCodecInfo.CodecCapabilities caps = info.getCapabilitiesForType(mime);
                Preconditions.checkArgument((caps != null ? 1 : 0) != 0, (Object)"MIME type is not supported");
                int newBitrate = -1;
                if (mediaFormat.containsKey("bitrate")) {
                    MediaCodecInfo.VideoCapabilities videoCaps = caps.getVideoCapabilities();
                    Preconditions.checkArgument((videoCaps != null ? 1 : 0) != 0, (Object)"Not video codec");
                    origBitrate = mediaFormat.getInteger("bitrate");
                    newBitrate = (Integer)videoCaps.getBitrateRange().clamp((Comparable)origBitrate);
                    mediaFormat.setInteger("bitrate", newBitrate);
                }
                if (!caps.isFormatSupported(mediaFormat)) continue;
                Logger.w((String)TAG, (String)String.format("No encoder found that supports requested bitrate. Adjusting bitrate to nearest supported bitrate [requested: %dbps, nearest: %dbps]", origBitrate, newBitrate));
                String string = info.getName();
                return string;
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            finally {
                if (origBitrate != null) {
                    mediaFormat.setInteger("bitrate", origBitrate.intValue());
                }
            }
        }
        return null;
    }

    private boolean shouldCreateCodecByType(@NonNull MediaFormat mediaFormat) {
        MediaCodecInfoReportIncorrectInfoQuirk quirk = DeviceQuirks.get(MediaCodecInfoReportIncorrectInfoQuirk.class);
        if (quirk == null) {
            return false;
        }
        return quirk.isUnSupportMediaCodecInfo(mediaFormat);
    }
}

