/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.view;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Matrix;
import android.os.Build;
import android.util.Size;
import androidx.annotation.DoNotInline;
import androidx.annotation.FloatRange;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.OptIn;
import androidx.annotation.RequiresApi;
import androidx.annotation.RequiresPermission;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.arch.core.util.Function;
import androidx.camera.core.Camera;
import androidx.camera.core.CameraControl;
import androidx.camera.core.CameraEffect;
import androidx.camera.core.CameraInfo;
import androidx.camera.core.CameraInfoUnavailableException;
import androidx.camera.core.CameraSelector;
import androidx.camera.core.FocusMeteringAction;
import androidx.camera.core.FocusMeteringResult;
import androidx.camera.core.ImageAnalysis;
import androidx.camera.core.ImageCapture;
import androidx.camera.core.Logger;
import androidx.camera.core.MeteringPoint;
import androidx.camera.core.MeteringPointFactory;
import androidx.camera.core.Preview;
import androidx.camera.core.UseCase;
import androidx.camera.core.UseCaseGroup;
import androidx.camera.core.ViewPort;
import androidx.camera.core.ZoomState;
import androidx.camera.core.impl.ImageOutputConfig;
import androidx.camera.core.impl.utils.Threads;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import androidx.camera.core.impl.utils.futures.FutureCallback;
import androidx.camera.core.impl.utils.futures.Futures;
import androidx.camera.lifecycle.ProcessCameraProvider;
import androidx.camera.video.FileDescriptorOutputOptions;
import androidx.camera.video.FileOutputOptions;
import androidx.camera.video.MediaStoreOutputOptions;
import androidx.camera.video.OutputOptions;
import androidx.camera.video.PendingRecording;
import androidx.camera.video.QualitySelector;
import androidx.camera.video.Recorder;
import androidx.camera.video.Recording;
import androidx.camera.video.VideoCapture;
import androidx.camera.video.VideoOutput;
import androidx.camera.video.VideoRecordEvent;
import androidx.camera.view.ForwardingLiveData;
import androidx.camera.view.PendingValue;
import androidx.camera.view.ProcessCameraProviderWrapper;
import androidx.camera.view.ProcessCameraProviderWrapperImpl;
import androidx.camera.view.RotationProvider;
import androidx.camera.view.TransformExperimental;
import androidx.camera.view.video.AudioConfig;
import androidx.core.content.ContextCompat;
import androidx.core.content.PermissionChecker;
import androidx.core.util.Consumer;
import androidx.core.util.Preconditions;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import com.google.common.util.concurrent.ListenableFuture;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;

@RequiresApi(value=21)
public abstract class CameraController {
    private static final String TAG = "CameraController";
    private static final String CAMERA_NOT_INITIALIZED = "Camera not initialized.";
    private static final String PREVIEW_VIEW_NOT_ATTACHED = "PreviewView not attached to CameraController.";
    private static final String CAMERA_NOT_ATTACHED = "Use cases not attached to camera.";
    private static final String IMAGE_CAPTURE_DISABLED = "ImageCapture disabled.";
    private static final String VIDEO_CAPTURE_DISABLED = "VideoCapture disabled.";
    private static final String VIDEO_RECORDING_UNFINISHED = "Recording video. Only one recording can be active at a time.";
    private static final float AF_SIZE = 0.16666667f;
    private static final float AE_SIZE = 0.25f;
    public static final int COORDINATE_SYSTEM_VIEW_REFERENCED = 1;
    public static final int TAP_TO_FOCUS_NOT_STARTED = 0;
    public static final int TAP_TO_FOCUS_STARTED = 1;
    public static final int TAP_TO_FOCUS_FOCUSED = 2;
    public static final int TAP_TO_FOCUS_NOT_FOCUSED = 3;
    public static final int TAP_TO_FOCUS_FAILED = 4;
    public static final int IMAGE_CAPTURE = 1;
    public static final int IMAGE_ANALYSIS = 2;
    public static final int VIDEO_CAPTURE = 4;
    CameraSelector mCameraSelector = CameraSelector.DEFAULT_BACK_CAMERA;
    private int mEnabledUseCases = 3;
    @NonNull
    Preview mPreview;
    @Nullable
    OutputSize mPreviewTargetSize;
    @NonNull
    ImageCapture mImageCapture;
    @Nullable
    OutputSize mImageCaptureTargetSize;
    @Nullable
    Executor mImageCaptureIoExecutor;
    @Nullable
    private Executor mAnalysisExecutor;
    @Nullable
    private Executor mAnalysisBackgroundExecutor;
    @Nullable
    private ImageAnalysis.Analyzer mAnalysisAnalyzer;
    @NonNull
    ImageAnalysis mImageAnalysis;
    @Nullable
    OutputSize mImageAnalysisTargetSize;
    @NonNull
    VideoCapture<Recorder> mVideoCapture;
    @Nullable
    Recording mActiveRecording = null;
    @NonNull
    Map<Consumer<VideoRecordEvent>, Recording> mRecordingMap = new HashMap<Consumer<VideoRecordEvent>, Recording>();
    @NonNull
    QualitySelector mVideoCaptureQualitySelector = Recorder.DEFAULT_QUALITY_SELECTOR;
    @Nullable
    Camera mCamera;
    @Nullable
    ProcessCameraProviderWrapper mCameraProvider;
    @Nullable
    ViewPort mViewPort;
    @Nullable
    Preview.SurfaceProvider mSurfaceProvider;
    private final RotationProvider mRotationProvider;
    @VisibleForTesting
    @NonNull
    final RotationProvider.Listener mDeviceRotationListener;
    private boolean mPinchToZoomEnabled = true;
    private boolean mTapToFocusEnabled = true;
    private final ForwardingLiveData<ZoomState> mZoomState = new ForwardingLiveData();
    private final ForwardingLiveData<Integer> mTorchState = new ForwardingLiveData();
    final MutableLiveData<Integer> mTapToFocusState = new MutableLiveData((Object)0);
    @NonNull
    private final PendingValue<Boolean> mPendingEnableTorch = new PendingValue();
    @NonNull
    private final PendingValue<Float> mPendingLinearZoom = new PendingValue();
    @NonNull
    private final PendingValue<Float> mPendingZoomRatio = new PendingValue();
    @NonNull
    private final Set<CameraEffect> mEffects = new HashSet<CameraEffect>();
    private final Context mAppContext;
    @NonNull
    private final ListenableFuture<Void> mInitializationFuture;

    CameraController(@NonNull Context context) {
        this(context, (ListenableFuture<ProcessCameraProviderWrapper>)Futures.transform((ListenableFuture)ProcessCameraProvider.getInstance((Context)context), ProcessCameraProviderWrapperImpl::new, (Executor)CameraXExecutors.directExecutor()));
    }

    CameraController(@NonNull Context context, @NonNull ListenableFuture<ProcessCameraProviderWrapper> cameraProviderFuture) {
        this.mAppContext = CameraController.getApplicationContext(context);
        this.mPreview = new Preview.Builder().build();
        this.mImageCapture = new ImageCapture.Builder().build();
        this.mImageAnalysis = new ImageAnalysis.Builder().build();
        this.mVideoCapture = this.createNewVideoCapture();
        this.mInitializationFuture = Futures.transform(cameraProviderFuture, provider -> {
            this.mCameraProvider = provider;
            this.startCameraAndTrackStates();
            return null;
        }, (Executor)CameraXExecutors.mainThreadExecutor());
        this.mRotationProvider = new RotationProvider(this.mAppContext);
        this.mDeviceRotationListener = rotation -> {
            this.mImageAnalysis.setTargetRotation(rotation);
            this.mImageCapture.setTargetRotation(rotation);
            this.mVideoCapture.setTargetRotation(rotation);
        };
    }

    private static Recorder generateVideoCaptureRecorder(@NonNull QualitySelector qualitySelector) {
        return new Recorder.Builder().setQualitySelector(qualitySelector).build();
    }

    private static Context getApplicationContext(@NonNull Context context) {
        String attributeTag;
        Context applicationContext = context.getApplicationContext();
        if (Build.VERSION.SDK_INT >= 30 && (attributeTag = Api30Impl.getAttributionTag(context)) != null) {
            return Api30Impl.createAttributionContext(applicationContext, attributeTag);
        }
        return applicationContext;
    }

    @NonNull
    public ListenableFuture<Void> getInitializationFuture() {
        return this.mInitializationFuture;
    }

    @Nullable
    abstract Camera startCamera();

    private boolean isCameraInitialized() {
        return this.mCameraProvider != null;
    }

    private boolean isPreviewViewAttached() {
        return this.mSurfaceProvider != null && this.mViewPort != null;
    }

    private boolean isCameraAttached() {
        return this.mCamera != null;
    }

    @MainThread
    public void setEnabledUseCases(int enabledUseCases) {
        Threads.checkMainThread();
        if (enabledUseCases == this.mEnabledUseCases) {
            return;
        }
        int oldEnabledUseCases = this.mEnabledUseCases;
        this.mEnabledUseCases = enabledUseCases;
        if (!this.isVideoCaptureEnabled() && this.isRecording()) {
            this.stopRecording();
        }
        this.startCameraAndTrackStates(() -> {
            this.mEnabledUseCases = oldEnabledUseCases;
        });
    }

    private boolean isUseCaseEnabled(int useCaseMask) {
        return (this.mEnabledUseCases & useCaseMask) != 0;
    }

    private void setTargetOutputSize(@NonNull ImageOutputConfig.Builder<?> builder, @Nullable OutputSize outputSize) {
        if (outputSize == null) {
            return;
        }
        if (outputSize.getResolution() != null) {
            builder.setTargetResolution(outputSize.getResolution());
        } else if (outputSize.getAspectRatio() != -1) {
            builder.setTargetAspectRatio(outputSize.getAspectRatio());
        } else {
            Logger.e((String)TAG, (String)("Invalid target surface size. " + outputSize));
        }
    }

    private boolean isOutputSizeEqual(@Nullable OutputSize currentSize, @Nullable OutputSize newSize) {
        if (currentSize == newSize) {
            return true;
        }
        return currentSize != null && currentSize.equals(newSize);
    }

    @SuppressLint(value={"MissingPermission", "WrongConstant"})
    @MainThread
    void attachPreviewSurface(@NonNull Preview.SurfaceProvider surfaceProvider, @NonNull ViewPort viewPort) {
        Threads.checkMainThread();
        if (this.mSurfaceProvider != surfaceProvider) {
            this.mSurfaceProvider = surfaceProvider;
            this.mPreview.setSurfaceProvider(surfaceProvider);
        }
        this.mViewPort = viewPort;
        this.startListeningToRotationEvents();
        this.startCameraAndTrackStates();
    }

    @MainThread
    void clearPreviewSurface() {
        Threads.checkMainThread();
        if (this.mCameraProvider != null) {
            this.mCameraProvider.unbind(new UseCase[]{this.mPreview, this.mImageCapture, this.mImageAnalysis, this.mVideoCapture});
        }
        this.mPreview.setSurfaceProvider(null);
        this.mCamera = null;
        this.mSurfaceProvider = null;
        this.mViewPort = null;
        this.stopListeningToRotationEvents();
    }

    private void startListeningToRotationEvents() {
        this.mRotationProvider.addListener(CameraXExecutors.mainThreadExecutor(), this.mDeviceRotationListener);
    }

    private void stopListeningToRotationEvents() {
        this.mRotationProvider.removeListener(this.mDeviceRotationListener);
    }

    @MainThread
    public void setPreviewTargetSize(@Nullable OutputSize targetSize) {
        Threads.checkMainThread();
        if (this.isOutputSizeEqual(this.mPreviewTargetSize, targetSize)) {
            return;
        }
        this.mPreviewTargetSize = targetSize;
        this.unbindPreviewAndRecreate();
        this.startCameraAndTrackStates();
    }

    @MainThread
    @Nullable
    public OutputSize getPreviewTargetSize() {
        Threads.checkMainThread();
        return this.mPreviewTargetSize;
    }

    private void unbindPreviewAndRecreate() {
        if (this.isCameraInitialized()) {
            this.mCameraProvider.unbind(new UseCase[]{this.mPreview});
        }
        Preview.Builder builder = new Preview.Builder();
        this.setTargetOutputSize((ImageOutputConfig.Builder<?>)builder, this.mPreviewTargetSize);
        this.mPreview = builder.build();
    }

    @MainThread
    public boolean isImageCaptureEnabled() {
        Threads.checkMainThread();
        return this.isUseCaseEnabled(1);
    }

    @MainThread
    public int getImageCaptureFlashMode() {
        Threads.checkMainThread();
        return this.mImageCapture.getFlashMode();
    }

    @MainThread
    public void setImageCaptureFlashMode(int flashMode) {
        Threads.checkMainThread();
        this.mImageCapture.setFlashMode(flashMode);
    }

    @MainThread
    public void takePicture(@NonNull ImageCapture.OutputFileOptions outputFileOptions, @NonNull Executor executor, @NonNull ImageCapture.OnImageSavedCallback imageSavedCallback) {
        Threads.checkMainThread();
        Preconditions.checkState((boolean)this.isCameraInitialized(), (String)CAMERA_NOT_INITIALIZED);
        Preconditions.checkState((boolean)this.isImageCaptureEnabled(), (String)IMAGE_CAPTURE_DISABLED);
        this.updateMirroringFlagInOutputFileOptions(outputFileOptions);
        this.mImageCapture.takePicture(outputFileOptions, executor, imageSavedCallback);
    }

    @VisibleForTesting
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    void updateMirroringFlagInOutputFileOptions(@NonNull ImageCapture.OutputFileOptions outputFileOptions) {
        if (this.mCameraSelector.getLensFacing() != null && !outputFileOptions.getMetadata().isReversedHorizontalSet()) {
            outputFileOptions.getMetadata().setReversedHorizontal(this.mCameraSelector.getLensFacing() == 0);
        }
    }

    @MainThread
    public void takePicture(@NonNull Executor executor, @NonNull ImageCapture.OnImageCapturedCallback callback) {
        Threads.checkMainThread();
        Preconditions.checkState((boolean)this.isCameraInitialized(), (String)CAMERA_NOT_INITIALIZED);
        Preconditions.checkState((boolean)this.isImageCaptureEnabled(), (String)IMAGE_CAPTURE_DISABLED);
        this.mImageCapture.takePicture(executor, callback);
    }

    @MainThread
    public void setImageCaptureMode(int captureMode) {
        Threads.checkMainThread();
        if (this.mImageCapture.getCaptureMode() == captureMode) {
            return;
        }
        this.unbindImageCaptureAndRecreate(captureMode);
        this.startCameraAndTrackStates();
    }

    @MainThread
    public int getImageCaptureMode() {
        Threads.checkMainThread();
        return this.mImageCapture.getCaptureMode();
    }

    @MainThread
    public void setImageCaptureTargetSize(@Nullable OutputSize targetSize) {
        Threads.checkMainThread();
        if (this.isOutputSizeEqual(this.mImageCaptureTargetSize, targetSize)) {
            return;
        }
        this.mImageCaptureTargetSize = targetSize;
        this.unbindImageCaptureAndRecreate(this.getImageCaptureMode());
        this.startCameraAndTrackStates();
    }

    @MainThread
    @Nullable
    public OutputSize getImageCaptureTargetSize() {
        Threads.checkMainThread();
        return this.mImageCaptureTargetSize;
    }

    @MainThread
    public void setImageCaptureIoExecutor(@Nullable Executor executor) {
        Threads.checkMainThread();
        if (this.mImageCaptureIoExecutor == executor) {
            return;
        }
        this.mImageCaptureIoExecutor = executor;
        this.unbindImageCaptureAndRecreate(this.mImageCapture.getCaptureMode());
        this.startCameraAndTrackStates();
    }

    @MainThread
    @Nullable
    public Executor getImageCaptureIoExecutor() {
        Threads.checkMainThread();
        return this.mImageCaptureIoExecutor;
    }

    private void unbindImageCaptureAndRecreate(int imageCaptureMode) {
        if (this.isCameraInitialized()) {
            this.mCameraProvider.unbind(new UseCase[]{this.mImageCapture});
        }
        ImageCapture.Builder builder = new ImageCapture.Builder().setCaptureMode(imageCaptureMode);
        this.setTargetOutputSize((ImageOutputConfig.Builder<?>)builder, this.mImageCaptureTargetSize);
        if (this.mImageCaptureIoExecutor != null) {
            builder.setIoExecutor(this.mImageCaptureIoExecutor);
        }
        this.mImageCapture = builder.build();
    }

    @MainThread
    public boolean isImageAnalysisEnabled() {
        Threads.checkMainThread();
        return this.isUseCaseEnabled(2);
    }

    @MainThread
    public void setImageAnalysisAnalyzer(@NonNull Executor executor, @NonNull ImageAnalysis.Analyzer analyzer) {
        Threads.checkMainThread();
        if (this.mAnalysisAnalyzer == analyzer && this.mAnalysisExecutor == executor) {
            return;
        }
        ImageAnalysis.Analyzer oldAnalyzer = this.mAnalysisAnalyzer;
        this.mAnalysisExecutor = executor;
        this.mAnalysisAnalyzer = analyzer;
        this.mImageAnalysis.setAnalyzer(executor, analyzer);
        this.restartCameraIfAnalyzerResolutionChanged(oldAnalyzer, analyzer);
    }

    @MainThread
    public void clearImageAnalysisAnalyzer() {
        Threads.checkMainThread();
        ImageAnalysis.Analyzer oldAnalyzer = this.mAnalysisAnalyzer;
        this.mAnalysisExecutor = null;
        this.mAnalysisAnalyzer = null;
        this.mImageAnalysis.clearAnalyzer();
        this.restartCameraIfAnalyzerResolutionChanged(oldAnalyzer, null);
    }

    private void restartCameraIfAnalyzerResolutionChanged(@Nullable ImageAnalysis.Analyzer oldAnalyzer, @Nullable ImageAnalysis.Analyzer newAnalyzer) {
        Size newResolution;
        Size oldResolution = oldAnalyzer == null ? null : oldAnalyzer.getDefaultTargetResolution();
        Size size = newResolution = newAnalyzer == null ? null : newAnalyzer.getDefaultTargetResolution();
        if (!Objects.equals(oldResolution, newResolution)) {
            this.unbindImageAnalysisAndRecreate(this.mImageAnalysis.getBackpressureStrategy(), this.mImageAnalysis.getImageQueueDepth());
            this.startCameraAndTrackStates();
        }
    }

    @MainThread
    public int getImageAnalysisBackpressureStrategy() {
        Threads.checkMainThread();
        return this.mImageAnalysis.getBackpressureStrategy();
    }

    @MainThread
    public void setImageAnalysisBackpressureStrategy(int strategy) {
        Threads.checkMainThread();
        if (this.mImageAnalysis.getBackpressureStrategy() == strategy) {
            return;
        }
        this.unbindImageAnalysisAndRecreate(strategy, this.mImageAnalysis.getImageQueueDepth());
        this.startCameraAndTrackStates();
    }

    @MainThread
    public void setImageAnalysisImageQueueDepth(int depth) {
        Threads.checkMainThread();
        if (this.mImageAnalysis.getImageQueueDepth() == depth) {
            return;
        }
        this.unbindImageAnalysisAndRecreate(this.mImageAnalysis.getBackpressureStrategy(), depth);
        this.startCameraAndTrackStates();
    }

    @MainThread
    public int getImageAnalysisImageQueueDepth() {
        Threads.checkMainThread();
        return this.mImageAnalysis.getImageQueueDepth();
    }

    @MainThread
    public void setImageAnalysisTargetSize(@Nullable OutputSize targetSize) {
        Threads.checkMainThread();
        if (this.isOutputSizeEqual(this.mImageAnalysisTargetSize, targetSize)) {
            return;
        }
        this.mImageAnalysisTargetSize = targetSize;
        this.unbindImageAnalysisAndRecreate(this.mImageAnalysis.getBackpressureStrategy(), this.mImageAnalysis.getImageQueueDepth());
        this.startCameraAndTrackStates();
    }

    @MainThread
    @Nullable
    public OutputSize getImageAnalysisTargetSize() {
        Threads.checkMainThread();
        return this.mImageAnalysisTargetSize;
    }

    @MainThread
    public void setImageAnalysisBackgroundExecutor(@Nullable Executor executor) {
        Threads.checkMainThread();
        if (this.mAnalysisBackgroundExecutor == executor) {
            return;
        }
        this.mAnalysisBackgroundExecutor = executor;
        this.unbindImageAnalysisAndRecreate(this.mImageAnalysis.getBackpressureStrategy(), this.mImageAnalysis.getImageQueueDepth());
        this.startCameraAndTrackStates();
    }

    @MainThread
    @Nullable
    public Executor getImageAnalysisBackgroundExecutor() {
        Threads.checkMainThread();
        return this.mAnalysisBackgroundExecutor;
    }

    @MainThread
    private void unbindImageAnalysisAndRecreate(int strategy, int imageQueueDepth) {
        Threads.checkMainThread();
        if (this.isCameraInitialized()) {
            this.mCameraProvider.unbind(new UseCase[]{this.mImageAnalysis});
        }
        ImageAnalysis.Builder builder = new ImageAnalysis.Builder().setBackpressureStrategy(strategy).setImageQueueDepth(imageQueueDepth);
        this.setTargetOutputSize((ImageOutputConfig.Builder<?>)builder, this.mImageAnalysisTargetSize);
        if (this.mAnalysisBackgroundExecutor != null) {
            builder.setBackgroundExecutor(this.mAnalysisBackgroundExecutor);
        }
        this.mImageAnalysis = builder.build();
        if (this.mAnalysisExecutor != null && this.mAnalysisAnalyzer != null) {
            this.mImageAnalysis.setAnalyzer(this.mAnalysisExecutor, this.mAnalysisAnalyzer);
        }
    }

    @OptIn(markerClass={TransformExperimental.class})
    @MainThread
    void updatePreviewViewTransform(@Nullable Matrix matrix) {
        Threads.checkMainThread();
        if (this.mAnalysisAnalyzer == null) {
            return;
        }
        if (this.mAnalysisAnalyzer.getTargetCoordinateSystem() == 1) {
            this.mAnalysisAnalyzer.updateTransform(matrix);
        }
    }

    @MainThread
    public boolean isVideoCaptureEnabled() {
        Threads.checkMainThread();
        return this.isUseCaseEnabled(4);
    }

    @SuppressLint(value={"MissingPermission"})
    @MainThread
    @NonNull
    public Recording startRecording(@NonNull FileOutputOptions outputOptions, @NonNull AudioConfig audioConfig, @NonNull Executor executor, @NonNull Consumer<VideoRecordEvent> listener) {
        return this.startRecordingInternal((OutputOptions)outputOptions, audioConfig, executor, listener);
    }

    @SuppressLint(value={"MissingPermission"})
    @RequiresApi(value=26)
    @MainThread
    @NonNull
    public Recording startRecording(@NonNull FileDescriptorOutputOptions outputOptions, @NonNull AudioConfig audioConfig, @NonNull Executor executor, @NonNull Consumer<VideoRecordEvent> listener) {
        return this.startRecordingInternal((OutputOptions)outputOptions, audioConfig, executor, listener);
    }

    @SuppressLint(value={"MissingPermission"})
    @MainThread
    @NonNull
    public Recording startRecording(@NonNull MediaStoreOutputOptions outputOptions, @NonNull AudioConfig audioConfig, @NonNull Executor executor, @NonNull Consumer<VideoRecordEvent> listener) {
        return this.startRecordingInternal((OutputOptions)outputOptions, audioConfig, executor, listener);
    }

    @RequiresPermission(value="android.permission.RECORD_AUDIO")
    @MainThread
    private Recording startRecordingInternal(@NonNull OutputOptions outputOptions, @NonNull AudioConfig audioConfig, @NonNull Executor executor, @NonNull Consumer<VideoRecordEvent> listener) {
        Threads.checkMainThread();
        Preconditions.checkState((boolean)this.isCameraInitialized(), (String)CAMERA_NOT_INITIALIZED);
        Preconditions.checkState((boolean)this.isVideoCaptureEnabled(), (String)VIDEO_CAPTURE_DISABLED);
        Preconditions.checkState((!this.isRecording() ? 1 : 0) != 0, (String)VIDEO_RECORDING_UNFINISHED);
        Consumer<VideoRecordEvent> wrappedListener = this.wrapListenerToDeactivateRecordingOnFinalized(listener);
        PendingRecording pendingRecording = this.prepareRecording(outputOptions);
        boolean isAudioEnabled = audioConfig.getAudioEnabled();
        if (isAudioEnabled) {
            this.checkAudioPermissionGranted();
            pendingRecording.withAudioEnabled();
        }
        Recording recording = pendingRecording.start(executor, wrappedListener);
        this.setActiveRecording(recording, wrappedListener);
        return recording;
    }

    private void checkAudioPermissionGranted() {
        int permissionState = PermissionChecker.checkSelfPermission((Context)this.mAppContext, (String)"android.permission.RECORD_AUDIO");
        if (permissionState == -1) {
            throw new SecurityException("Attempted to start recording with audio, but application does not have RECORD_AUDIO permission granted.");
        }
    }

    @MainThread
    private PendingRecording prepareRecording(@NonNull OutputOptions options) {
        Recorder recorder = (Recorder)this.mVideoCapture.getOutput();
        if (options instanceof FileOutputOptions) {
            return recorder.prepareRecording(this.mAppContext, (FileOutputOptions)options);
        }
        if (options instanceof FileDescriptorOutputOptions) {
            if (Build.VERSION.SDK_INT < 26) {
                throw new UnsupportedOperationException("File descriptors are not supported on pre-Android O (API 26) devices.");
            }
            return recorder.prepareRecording(this.mAppContext, (FileDescriptorOutputOptions)options);
        }
        if (options instanceof MediaStoreOutputOptions) {
            return recorder.prepareRecording(this.mAppContext, (MediaStoreOutputOptions)options);
        }
        throw new IllegalArgumentException("Unsupported OutputOptions type.");
    }

    private Consumer<VideoRecordEvent> wrapListenerToDeactivateRecordingOnFinalized(final @NonNull Consumer<VideoRecordEvent> listener) {
        final Executor mainExecutor = ContextCompat.getMainExecutor((Context)this.mAppContext);
        return new Consumer<VideoRecordEvent>(){

            public void accept(VideoRecordEvent videoRecordEvent) {
                if (videoRecordEvent instanceof VideoRecordEvent.Finalize) {
                    if (!Threads.isMainThread()) {
                        mainExecutor.execute(() -> CameraController.this.deactivateRecordingByListener(this));
                    } else {
                        CameraController.this.deactivateRecordingByListener(this);
                    }
                }
                listener.accept((Object)videoRecordEvent);
            }
        };
    }

    @MainThread
    void deactivateRecordingByListener(@NonNull Consumer<VideoRecordEvent> listener) {
        Recording recording = this.mRecordingMap.remove(listener);
        if (recording != null) {
            this.deactivateRecording(recording);
        }
    }

    @MainThread
    private void deactivateRecording(@NonNull Recording recording) {
        if (this.mActiveRecording == recording) {
            this.mActiveRecording = null;
        }
    }

    @MainThread
    private void setActiveRecording(@NonNull Recording recording, @NonNull Consumer<VideoRecordEvent> listener) {
        this.mRecordingMap.put(listener, recording);
        this.mActiveRecording = recording;
    }

    @MainThread
    private void stopRecording() {
        Threads.checkMainThread();
        if (this.mActiveRecording != null) {
            this.mActiveRecording.stop();
            this.deactivateRecording(this.mActiveRecording);
        }
    }

    @MainThread
    public boolean isRecording() {
        Threads.checkMainThread();
        return this.mActiveRecording != null && !this.mActiveRecording.isClosed();
    }

    @MainThread
    public void setVideoCaptureQualitySelector(@NonNull QualitySelector qualitySelector) {
        Threads.checkMainThread();
        this.mVideoCaptureQualitySelector = qualitySelector;
        this.unbindVideoAndRecreate();
        this.startCameraAndTrackStates();
    }

    @MainThread
    @NonNull
    public QualitySelector getVideoCaptureQualitySelector() {
        Threads.checkMainThread();
        return this.mVideoCaptureQualitySelector;
    }

    private void unbindVideoAndRecreate() {
        if (this.isCameraInitialized()) {
            this.mCameraProvider.unbind(new UseCase[]{this.mVideoCapture});
        }
        this.mVideoCapture = this.createNewVideoCapture();
    }

    private VideoCapture<Recorder> createNewVideoCapture() {
        return VideoCapture.withOutput((VideoOutput)CameraController.generateVideoCaptureRecorder(this.mVideoCaptureQualitySelector));
    }

    @MainThread
    public void setCameraSelector(@NonNull CameraSelector cameraSelector) {
        Threads.checkMainThread();
        if (this.mCameraSelector == cameraSelector) {
            return;
        }
        CameraSelector oldCameraSelector = this.mCameraSelector;
        this.mCameraSelector = cameraSelector;
        if (this.mCameraProvider == null) {
            return;
        }
        this.mCameraProvider.unbind(new UseCase[]{this.mPreview, this.mImageCapture, this.mImageAnalysis, this.mVideoCapture});
        this.startCameraAndTrackStates(() -> {
            this.mCameraSelector = oldCameraSelector;
        });
    }

    @MainThread
    public boolean hasCamera(@NonNull CameraSelector cameraSelector) {
        Threads.checkMainThread();
        Preconditions.checkNotNull((Object)cameraSelector);
        if (this.mCameraProvider == null) {
            throw new IllegalStateException("Camera not initialized. Please wait for the initialization future to finish. See #getInitializationFuture().");
        }
        try {
            return this.mCameraProvider.hasCamera(cameraSelector);
        }
        catch (CameraInfoUnavailableException e) {
            Logger.w((String)TAG, (String)"Failed to check camera availability", (Throwable)e);
            return false;
        }
    }

    @NonNull
    @MainThread
    public CameraSelector getCameraSelector() {
        Threads.checkMainThread();
        return this.mCameraSelector;
    }

    @MainThread
    public boolean isPinchToZoomEnabled() {
        Threads.checkMainThread();
        return this.mPinchToZoomEnabled;
    }

    @MainThread
    public void setPinchToZoomEnabled(boolean enabled) {
        Threads.checkMainThread();
        this.mPinchToZoomEnabled = enabled;
    }

    void onPinchToZoom(float pinchToZoomScale) {
        if (!this.isCameraAttached()) {
            Logger.w((String)TAG, (String)CAMERA_NOT_ATTACHED);
            return;
        }
        if (!this.mPinchToZoomEnabled) {
            Logger.d((String)TAG, (String)"Pinch to zoom disabled.");
            return;
        }
        Logger.d((String)TAG, (String)("Pinch to zoom with scale: " + pinchToZoomScale));
        ZoomState zoomState = (ZoomState)this.getZoomState().getValue();
        if (zoomState == null) {
            return;
        }
        float clampedRatio = zoomState.getZoomRatio() * this.speedUpZoomBy2X(pinchToZoomScale);
        clampedRatio = Math.min(Math.max(clampedRatio, zoomState.getMinZoomRatio()), zoomState.getMaxZoomRatio());
        this.setZoomRatio(clampedRatio);
    }

    private float speedUpZoomBy2X(float scaleFactor) {
        if (scaleFactor > 1.0f) {
            return 1.0f + (scaleFactor - 1.0f) * 2.0f;
        }
        return 1.0f - (1.0f - scaleFactor) * 2.0f;
    }

    void onTapToFocus(MeteringPointFactory meteringPointFactory, float x, float y) {
        if (!this.isCameraAttached()) {
            Logger.w((String)TAG, (String)CAMERA_NOT_ATTACHED);
            return;
        }
        if (!this.mTapToFocusEnabled) {
            Logger.d((String)TAG, (String)"Tap to focus disabled. ");
            return;
        }
        Logger.d((String)TAG, (String)("Tap to focus started: " + x + ", " + y));
        this.mTapToFocusState.postValue((Object)1);
        MeteringPoint afPoint = meteringPointFactory.createPoint(x, y, 0.16666667f);
        MeteringPoint aePoint = meteringPointFactory.createPoint(x, y, 0.25f);
        FocusMeteringAction focusMeteringAction = new FocusMeteringAction.Builder(afPoint, 1).addPoint(aePoint, 2).build();
        Futures.addCallback((ListenableFuture)this.mCamera.getCameraControl().startFocusAndMetering(focusMeteringAction), (FutureCallback)new FutureCallback<FocusMeteringResult>(){

            public void onSuccess(@Nullable FocusMeteringResult result) {
                if (result == null) {
                    return;
                }
                Logger.d((String)CameraController.TAG, (String)("Tap to focus onSuccess: " + result.isFocusSuccessful()));
                CameraController.this.mTapToFocusState.postValue((Object)(result.isFocusSuccessful() ? 2 : 3));
            }

            public void onFailure(@NonNull Throwable t) {
                if (t instanceof CameraControl.OperationCanceledException) {
                    Logger.d((String)CameraController.TAG, (String)"Tap-to-focus is canceled by new action.");
                    return;
                }
                Logger.d((String)CameraController.TAG, (String)"Tap to focus failed.", (Throwable)t);
                CameraController.this.mTapToFocusState.postValue((Object)4);
            }
        }, (Executor)CameraXExecutors.directExecutor());
    }

    @MainThread
    public boolean isTapToFocusEnabled() {
        Threads.checkMainThread();
        return this.mTapToFocusEnabled;
    }

    @MainThread
    public void setTapToFocusEnabled(boolean enabled) {
        Threads.checkMainThread();
        this.mTapToFocusEnabled = enabled;
    }

    @MainThread
    @NonNull
    public LiveData<Integer> getTapToFocusState() {
        Threads.checkMainThread();
        return this.mTapToFocusState;
    }

    @NonNull
    @MainThread
    public LiveData<ZoomState> getZoomState() {
        Threads.checkMainThread();
        return this.mZoomState;
    }

    @Nullable
    @MainThread
    public CameraInfo getCameraInfo() {
        Threads.checkMainThread();
        return this.mCamera == null ? null : this.mCamera.getCameraInfo();
    }

    @Nullable
    @MainThread
    public CameraControl getCameraControl() {
        Threads.checkMainThread();
        return this.mCamera == null ? null : this.mCamera.getCameraControl();
    }

    @NonNull
    @MainThread
    public ListenableFuture<Void> setZoomRatio(float zoomRatio) {
        Threads.checkMainThread();
        if (!this.isCameraAttached()) {
            return this.mPendingZoomRatio.setValue(Float.valueOf(zoomRatio));
        }
        return this.mCamera.getCameraControl().setZoomRatio(zoomRatio);
    }

    @NonNull
    @MainThread
    public ListenableFuture<Void> setLinearZoom(@FloatRange(from=0.0, to=1.0) float linearZoom) {
        Threads.checkMainThread();
        if (!this.isCameraAttached()) {
            return this.mPendingLinearZoom.setValue(Float.valueOf(linearZoom));
        }
        return this.mCamera.getCameraControl().setLinearZoom(linearZoom);
    }

    @NonNull
    @MainThread
    public LiveData<Integer> getTorchState() {
        Threads.checkMainThread();
        return this.mTorchState;
    }

    @NonNull
    @MainThread
    public ListenableFuture<Void> enableTorch(boolean torchEnabled) {
        Threads.checkMainThread();
        if (!this.isCameraAttached()) {
            return this.mPendingEnableTorch.setValue(torchEnabled);
        }
        return this.mCamera.getCameraControl().enableTorch(torchEnabled);
    }

    @MainThread
    public void setEffects(@NonNull Set<CameraEffect> effects) {
        Threads.checkMainThread();
        if (Objects.equals(this.mEffects, effects)) {
            return;
        }
        if (this.mCameraProvider != null) {
            this.mCameraProvider.unbindAll();
        }
        this.mEffects.clear();
        this.mEffects.addAll(effects);
        this.startCameraAndTrackStates();
    }

    @MainThread
    public void clearEffects() {
        Threads.checkMainThread();
        if (this.mCameraProvider != null) {
            this.mCameraProvider.unbindAll();
        }
        this.mEffects.clear();
        this.startCameraAndTrackStates();
    }

    void startCameraAndTrackStates() {
        this.startCameraAndTrackStates(null);
    }

    void startCameraAndTrackStates(@Nullable Runnable restoreStateRunnable) {
        try {
            this.mCamera = this.startCamera();
        }
        catch (RuntimeException exception) {
            if (restoreStateRunnable != null) {
                restoreStateRunnable.run();
            }
            throw exception;
        }
        if (!this.isCameraAttached()) {
            Logger.d((String)TAG, (String)CAMERA_NOT_ATTACHED);
            return;
        }
        this.mZoomState.setSource((LiveData<ZoomState>)this.mCamera.getCameraInfo().getZoomState());
        this.mTorchState.setSource((LiveData<Integer>)this.mCamera.getCameraInfo().getTorchState());
        this.mPendingEnableTorch.propagateIfHasValue((Function<Boolean, ListenableFuture<Void>>)((Function)this::enableTorch));
        this.mPendingLinearZoom.propagateIfHasValue((Function<Float, ListenableFuture<Void>>)((Function)this::setLinearZoom));
        this.mPendingZoomRatio.propagateIfHasValue((Function<Float, ListenableFuture<Void>>)((Function)this::setZoomRatio));
    }

    @Nullable
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected UseCaseGroup createUseCaseGroup() {
        if (!this.isCameraInitialized()) {
            Logger.d((String)TAG, (String)CAMERA_NOT_INITIALIZED);
            return null;
        }
        if (!this.isPreviewViewAttached()) {
            Logger.d((String)TAG, (String)PREVIEW_VIEW_NOT_ATTACHED);
            return null;
        }
        UseCaseGroup.Builder builder = new UseCaseGroup.Builder().addUseCase((UseCase)this.mPreview);
        if (this.isImageCaptureEnabled()) {
            builder.addUseCase((UseCase)this.mImageCapture);
        } else {
            this.mCameraProvider.unbind(new UseCase[]{this.mImageCapture});
        }
        if (this.isImageAnalysisEnabled()) {
            builder.addUseCase((UseCase)this.mImageAnalysis);
        } else {
            this.mCameraProvider.unbind(new UseCase[]{this.mImageAnalysis});
        }
        if (this.isVideoCaptureEnabled()) {
            builder.addUseCase(this.mVideoCapture);
        } else {
            this.mCameraProvider.unbind(new UseCase[]{this.mVideoCapture});
        }
        builder.setViewPort(this.mViewPort);
        for (CameraEffect effect : this.mEffects) {
            builder.addEffect(effect);
        }
        return builder.build();
    }

    @RequiresApi(value=21)
    public static final class OutputSize {
        public static final int UNASSIGNED_ASPECT_RATIO = -1;
        private final int mAspectRatio;
        @Nullable
        private final Size mResolution;

        public OutputSize(int aspectRatio) {
            Preconditions.checkArgument((aspectRatio != -1 ? 1 : 0) != 0);
            this.mAspectRatio = aspectRatio;
            this.mResolution = null;
        }

        public OutputSize(@NonNull Size resolution) {
            Preconditions.checkNotNull((Object)resolution);
            this.mAspectRatio = -1;
            this.mResolution = resolution;
        }

        public int getAspectRatio() {
            return this.mAspectRatio;
        }

        @Nullable
        public Size getResolution() {
            return this.mResolution;
        }

        @NonNull
        public String toString() {
            return "aspect ratio: " + this.mAspectRatio + " resolution: " + this.mResolution;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        public static @interface OutputAspectRatio {
        }
    }

    @RequiresApi(value=30)
    private static class Api30Impl {
        private Api30Impl() {
        }

        @DoNotInline
        @NonNull
        static Context createAttributionContext(@NonNull Context context, @Nullable String attributeTag) {
            return context.createAttributionContext(attributeTag);
        }

        @DoNotInline
        @Nullable
        static String getAttributionTag(@NonNull Context context) {
            return context.getAttributionTag();
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static @interface UseCases {
    }
}

