/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.view;

import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.arch.core.util.Function;
import androidx.camera.core.impl.utils.Threads;
import androidx.camera.core.impl.utils.futures.Futures;
import androidx.concurrent.futures.CallbackToFutureAdapter;
import androidx.core.util.Pair;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Objects;

@RequiresApi(api=21)
class PendingValue<T> {
    @Nullable
    private Pair<CallbackToFutureAdapter.Completer<Void>, T> mCompleterAndValue;

    PendingValue() {
    }

    @MainThread
    ListenableFuture<Void> setValue(@NonNull T value) {
        Threads.checkMainThread();
        return CallbackToFutureAdapter.getFuture(completer -> {
            if (this.mCompleterAndValue != null) {
                Objects.requireNonNull((CallbackToFutureAdapter.Completer)this.mCompleterAndValue.first).setCancelled();
            }
            this.mCompleterAndValue = new Pair((Object)completer, value);
            return "PendingValue " + value;
        });
    }

    @MainThread
    void propagateIfHasValue(Function<T, ListenableFuture<Void>> setValueFunction) {
        Threads.checkMainThread();
        if (this.mCompleterAndValue != null) {
            Futures.propagate((ListenableFuture)((ListenableFuture)setValueFunction.apply(this.mCompleterAndValue.second)), (CallbackToFutureAdapter.Completer)Objects.requireNonNull((CallbackToFutureAdapter.Completer)this.mCompleterAndValue.first));
            this.mCompleterAndValue = null;
        }
    }
}

