/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.view;

import android.graphics.Matrix;
import android.graphics.PointF;
import android.util.Size;
import androidx.annotation.AnyThread;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.annotation.UiThread;
import androidx.camera.core.MeteringPointFactory;
import androidx.camera.core.impl.utils.Threads;
import androidx.camera.view.PreviewTransformation;

@RequiresApi(value=21)
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
class PreviewViewMeteringPointFactory
extends MeteringPointFactory {
    static final PointF INVALID_POINT = new PointF(2.0f, 2.0f);
    @NonNull
    private final PreviewTransformation mPreviewTransformation;
    @GuardedBy(value="this")
    @Nullable
    private Matrix mMatrix;

    PreviewViewMeteringPointFactory(@NonNull PreviewTransformation previewTransformation) {
        this.mPreviewTransformation = previewTransformation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AnyThread
    @NonNull
    protected PointF convertPoint(float x, float y) {
        float[] point = new float[]{x, y};
        PreviewViewMeteringPointFactory previewViewMeteringPointFactory = this;
        synchronized (previewViewMeteringPointFactory) {
            if (this.mMatrix == null) {
                return INVALID_POINT;
            }
            this.mMatrix.mapPoints(point);
        }
        return new PointF(point[0], point[1]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UiThread
    void recalculate(@NonNull Size previewViewSize, int layoutDirection) {
        Threads.checkMainThread();
        PreviewViewMeteringPointFactory previewViewMeteringPointFactory = this;
        synchronized (previewViewMeteringPointFactory) {
            if (previewViewSize.getWidth() == 0 || previewViewSize.getHeight() == 0) {
                this.mMatrix = null;
                return;
            }
            this.mMatrix = this.mPreviewTransformation.getPreviewViewToNormalizedSurfaceMatrix(previewViewSize, layoutDirection);
        }
    }
}

