/*
 * Decompiled with CFR 0.152.
 */
package androidx.collection;

import androidx.collection.IndexBasedArrayIterator;
import androidx.collection.internal.ContainerHelpersKt;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.AbstractMutableCollection;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMutableSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0011\n\u0002\u0010)\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\u0018\u0000 :*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0002:;B\u0019\b\u0016\u0012\u0010\u0010\u0004\u001a\f\u0012\u0006\b\u0001\u0012\u00028\u0000\u0018\u00010\u0000\u00a2\u0006\u0002\u0010\u0005B\u0017\b\u0016\u0012\u000e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007B\u0019\b\u0016\u0012\u0010\u0010\b\u001a\f\u0012\u0006\b\u0001\u0012\u00028\u0000\u0018\u00010\t\u00a2\u0006\u0002\u0010\nB\u0011\b\u0007\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0015\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0019J\u0016\u0010\u001a\u001a\u00020\u001b2\u000e\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u0000J\u0016\u0010\u001a\u001a\u00020\u00172\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006H\u0016J\u0010\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u0013\u001a\u00020\fH\u0002J\u0010\u0010\u001e\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020\fH\u0002J\b\u0010 \u001a\u00020\u001bH\u0016J\u0016\u0010!\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u0019J\u0016\u0010\"\u001a\u00020\u00172\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006H\u0016J\u000e\u0010#\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020\fJ\u0013\u0010%\u001a\u00020\u00172\b\u0010&\u001a\u0004\u0018\u00010\u000fH\u0096\u0002J\b\u0010'\u001a\u00020\fH\u0016J\u0010\u0010(\u001a\u00020\f2\b\u0010)\u001a\u0004\u0018\u00010\u000fJ\u001a\u0010(\u001a\u00020\f2\b\u0010)\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001f\u001a\u00020\fH\u0002J\b\u0010*\u001a\u00020\fH\u0002J\b\u0010+\u001a\u00020\u0017H\u0016J\u000f\u0010,\u001a\b\u0012\u0004\u0012\u00028\u00000-H\u0096\u0002J\u0017\u0010.\u001a\u00020\u001b2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020100H\u0082\bJ\u0015\u00102\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0019J\u0016\u00103\u001a\u00020\u00172\u000e\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u0000J\u0016\u00103\u001a\u00020\u00172\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006H\u0016J\u0013\u00104\u001a\u00028\u00002\u0006\u00105\u001a\u00020\f\u00a2\u0006\u0002\u00106J\u0016\u00107\u001a\u00020\u00172\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006H\u0016J\b\u00108\u001a\u000201H\u0016J\u0013\u00109\u001a\u00028\u00002\u0006\u00105\u001a\u00020\f\u00a2\u0006\u0002\u00106R\u000e\u0010\u000e\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\tX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006<"}, d2={"Landroidx/collection/ArraySet;", "E", "Lkotlin/collections/AbstractMutableCollection;", "", "set", "(Landroidx/collection/ArraySet;)V", "", "(Ljava/util/Collection;)V", "array", "", "([Ljava/lang/Object;)V", "capacity", "", "(I)V", "_size", "", "[Ljava/lang/Object;", "hashes", "", "size", "getSize", "()I", "add", "", "element", "(Ljava/lang/Object;)Z", "addAll", "", "elements", "allocArrays", "binarySearchInternal", "hash", "clear", "contains", "containsAll", "ensureCapacity", "minimumCapacity", "equals", "other", "hashCode", "indexOf", "key", "indexOfNull", "isEmpty", "iterator", "", "printlnIfDebug", "message", "Lkotlin/Function0;", "", "remove", "removeAll", "removeAt", "index", "(I)Ljava/lang/Object;", "retainAll", "toString", "valueAt", "Companion", "ElementIterator", "collection"})
public final class ArraySet<E>
extends AbstractMutableCollection<E>
implements Set<E>,
KMutableSet {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private int[] hashes;
    @NotNull
    private Object[] array;
    private int _size;
    @Deprecated
    private static final boolean DEBUG = false;
    @Deprecated
    @NotNull
    private static final String TAG = "ArraySet";
    @Deprecated
    private static final int BASE_SIZE = 4;

    @JvmOverloads
    public ArraySet(int capacity) {
        this.hashes = ContainerHelpersKt.EMPTY_INTS;
        this.array = ContainerHelpersKt.EMPTY_OBJECTS;
        if (capacity > 0) {
            this.allocArrays(capacity);
        }
    }

    public /* synthetic */ ArraySet(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        this(n);
    }

    public int getSize() {
        return this._size;
    }

    public ArraySet(@Nullable ArraySet<? extends E> set) {
        this(0);
        if (set != null) {
            this.addAll(set);
        }
    }

    public ArraySet(@Nullable Collection<? extends E> set) {
        this(0);
        if (set != null) {
            this.addAll(set);
        }
    }

    public ArraySet(@Nullable E[] array) {
        this(0);
        if (array != null) {
            Iterator iterator = ArrayIteratorKt.iterator((Object[])array);
            while (iterator.hasNext()) {
                Object value = iterator.next();
                this.add(value);
            }
        }
    }

    private final int binarySearchInternal(int hash) {
        int n;
        try {
            n = ContainerHelpersKt.binarySearch(this.hashes, this._size, hash);
        }
        catch (IndexOutOfBoundsException e) {
            throw new ConcurrentModificationException();
        }
        return n;
    }

    private final int indexOf(Object key, int hash) {
        int end;
        int n = this._size;
        if (n == 0) {
            return -1;
        }
        int index = this.binarySearchInternal(hash);
        if (index < 0) {
            return index;
        }
        if (Intrinsics.areEqual((Object)key, (Object)this.array[index])) {
            return index;
        }
        for (end = index + 1; end < n && this.hashes[end] == hash; ++end) {
            if (!Intrinsics.areEqual((Object)key, (Object)this.array[end])) continue;
            return end;
        }
        for (int i = index - 1; i >= 0 && this.hashes[i] == hash; --i) {
            if (!Intrinsics.areEqual((Object)key, (Object)this.array[i])) continue;
            return i;
        }
        return ~end;
    }

    private final int indexOfNull() {
        return this.indexOf(null, 0);
    }

    private final void allocArrays(int size) {
        this.hashes = new int[size];
        this.array = new Object[size];
    }

    private final void printlnIfDebug(Function0<String> message) {
        boolean $i$f$printlnIfDebug = false;
    }

    @Override
    public void clear() {
        if (this._size != 0) {
            this.hashes = ContainerHelpersKt.EMPTY_INTS;
            this.array = ContainerHelpersKt.EMPTY_OBJECTS;
            this._size = 0;
        }
        if (this._size != 0) {
            throw new ConcurrentModificationException();
        }
    }

    public final void ensureCapacity(int minimumCapacity) {
        int oSize = this._size;
        if (this.hashes.length < minimumCapacity) {
            int[] ohashes = this.hashes;
            Object[] oarray = this.array;
            this.allocArrays(minimumCapacity);
            if (this._size > 0) {
                ArraysKt.copyInto$default((int[])ohashes, (int[])this.hashes, (int)0, (int)0, (int)this._size, (int)6, null);
                ArraysKt.copyInto$default((Object[])oarray, (Object[])this.array, (int)0, (int)0, (int)this._size, (int)6, null);
            }
        }
        if (this._size != oSize) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public boolean contains(Object element) {
        return this.indexOf(element) >= 0;
    }

    public final int indexOf(@Nullable Object key) {
        Object object = key;
        return object == null ? this.indexOfNull() : this.indexOf(object, key.hashCode());
    }

    public final E valueAt(int index) {
        return (E)this.array[index];
    }

    @Override
    public boolean isEmpty() {
        return this._size <= 0;
    }

    @Override
    public boolean add(E element) {
        int oSize = this._size;
        int hash = 0;
        int index = 0;
        if (element == null) {
            hash = 0;
            index = this.indexOfNull();
        } else {
            hash = element.hashCode();
            index = this.indexOf(element, hash);
        }
        if (index >= 0) {
            return false;
        }
        index ^= 0xFFFFFFFF;
        if (oSize >= this.hashes.length) {
            int n = oSize >= 8 ? oSize + (oSize >> 1) : (oSize >= 4 ? 8 : 4);
            ArraySet this_$iv = this;
            boolean $i$f$printlnIfDebug = false;
            int[] ohashes = this.hashes;
            Object[] oarray = this.array;
            this.allocArrays(n);
            if (oSize != this._size) {
                throw new ConcurrentModificationException();
            }
            if (!(this.hashes.length == 0)) {
                ArraySet this_$iv2 = this;
                boolean $i$f$printlnIfDebug2 = false;
                ArraysKt.copyInto$default((int[])ohashes, (int[])this.hashes, (int)0, (int)0, (int)ohashes.length, (int)6, null);
                ArraysKt.copyInto$default((Object[])oarray, (Object[])this.array, (int)0, (int)0, (int)oarray.length, (int)6, null);
            }
        }
        if (index < oSize) {
            ArraySet this_$iv = this;
            boolean $i$f$printlnIfDebug = false;
            ArraysKt.copyInto((int[])this.hashes, (int[])this.hashes, (int)(index + 1), (int)index, (int)oSize);
            ArraysKt.copyInto((Object[])this.array, (Object[])this.array, (int)(index + 1), (int)index, (int)oSize);
        }
        if (oSize != this._size || index >= this.hashes.length) {
            throw new ConcurrentModificationException();
        }
        this.hashes[index] = hash;
        this.array[index] = element;
        int n = this._size;
        this._size = n + 1;
        return true;
    }

    public final void addAll(@NotNull ArraySet<? extends E> array) {
        Intrinsics.checkNotNullParameter(array, (String)"array");
        int n = array._size;
        this.ensureCapacity(this._size + n);
        if (this._size == 0) {
            if (n > 0) {
                ArraysKt.copyInto$default((int[])array.hashes, (int[])this.hashes, (int)0, (int)0, (int)n, (int)6, null);
                ArraysKt.copyInto$default((Object[])array.array, (Object[])this.array, (int)0, (int)0, (int)n, (int)6, null);
                if (this._size != 0) {
                    throw new ConcurrentModificationException();
                }
                this._size = n;
            }
        } else {
            for (int i = 0; i < n; ++i) {
                this.add(array.valueAt(i));
            }
        }
    }

    @Override
    public boolean remove(Object element) {
        int index = this.indexOf(element);
        if (index >= 0) {
            this.removeAt(index);
            return true;
        }
        return false;
    }

    public final E removeAt(int index) {
        int oSize = this._size;
        Object old = this.array[index];
        if (oSize <= 1) {
            ArraySet this_$iv = this;
            boolean $i$f$printlnIfDebug = false;
            this.clear();
        } else {
            int nSize = oSize - 1;
            if (this.hashes.length > 8 && this._size < this.hashes.length / 3) {
                boolean $i$f$printlnIfDebug;
                ArraySet this_$iv;
                int n = this._size > 8 ? this._size + (this._size >> 1) : 8;
                ArraySet this_$iv2 = this;
                boolean $i$f$printlnIfDebug2 = false;
                int[] ohashes = this.hashes;
                Object[] oarray = this.array;
                this.allocArrays(n);
                if (index > 0) {
                    this_$iv = this;
                    $i$f$printlnIfDebug = false;
                    ArraysKt.copyInto$default((int[])ohashes, (int[])this.hashes, (int)0, (int)0, (int)index, (int)6, null);
                    ArraysKt.copyInto$default((Object[])oarray, (Object[])this.array, (int)0, (int)0, (int)index, (int)6, null);
                }
                if (index < nSize) {
                    this_$iv = this;
                    $i$f$printlnIfDebug = false;
                    ArraysKt.copyInto((int[])ohashes, (int[])this.hashes, (int)index, (int)(index + 1), (int)(nSize + 1));
                    ArraysKt.copyInto((Object[])oarray, (Object[])this.array, (int)index, (int)(index + 1), (int)(nSize + 1));
                }
            } else {
                if (index < nSize) {
                    ArraySet this_$iv = this;
                    boolean $i$f$printlnIfDebug = false;
                    ArraysKt.copyInto((int[])this.hashes, (int[])this.hashes, (int)index, (int)(index + 1), (int)(nSize + 1));
                    ArraysKt.copyInto((Object[])this.array, (Object[])this.array, (int)index, (int)(index + 1), (int)(nSize + 1));
                }
                this.array[nSize] = null;
            }
            if (oSize != this._size) {
                throw new ConcurrentModificationException();
            }
            this._size = nSize;
        }
        return (E)old;
    }

    @Override
    public final boolean removeAll(@NotNull ArraySet<? extends E> array) {
        Intrinsics.checkNotNullParameter(array, (String)"array");
        int n = array._size;
        int originalSize = this._size;
        for (int i = 0; i < n; ++i) {
            this.remove(array.valueAt(i));
        }
        return originalSize != this._size;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Set) {
            if (this.size() != ((Set)other).size()) {
                return false;
            }
            try {
                int n = this._size;
                for (int i = 0; i < n; ++i) {
                    E mine = this.valueAt(i);
                    if (((Set)other).contains(mine)) continue;
                    return false;
                }
            }
            catch (NullPointerException ignored) {
                return false;
            }
            catch (ClassCastException ignored) {
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int[] hashes = this.hashes;
        int s = this._size;
        int result = 0;
        for (int i = 0; i < s; ++i) {
            result += hashes[i];
        }
        return result;
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder;
        if (this.isEmpty()) {
            return "{}";
        }
        int n = this._size * 14;
        StringBuilder $this$toString_u24lambda_u248 = stringBuilder = new StringBuilder(n);
        boolean bl = false;
        $this$toString_u24lambda_u248.append('{');
        int n2 = this._size;
        for (int i = 0; i < n2; ++i) {
            E value;
            if (i > 0) {
                $this$toString_u24lambda_u248.append(", ");
            }
            if ((value = this.valueAt(i)) != this) {
                $this$toString_u24lambda_u248.append(value);
                continue;
            }
            $this$toString_u24lambda_u248.append("(this Set)");
        }
        $this$toString_u24lambda_u248.append('}');
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder(capacity).\u2026builderAction).toString()");
        return string;
    }

    @Override
    @NotNull
    public Iterator<E> iterator() {
        return new ElementIterator();
    }

    @Override
    public boolean containsAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        for (Object object : elements) {
            if (this.contains(object)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends E> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        this.ensureCapacity(this._size + elements.size());
        boolean added = false;
        for (E value : elements) {
            added = this.add(value) | added;
        }
        return added;
    }

    @Override
    public boolean removeAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        boolean removed = false;
        for (Object object : elements) {
            removed |= this.remove(object);
        }
        return removed;
    }

    @Override
    public boolean retainAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        boolean removed = false;
        for (int i = this._size - 1; -1 < i; --i) {
            if (CollectionsKt.contains((Iterable)elements, (Object)this.array[i])) continue;
            this.removeAt(i);
            removed = true;
        }
        return removed;
    }

    @JvmOverloads
    public ArraySet() {
        this(0, 1, null);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00028\u00000\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0003\u001a\u00028\u00002\u0006\u0010\u0004\u001a\u00020\u0005H\u0014\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00020\u0005H\u0014\u00a8\u0006\t"}, d2={"Landroidx/collection/ArraySet$ElementIterator;", "Landroidx/collection/IndexBasedArrayIterator;", "(Landroidx/collection/ArraySet;)V", "elementAt", "index", "", "(I)Ljava/lang/Object;", "removeAt", "", "collection"})
    private final class ElementIterator
    extends IndexBasedArrayIterator<E> {
        public ElementIterator() {
            super(ArraySet.this._size);
        }

        @Override
        protected E elementAt(int index) {
            return ArraySet.this.valueAt(index);
        }

        @Override
        protected void removeAt(int index) {
            ArraySet.this.removeAt(index);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Landroidx/collection/ArraySet$Companion;", "", "()V", "BASE_SIZE", "", "DEBUG", "", "TAG", "", "collection"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

