/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.CancelScheduleSend: ImageVector
    get() {
        if (_cancelScheduleSend != null) {
            return _cancelScheduleSend!!
        }
        _cancelScheduleSend = materialIcon(name = "Filled.CancelScheduleSend") {
            materialPath {
                moveTo(16.5f, 9.0f)
                curveToRelative(-0.42f, 0.0f, -0.83f, 0.04f, -1.24f, 0.11f)
                lineTo(1.01f, 3.0f)
                lineTo(1.0f, 10.0f)
                lineToRelative(9.0f, 2.0f)
                lineToRelative(-9.0f, 2.0f)
                lineToRelative(0.01f, 7.0f)
                lineToRelative(8.07f, -3.46f)
                curveTo(9.59f, 21.19f, 12.71f, 24.0f, 16.5f, 24.0f)
                curveToRelative(4.14f, 0.0f, 7.5f, -3.36f, 7.5f, -7.5f)
                reflectiveCurveTo(20.64f, 9.0f, 16.5f, 9.0f)
                close()
                moveTo(16.5f, 22.0f)
                curveToRelative(-3.03f, 0.0f, -5.5f, -2.47f, -5.5f, -5.5f)
                reflectiveCurveToRelative(2.47f, -5.5f, 5.5f, -5.5f)
                reflectiveCurveToRelative(5.5f, 2.47f, 5.5f, 5.5f)
                reflectiveCurveTo(19.53f, 22.0f, 16.5f, 22.0f)
                close()
            }
            materialPath {
                moveTo(18.27f, 14.03f)
                lineToRelative(-1.77f, 1.76f)
                lineToRelative(-1.77f, -1.76f)
                lineToRelative(-0.7f, 0.7f)
                lineToRelative(1.76f, 1.77f)
                lineToRelative(-1.76f, 1.77f)
                lineToRelative(0.7f, 0.7f)
                lineToRelative(1.77f, -1.76f)
                lineToRelative(1.77f, 1.76f)
                lineToRelative(0.7f, -0.7f)
                lineToRelative(-1.76f, -1.77f)
                lineToRelative(1.76f, -1.77f)
                close()
            }
        }
        return _cancelScheduleSend!!
    }

private var _cancelScheduleSend: ImageVector? = null
