/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.DirectionsOff: ImageVector
    get() {
        if (_directionsOff != null) {
            return _directionsOff!!
        }
        _directionsOff = materialIcon(name = "Filled.DirectionsOff") {
            materialPath {
                moveTo(12.83f, 10.0f)
                horizontalLineToRelative(0.67f)
                verticalLineTo(7.5f)
                lineTo(17.0f, 11.0f)
                lineToRelative(-1.59f, 1.59f)
                lineTo(18.83f, 16.0f)
                lineToRelative(2.59f, -2.59f)
                curveToRelative(0.78f, -0.78f, 0.78f, -2.05f, 0.0f, -2.83f)
                lineToRelative(-7.99f, -8.0f)
                curveToRelative(-0.78f, -0.78f, -2.05f, -0.78f, -2.83f, 0.0f)
                lineTo(8.0f, 5.17f)
                lineTo(12.83f, 10.0f)
                close()
            }
            materialPath {
                moveTo(2.81f, 2.81f)
                lineTo(1.39f, 4.22f)
                lineTo(5.17f, 8.0f)
                lineToRelative(-2.59f, 2.59f)
                curveToRelative(-0.78f, 0.78f, -0.78f, 2.05f, 0.0f, 2.83f)
                lineToRelative(8.01f, 8.0f)
                curveToRelative(0.78f, 0.78f, 2.05f, 0.78f, 2.83f, 0.0f)
                lineTo(16.0f, 18.83f)
                lineToRelative(3.78f, 3.78f)
                lineToRelative(1.41f, -1.41f)
                lineTo(2.81f, 2.81f)
                close()
                moveTo(10.0f, 15.0f)
                horizontalLineTo(8.0f)
                verticalLineToRelative(-4.0f)
                curveToRelative(0.0f, -0.05f, 0.02f, -0.09f, 0.03f, -0.14f)
                lineTo(10.0f, 12.83f)
                verticalLineTo(15.0f)
                close()
            }
        }
        return _directionsOff!!
    }

private var _directionsOff: ImageVector? = null
