/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector
import kotlin.Deprecated

@Deprecated(
    "Use the AutoMirrored version at Icons.AutoMirrored.Outlined.AssistantDirection",
    ReplaceWith( "Icons.AutoMirrored.Outlined.AssistantDirection",
            "androidx.compose.material.icons.automirrored.outlined.AssistantDirection"),
)
public val Icons.Outlined.AssistantDirection: ImageVector
    get() {
        if (_assistantDirection != null) {
            return _assistantDirection!!
        }
        _assistantDirection = materialIcon(name = "Outlined.AssistantDirection") {
            materialPath {
                moveTo(12.0f, 1.0f)
                curveTo(5.9f, 1.0f, 1.0f, 5.9f, 1.0f, 12.0f)
                reflectiveCurveToRelative(4.9f, 11.0f, 11.0f, 11.0f)
                reflectiveCurveToRelative(11.0f, -4.9f, 11.0f, -11.0f)
                reflectiveCurveTo(18.1f, 1.0f, 12.0f, 1.0f)
                close()
                moveTo(12.0f, 21.0f)
                curveToRelative(-4.99f, 0.0f, -9.0f, -4.01f, -9.0f, -9.0f)
                reflectiveCurveToRelative(4.01f, -9.0f, 9.0f, -9.0f)
                reflectiveCurveToRelative(9.0f, 4.01f, 9.0f, 9.0f)
                reflectiveCurveTo(16.99f, 21.0f, 12.0f, 21.0f)
                close()
            }
            materialPath {
                moveTo(19.73f, 11.42f)
                lineTo(12.54f, 4.2f)
                curveToRelative(-0.36f, -0.27f, -0.8f, -0.27f, -1.15f, 0.0f)
                lineTo(4.2f, 11.42f)
                curveToRelative(-0.27f, 0.36f, -0.27f, 0.8f, 0.0f, 1.16f)
                lineToRelative(7.19f, 7.22f)
                curveToRelative(0.36f, 0.27f, 0.8f, 0.27f, 1.15f, 0.0f)
                lineToRelative(7.19f, -7.22f)
                curveTo(20.09f, 12.22f, 20.09f, 11.69f, 19.73f, 11.42f)
                close()
                moveTo(13.5f, 14.5f)
                lineToRelative(-1.41f, -1.41f)
                lineTo(13.17f, 12.0f)
                horizontalLineTo(10.0f)
                verticalLineToRelative(3.0f)
                horizontalLineTo(8.0f)
                verticalLineToRelative(-4.0f)
                curveToRelative(0.0f, -0.6f, 0.4f, -1.0f, 1.0f, -1.0f)
                horizontalLineToRelative(4.17f)
                lineToRelative(-1.09f, -1.09f)
                lineTo(13.5f, 7.5f)
                lineTo(17.0f, 11.0f)
                lineTo(13.5f, 14.5f)
                close()
            }
        }
        return _assistantDirection!!
    }

private var _assistantDirection: ImageVector? = null
