/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.ExposureNeg1: ImageVector
    get() {
        if (_exposureNeg1 != null) {
            return _exposureNeg1!!
        }
        _exposureNeg1 = materialIcon(name = "Outlined.ExposureNeg1") {
            materialPath {
                moveTo(4.0f, 11.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(8.0f)
                verticalLineToRelative(-2.0f)
                lineTo(4.0f, 11.0f)
                close()
                moveTo(19.0f, 18.0f)
                horizontalLineToRelative(-2.0f)
                lineTo(17.0f, 7.38f)
                lineTo(14.0f, 8.4f)
                lineTo(14.0f, 6.7f)
                lineTo(18.7f, 5.0f)
                horizontalLineToRelative(0.3f)
                verticalLineToRelative(13.0f)
                close()
            }
        }
        return _exposureNeg1!!
    }

private var _exposureNeg1: ImageVector? = null
